/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFTrophy
extends ItemTF {
    private static final String[] trophyTypes = new String[]{"hydra", "naga", "lich", "ur-ghast", "snowQueen"};
    public static final String[] trophyTextures = new String[]{"hydraTrophy", "nagaTrophy", "lichTrophy", "urGhastTrophy", "snowQueenTrophy"};
    public IIcon[] trophyIcons;

    public ItemTFTrophy() {
        this.setCreativeTab(TFItems.creativeTab);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < trophyTypes.length; ++j) {
            par3List.add(new ItemStack(par1, 1, j));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public boolean onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int direction, float par8, float par9, float par10) {
        TileEntity tileEntity;
        if (direction == 0) {
            return false;
        }
        if (!world.getBlock(x, y, z).getMaterial().isSolid()) {
            return false;
        }
        if (direction == 1) {
            ++y;
        }
        if (direction == 2) {
            --z;
        }
        if (direction == 3) {
            ++z;
        }
        if (direction == 4) {
            --x;
        }
        if (direction == 5) {
            ++x;
        }
        if (!player.canPlayerEdit(x, y, z, direction, itemStack)) {
            return false;
        }
        if (!TFBlocks.trophy.canPlaceBlockAt(world, x, y, z)) {
            return false;
        }
        world.setBlock(x, y, z, TFBlocks.trophy, direction, 3);
        int skullRotate = 0;
        if (direction == 1) {
            skullRotate = MathHelper.floor_double((double)((double)(player.rotationYaw * 16.0f / 360.0f) + 0.5)) & 0xF;
        }
        if ((tileEntity = world.getTileEntity(x, y, z)) != null && tileEntity instanceof TileEntitySkull) {
            TileEntitySkull skull = (TileEntitySkull)tileEntity;
            NBTTagCompound tags = new NBTTagCompound();
            skull.writeToNBT(tags);
            tags.setByte("SkullType", (byte)(itemStack.getItemDamage() & 0xFF));
            skull.readFromNBT(tags);
            skull.func_145903_a(skullRotate);
        }
        --itemStack.stackSize;
        return true;
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        int i = par1ItemStack.getItemDamage();
        if (i < 0 || i >= trophyTypes.length) {
            i = 0;
        }
        return super.getUnlocalizedName() + "." + trophyTypes[i];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.trophyIcons = new IIcon[trophyTextures.length];
        for (int i = 0; i < trophyTextures.length; ++i) {
            this.trophyIcons[i] = par1IconRegister.registerIcon("TwilightForest:" + trophyTextures[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        if (par1 < 0 || par1 >= trophyTypes.length) {
            par1 = 0;
        }
        return this.trophyIcons[par1];
    }
}

