/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import twilightforest.entity.TFCreatures;
import twilightforest.entity.TFEntityEggInfo;
import twilightforest.item.TFItems;

public class ItemTFSpawnEgg
extends ItemMonsterPlacer {
    protected ItemTFSpawnEgg() {
        this.setHasSubtypes(true);
        this.setCreativeTab(TFItems.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack itemStack, int par2) {
        TFEntityEggInfo info = TFCreatures.entityEggs.get(itemStack.getItemDamage());
        return info != null ? (par2 == 0 ? info.primaryColor : info.secondaryColor) : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public String getItemStackDisplayName(ItemStack itemStack) {
        String prefix = String.valueOf(StatCollector.translateToLocal((String)(this.getUnlocalizedName() + ".name"))).trim();
        String entityname = TFCreatures.getStringFromID(itemStack.getItemDamage());
        if (entityname != null) {
            prefix = prefix + " " + StatCollector.translateToLocal((String)String.format("entity.%s.%s.name", "TwilightForest", entityname));
        }
        return prefix;
    }

    public boolean onItemUse(ItemStack itemStack, EntityPlayer player, World world, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        Entity entity;
        if (world.isRemote) {
            return true;
        }
        Block var11 = world.getBlock(par4, par5, par6);
        par4 += Facing.offsetsXForSide[par7];
        par5 += Facing.offsetsYForSide[par7];
        par6 += Facing.offsetsZForSide[par7];
        double var12 = 0.0;
        if (par7 == 1 && var11 == Blocks.fence || var11 == Blocks.nether_brick_fence) {
            var12 = 0.5;
        }
        if ((entity = ItemTFSpawnEgg.spawnCreature(world, itemStack.getItemDamage(), (double)par4 + 0.5, (double)par5 + var12, (double)par6 + 0.5)) != null) {
            if (entity instanceof EntityLiving && itemStack.hasDisplayName()) {
                ((EntityLiving)entity).setCustomNameTag(itemStack.getDisplayName());
            }
            if (!player.capabilities.isCreativeMode) {
                --itemStack.stackSize;
            }
        }
        return true;
    }

    public static Entity spawnCreature(World world, int par1, double par2, double par4, double par6) {
        if (!TFCreatures.entityEggs.containsKey(par1)) {
            return null;
        }
        Entity entityToSpawn = TFCreatures.createEntityByID(par1, world);
        if (entityToSpawn != null && entityToSpawn instanceof EntityLivingBase) {
            EntityLiving entityliving = (EntityLiving)entityToSpawn;
            entityToSpawn.setLocationAndAngles(par2, par4, par6, world.rand.nextFloat() * 360.0f, 0.0f);
            entityliving.onSpawnWithEgg((IEntityLivingData)null);
            world.spawnEntityInWorld(entityToSpawn);
            ((EntityLiving)entityToSpawn).playLivingSound();
        }
        return entityToSpawn;
    }

    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (TFEntityEggInfo var5 : TFCreatures.entityEggs.values()) {
            itemList.add(new ItemStack(item, 1, var5.spawnedID));
        }
    }

    public IIcon getIconFromDamageForRenderPass(int par1, int par2) {
        return Items.spawn_egg.getIconFromDamageForRenderPass(par1, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
    }
}

