/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFScepterLifeDrain
extends ItemTF {
    protected ItemTFScepterLifeDrain() {
        this.maxStackSize = 1;
        this.setMaxDamage(99);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World worldObj, EntityPlayer player) {
        if (par1ItemStack.getItemDamage() < this.getMaxDamage()) {
            player.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        } else {
            player.stopUsingItem();
        }
        return par1ItemStack;
    }

    public static void animateTargetShatter(World worldObj, EntityLivingBase target) {
        for (int var1 = 0; var1 < 50; ++var1) {
            double gaussX = itemRand.nextGaussian() * 0.02;
            double gaussY = itemRand.nextGaussian() * 0.02;
            double gaussZ = itemRand.nextGaussian() * 0.02;
            double gaussFactor = 10.0;
            Item popItem = ItemTFScepterLifeDrain.getTargetDropItemId(target) != null ? ItemTFScepterLifeDrain.getTargetDropItemId(target) : Items.rotten_flesh;
            worldObj.spawnParticle("iconcrack_" + Item.getIdFromItem((Item)popItem), target.posX + (double)(itemRand.nextFloat() * target.width * 2.0f) - (double)target.width - gaussX * gaussFactor, target.posY + (double)(itemRand.nextFloat() * target.height) - gaussY * gaussFactor, target.posZ + (double)(itemRand.nextFloat() * target.width * 2.0f) - (double)target.width - gaussZ * gaussFactor, gaussX, gaussY, gaussZ);
        }
    }

    public static Item getTargetDropItemId(EntityLivingBase target) {
        return Items.rotten_flesh;
    }

    private Entity getPlayerLookTarget(World worldObj, EntityPlayer player) {
        Entity pointedEntity = null;
        double range = 20.0;
        Vec3 srcVec = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 lookVec = player.getLook(1.0f);
        Vec3 destVec = srcVec.addVector(lookVec.xCoord * range, lookVec.yCoord * range, lookVec.zCoord * range);
        float var9 = 1.0f;
        List possibleList = worldObj.getEntitiesWithinAABBExcludingEntity((Entity)player, player.boundingBox.addCoord(lookVec.xCoord * range, lookVec.yCoord * range, lookVec.zCoord * range).expand((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.canBeCollidedWith()) continue;
            float borderSize = possibleEntity.getCollisionBorderSize();
            AxisAlignedBB collisionBB = possibleEntity.boundingBox.expand((double)borderSize, (double)borderSize, (double)borderSize);
            MovingObjectPosition interceptPos = collisionBB.calculateIntercept(srcVec, destVec);
            if (collisionBB.isVecInside(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (interceptPos == null || !((possibleDist = srcVec.distanceTo(interceptPos.hitVec)) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        Entity pointedEntity;
        World worldObj = player.worldObj;
        if (stack.getItemDamage() >= this.getMaxDamage()) {
            player.stopUsingItem();
            return;
        }
        if (count % 5 == 0 && (pointedEntity = this.getPlayerLookTarget(worldObj, player)) != null && pointedEntity instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)pointedEntity;
            if (target.getActivePotionEffect(Potion.moveSlowdown) != null || target.getHealth() < 1.0f) {
                if (target.getHealth() <= 3.0f) {
                    this.makeRedMagicTrail(worldObj, player.posX, player.posY + (double)player.getEyeHeight(), player.posZ, target.posX, target.posY + (double)target.getEyeHeight(), target.posZ);
                    if (target instanceof EntityLiving) {
                        ((EntityLiving)target).spawnExplosionParticle();
                    }
                    worldObj.playSoundAtEntity((Entity)target, "game.player.hurt.fall.big", 1.0f, ((itemRand.nextFloat() - itemRand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    ItemTFScepterLifeDrain.animateTargetShatter(worldObj, target);
                    if (!worldObj.isRemote) {
                        target.setDead();
                        target.onDeath(DamageSource.causeIndirectMagicDamage((Entity)player, (Entity)player));
                    }
                    player.stopUsingItem();
                } else if (!worldObj.isRemote) {
                    target.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)player, (Entity)player), 3.0f);
                    if (this.getMaxHealth(target) <= this.getMaxHealth((EntityLivingBase)player)) {
                        target.motionX = 0.0;
                        target.motionY = 0.2;
                        target.motionZ = 0.0;
                    }
                    target.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 20, 2));
                    if (count % 10 == 0) {
                        player.heal(1.0f);
                        player.getFoodStats().addStats(1, 0.1f);
                    }
                }
            } else {
                this.makeRedMagicTrail(worldObj, player.posX, player.posY + (double)player.getEyeHeight(), player.posZ, target.posX, target.posY + (double)target.getEyeHeight(), target.posZ);
                worldObj.playSoundAtEntity((Entity)player, "fire.ignite", 1.0f, (worldObj.rand.nextFloat() - worldObj.rand.nextFloat()) * 0.2f + 1.0f);
                if (!worldObj.isRemote) {
                    target.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)player, (Entity)player), 1.0f);
                    if (this.getMaxHealth(target) <= this.getMaxHealth((EntityLivingBase)player)) {
                        target.motionX = 0.0;
                        target.motionY = 0.2;
                        target.motionZ = 0.0;
                    }
                    target.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 20, 2));
                }
            }
            if (!worldObj.isRemote) {
                stack.damageItem(1, (EntityLivingBase)player);
            }
        }
    }

    private float getMaxHealth(EntityLivingBase target) {
        return (float)target.getEntityAttribute(SharedMonsterAttributes.maxHealth).getBaseValue();
    }

    protected void makeRedMagicTrail(World worldObj, double srcX, double srcY, double srcZ, double destX, double destY, double destZ) {
        int particles = 32;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            float f = 1.0f;
            float f1 = 0.5f;
            float f2 = 0.5f;
            double tx = srcX + (destX - srcX) * trailFactor + worldObj.rand.nextGaussian() * 0.005;
            double ty = srcY + (destY - srcY) * trailFactor + worldObj.rand.nextGaussian() * 0.005;
            double tz = srcZ + (destZ - srcZ) * trailFactor + worldObj.rand.nextGaussian() * 0.005;
            worldObj.spawnParticle("mobSpell", tx, ty, tz, (double)f, (double)f1, (double)f2);
        }
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    @Override
    public EnumRarity getRarity(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.addInformation(par1ItemStack, par2EntityPlayer, par3List, par4);
        par3List.add(par1ItemStack.getMaxDamage() - par1ItemStack.getItemDamage() + " charges left");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

