/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import twilightforest.block.TFBlocks;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFOreMeter
extends ItemTF {
    protected ItemTFOreMeter() {
        this.setCreativeTab(TFItems.creativeTab);
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World world, EntityPlayer player) {
        int useX = MathHelper.floor_double((double)player.posX);
        int useZ = MathHelper.floor_double((double)player.posZ);
        if (!world.isRemote) {
            this.countOreInArea(player, world, useX, useZ, 3);
        }
        return super.onItemRightClick(par1ItemStack, world, player);
    }

    private void countOreInChunk(EntityPlayer player, World world, int useX, int useZ) {
        int chunkX = useX >> 4;
        int chunkZ = useZ >> 4;
        int countStone = this.countBlockInChunk(world, Blocks.stone, chunkX, chunkZ);
        int countDirt = this.countBlockInChunk(world, Blocks.dirt, chunkX, chunkZ);
        int countGravel = this.countBlockInChunk(world, Blocks.gravel, chunkX, chunkZ);
        int countCoal = this.countBlockInChunk(world, Blocks.coal_ore, chunkX, chunkZ);
        int countIron = this.countBlockInChunk(world, Blocks.iron_ore, chunkX, chunkZ);
        int countGold = this.countBlockInChunk(world, Blocks.gold_ore, chunkX, chunkZ);
        int countDiamond = this.countBlockInChunk(world, Blocks.diamond_ore, chunkX, chunkZ);
        int countLapis = this.countBlockInChunk(world, Blocks.lapis_ore, chunkX, chunkZ);
        int countRedstone = this.countBlockInChunk(world, Blocks.redstone_ore, chunkX, chunkZ);
        int countRoots = this.countBlockInChunk(world, TFBlocks.root, 0, chunkX, chunkZ);
        int countOreRoots = this.countBlockInChunk(world, TFBlocks.root, 1, chunkX, chunkZ);
        int total = countStone + countDirt + countGravel + countCoal + countIron + countGold + countDiamond + countLapis + countRedstone + countRoots + countOreRoots;
    }

    private void countOreInArea(EntityPlayer player, World world, int useX, int useZ, int radius) {
        int chunkX = useX >> 4;
        int chunkZ = useZ >> 4;
        int countStone = 0;
        int countDirt = 0;
        int countGravel = 0;
        int countCoal = 0;
        int countIron = 0;
        int countGold = 0;
        int countDiamond = 0;
        int countLapis = 0;
        int countRedstone = 0;
        int countExposedDiamond = 0;
        int countRoots = 0;
        int countOreRoots = 0;
        int total = 0;
        for (int cx = chunkX - radius; cx <= chunkX + radius; ++cx) {
            for (int cz = chunkZ - radius; cz <= chunkZ + radius; ++cz) {
                countStone += this.countBlockInChunk(world, Blocks.stone, cx, cz);
                countDirt += this.countBlockInChunk(world, Blocks.dirt, cx, cz);
                countGravel += this.countBlockInChunk(world, Blocks.gravel, cx, cz);
                countCoal += this.countBlockInChunk(world, Blocks.coal_ore, cx, cz);
                countIron += this.countBlockInChunk(world, Blocks.iron_ore, cx, cz);
                countGold += this.countBlockInChunk(world, Blocks.gold_ore, cx, cz);
                countDiamond += this.countBlockInChunk(world, Blocks.diamond_ore, cx, cz);
                countLapis += this.countBlockInChunk(world, Blocks.lapis_ore, cx, cz);
                countRedstone += this.countBlockInChunk(world, Blocks.redstone_ore, cx, cz);
                countExposedDiamond += this.countExposedBlockInChunk(world, Blocks.diamond_ore, cx, cz);
                countRoots += this.countBlockInChunk(world, TFBlocks.root, 0, cx, cz);
                countOreRoots += this.countBlockInChunk(world, TFBlocks.root, 1, cx, cz);
            }
        }
        total = countStone + countDirt + countGravel + countCoal + countIron + countGold + countDiamond + countLapis + countRedstone + countRoots + countOreRoots;
    }

    public float percent(int count, int total) {
        return (float)count / (float)total * 100.0f;
    }

    public int countBlockInChunk(World world, Block stone, int cx, int cz) {
        Chunk chunk = world.getChunkFromChunkCoords(cx, cz);
        int count = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    if (chunk.getBlock(x, y, z) != stone) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public int countBlockInChunk(World world, Block blockID, int meta, int cx, int cz) {
        Chunk chunk = world.getChunkFromChunkCoords(cx, cz);
        int count = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    if (chunk.getBlock(x, y, z) != blockID || chunk.getBlockMetadata(x, y, z) != meta) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private int countExposedBlockInChunk(World world, Block blockID, int cx, int cz) {
        int count = 0;
        for (int x = cx << 4; x < (cx << 4) + 16; ++x) {
            for (int z = cz << 4; z < (cz << 4) + 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    if (world.getBlock(x, y, z) != blockID || !world.isAirBlock(x + 1, y, z) && !world.isAirBlock(x - 1, y, z) && !world.isAirBlock(x, y + 1, z) && !world.isAirBlock(x, y - 1, z) && !world.isAirBlock(x, y + 1, z) && !world.isAirBlock(x, y - 1, z)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.addInformation(par1ItemStack, par2EntityPlayer, par3List, par4);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

