/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.block.TFBlocks;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFLampOfCinders
extends ItemTF {
    private static final int FIRING_TIME = 12;

    public ItemTFLampOfCinders() {
        this.setCreativeTab(TFItems.creativeTab);
        this.maxStackSize = 1;
        this.setMaxDamage(1024);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World world, EntityPlayer player) {
        if (par1ItemStack.getItemDamage() < this.getMaxDamage()) {
            player.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        } else {
            player.stopUsingItem();
        }
        return par1ItemStack;
    }

    public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (this.burnBlock(player, world, x, y, z)) {
            world.playSoundAtEntity((Entity)player, this.getSound(), 0.5f, 1.5f);
            for (int i = 0; i < 10; ++i) {
                float dx = (float)x + 0.5f + (itemRand.nextFloat() - itemRand.nextFloat()) * 0.75f;
                float dy = (float)y + 0.5f + (itemRand.nextFloat() - itemRand.nextFloat()) * 0.75f;
                float dz = (float)z + 0.5f + (itemRand.nextFloat() - itemRand.nextFloat()) * 0.75f;
                world.spawnParticle("smoke", (double)dx, (double)dy, (double)dz, 0.0, 0.0, 0.0);
                world.spawnParticle("flame", (double)dx, (double)dy, (double)dz, 0.0, 0.0, 0.0);
            }
            return true;
        }
        return false;
    }

    private boolean burnBlock(EntityPlayer player, World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (block == TFBlocks.thorns) {
            world.setBlock(x, y, z, TFBlocks.burntThorns, world.getBlockMetadata(x, y, z) & 0xC, 2);
            return true;
        }
        return false;
    }

    public void onPlayerStoppedUsing(ItemStack par1ItemStack, World world, EntityPlayer player, int useRemaining) {
        int useTime = this.getMaxItemUseDuration(par1ItemStack) - useRemaining;
        if (useTime > 12 && par1ItemStack.getItemDamage() + 1 < this.getMaxDamage()) {
            this.doBurnEffect(world, player);
            player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressTroll);
        }
    }

    private void doBurnEffect(World world, EntityPlayer player) {
        int px = MathHelper.floor_double((double)player.lastTickPosX);
        int py = MathHelper.floor_double((double)(player.lastTickPosY + (double)player.getEyeHeight()));
        int pz = MathHelper.floor_double((double)player.lastTickPosZ);
        int range = 4;
        if (!world.isRemote) {
            world.playSoundAtEntity((Entity)player, this.getSound(), 1.5f, 0.8f);
            for (int dx = -range; dx <= range; ++dx) {
                for (int dy = -range; dy <= range; ++dy) {
                    for (int dz = -range; dz <= range; ++dz) {
                        this.burnBlock(player, world, px + dx, py + dy, pz + dz);
                    }
                }
            }
        }
        for (int i = 0; i < 6; ++i) {
            int rx = px + itemRand.nextInt(range) - itemRand.nextInt(range);
            int ry = py + itemRand.nextInt(2);
            int rz = pz + itemRand.nextInt(range) - itemRand.nextInt(range);
            world.playAuxSFXAtEntity(player, 2004, rx, ry, rz, 0);
        }
    }

    public String getSound() {
        return "mob.ghast.fireball";
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }
}

