/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import twilightforest.item.TFItems;

public class ItemTFFieryPick
extends ItemPickaxe {
    protected ItemTFFieryPick(Item.ToolMaterial toolMaterial) {
        super(toolMaterial);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public boolean onBlockDestroyed(ItemStack itemStack, World world, Block blockID, int x, int y, int z, EntityLivingBase par7EntityLiving) {
        if (super.onBlockDestroyed(itemStack, world, blockID, x, y, z, par7EntityLiving) && this.func_150897_b(blockID)) {
            if (world.isRemote) {
                int meta = world.getBlockMetadata(x, y, z);
                ArrayList items = blockID.getDrops(world, x, y, z, meta, 0);
                for (ItemStack input : items) {
                    ItemStack result = FurnaceRecipes.smelting().getSmeltingResult(input);
                    if (result == null) continue;
                    for (int var1 = 0; var1 < 5; ++var1) {
                        double rx = itemRand.nextGaussian() * 0.02;
                        double ry = itemRand.nextGaussian() * 0.02;
                        double rz = itemRand.nextGaussian() * 0.02;
                        double magnitude = 20.0;
                        world.spawnParticle("flame", (double)x + 0.5 + rx * magnitude, (double)y + 0.5 + ry * magnitude, (double)z + 0.5 + rz * magnitude, -rx, -ry, -rz);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean hitEntity(ItemStack par1ItemStack, EntityLivingBase target, EntityLivingBase par3EntityLiving) {
        boolean result = super.hitEntity(par1ItemStack, target, par3EntityLiving);
        if (result && !target.isImmuneToFire()) {
            if (target.worldObj.isRemote) {
                for (int var1 = 0; var1 < 20; ++var1) {
                    double var2 = itemRand.nextGaussian() * 0.02;
                    double var4 = itemRand.nextGaussian() * 0.02;
                    double var6 = itemRand.nextGaussian() * 0.02;
                    double var8 = 10.0;
                    target.worldObj.spawnParticle("flame", target.posX + (double)(itemRand.nextFloat() * target.width * 2.0f) - (double)target.width - var2 * var8, target.posY + (double)(itemRand.nextFloat() * target.height) - var4 * var8, target.posZ + (double)(itemRand.nextFloat() * target.width * 2.0f) - (double)target.width - var6 * var8, var2, var4, var6);
                }
            } else {
                target.setFire(15);
            }
        }
        return result;
    }

    public EnumRarity getRarity(ItemStack itemStack) {
        return EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack par1ItemStack, EntityPlayer player, List par3List, boolean par4) {
        super.addInformation(par1ItemStack, player, par3List, par4);
        par3List.add(StatCollector.translateToLocal((String)(this.getUnlocalizedName() + ".tooltip")));
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.getItem() == TFItems.fieryIngot ? true : super.getIsRepairable(par1ItemStack, par2ItemStack);
    }

    public boolean func_150897_b(Block block) {
        return block == Blocks.obsidian ? true : super.func_150897_b(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

