/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFCubeOfAnnihilation;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFCubeOfAnnihilation
extends ItemTF {
    private IIcon annihilateIcon;
    private HashMap<ItemStack, Entity> launchedCubesMap = new HashMap();

    protected ItemTFCubeOfAnnihilation() {
        this.maxStackSize = 1;
        this.setCreativeTab(TFItems.creativeTab);
    }

    public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public ItemStack onItemRightClick(ItemStack stack, World worldObj, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        if (!worldObj.isRemote && !this.hasLaunchedCube(stack)) {
            EntityTFCubeOfAnnihilation launchedCube = new EntityTFCubeOfAnnihilation(worldObj, (EntityLivingBase)player);
            worldObj.spawnEntityInWorld((Entity)launchedCube);
            this.setLaunchedCube(stack, launchedCube);
            ItemTFCubeOfAnnihilation.setCubeAsThrown(stack);
        }
        return stack;
    }

    public static void setCubeAsThrown(ItemStack stack) {
        if (stack.getTagCompound() == null) {
            stack.setTagCompound(new NBTTagCompound());
        }
        stack.getTagCompound().setBoolean("thrown", true);
    }

    public static void setCubeAsReturned(ItemStack stack) {
        if (stack.getTagCompound() == null) {
            stack.setTagCompound(new NBTTagCompound());
        }
        stack.getTagCompound().setBoolean("thrown", false);
    }

    public static boolean doesTalismanHaveCube(ItemStack stack) {
        if (stack.getTagCompound() == null) {
            return true;
        }
        return !stack.getTagCompound().getBoolean("thrown");
    }

    public static void setCubeAsReturned(EntityPlayer player) {
        if (player != null && player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() == TFItems.cubeOfAnnihilation) {
            ItemTFCubeOfAnnihilation.setCubeAsReturned(player.getCurrentEquippedItem());
        }
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (ItemTFCubeOfAnnihilation.doesTalismanHaveCube(stack)) {
            return this.itemIcon;
        }
        return TFItems.cubeTalisman.getIconIndex(stack);
    }

    public boolean hasLaunchedCube(ItemStack stack) {
        Entity cube = this.launchedCubesMap.get(stack);
        return cube != null && !cube.isDead;
    }

    public void setLaunchedCube(ItemStack stack, EntityTFCubeOfAnnihilation launchedCube) {
        this.launchedCubesMap.put(stack, (Entity)launchedCube);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.block;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
        this.annihilateIcon = par1IconRegister.registerIcon("TwilightForest:annihilate_particle");
    }

    public IIcon getAnnihilateIcon() {
        return this.annihilateIcon;
    }
}

