/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import twilightforest.TwilightForestMod;
import twilightforest.inventory.InventoryTFGoblinUncrafting;

public class SlotTFGoblinUncrafting
extends Slot {
    protected EntityPlayer thePlayer;
    protected IInventory inputSlot;
    protected InventoryTFGoblinUncrafting uncraftingMatrix;
    protected IInventory assemblyMatrix;

    public SlotTFGoblinUncrafting(EntityPlayer par1EntityPlayer, IInventory inputSlot, InventoryTFGoblinUncrafting uncraftingMatrix, IInventory assemblyMatrix, int slotNum, int x, int y) {
        super((IInventory)uncraftingMatrix, slotNum, x, y);
        this.thePlayer = par1EntityPlayer;
        this.inputSlot = inputSlot;
        this.uncraftingMatrix = uncraftingMatrix;
        this.assemblyMatrix = assemblyMatrix;
    }

    public boolean isItemValid(ItemStack par1ItemStack) {
        return false;
    }

    public boolean canTakeStack(EntityPlayer par1EntityPlayer) {
        for (int i = 0; i < this.assemblyMatrix.getSizeInventory(); ++i) {
            if (this.assemblyMatrix.getStackInSlot(i) == null) continue;
            return false;
        }
        if (TwilightForestMod.disableUncrafting) {
            return false;
        }
        return this.uncraftingMatrix.uncraftingCost <= par1EntityPlayer.experienceLevel || par1EntityPlayer.capabilities.isCreativeMode;
    }

    public void onPickupFromSlot(EntityPlayer par1EntityPlayer, ItemStack par1ItemStack) {
        super.onPickupFromSlot(par1EntityPlayer, par1ItemStack);
        if (this.uncraftingMatrix.uncraftingCost > 0) {
            this.thePlayer.addExperienceLevel(-this.uncraftingMatrix.uncraftingCost);
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack transferStack = this.uncraftingMatrix.getStackInSlot(i);
            if (transferStack == null || transferStack.stackSize <= 0) continue;
            this.assemblyMatrix.setInventorySlotContents(i, transferStack.copy());
        }
        ItemStack inputStack = this.inputSlot.getStackInSlot(0);
        if (inputStack != null) {
            this.inputSlot.decrStackSize(0, this.uncraftingMatrix.numberOfInputItems);
        }
    }
}

