/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.inventory;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import twilightforest.TwilightForestMod;
import twilightforest.inventory.InventoryTFGoblinInput;
import twilightforest.inventory.InventoryTFGoblinUncrafting;
import twilightforest.inventory.SlotTFGoblinAssembly;
import twilightforest.inventory.SlotTFGoblinCraftResult;
import twilightforest.inventory.SlotTFGoblinUncrafting;

public class ContainerTFUncrafting
extends Container {
    public InventoryTFGoblinUncrafting uncraftingMatrix = new InventoryTFGoblinUncrafting(this);
    public InventoryCrafting assemblyMatrix = new InventoryCrafting((Container)this, 3, 3);
    public InventoryCrafting combineMatrix = new InventoryCrafting((Container)this, 3, 3);
    public IInventory tinkerInput = new InventoryTFGoblinInput(this);
    public IInventory tinkerResult = new InventoryCraftResult();
    private World worldObj;

    public ContainerTFUncrafting(InventoryPlayer inventory, World world, int x, int y, int z) {
        int invY;
        int invX;
        this.worldObj = world;
        this.addSlotToContainer(new Slot(this.tinkerInput, 0, 13, 35));
        this.addSlotToContainer((Slot)new SlotTFGoblinCraftResult(inventory.player, this.tinkerInput, this.uncraftingMatrix, (IInventory)this.assemblyMatrix, this.tinkerResult, 0, 147, 35));
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.addSlotToContainer(new SlotTFGoblinUncrafting(inventory.player, this.tinkerInput, this.uncraftingMatrix, (IInventory)this.assemblyMatrix, invY + invX * 3, 300000 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.addSlotToContainer(new SlotTFGoblinAssembly(inventory.player, this.tinkerInput, (IInventory)this.assemblyMatrix, this.uncraftingMatrix, invY + invX * 3, 62 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 9; ++invY) {
                this.addSlotToContainer(new Slot((IInventory)inventory, invY + invX * 9 + 9, 8 + invY * 18, 84 + invX * 18));
            }
        }
        for (invX = 0; invX < 9; ++invX) {
            this.addSlotToContainer(new Slot((IInventory)inventory, invX, 8 + invX * 18, 142));
        }
        this.onCraftMatrixChanged((IInventory)this.assemblyMatrix);
    }

    public void onCraftMatrixChanged(IInventory par1IInventory) {
        if (par1IInventory == this.tinkerInput) {
            ItemStack inputStack = this.tinkerInput.getStackInSlot(0);
            IRecipe recipe = this.getRecipeFor(inputStack);
            if (recipe != null) {
                int i;
                int recipeWidth = this.getRecipeWidth(recipe);
                int recipeHeight = this.getRecipeHeight(recipe);
                ItemStack[] recipeItems = this.getRecipeItems(recipe);
                for (i = 0; i < this.uncraftingMatrix.getSizeInventory(); ++i) {
                    this.uncraftingMatrix.setInventorySlotContents(i, null);
                }
                for (int invY = 0; invY < recipeHeight; ++invY) {
                    for (int invX = 0; invX < recipeWidth; ++invX) {
                        ItemStack ingredient = ItemStack.copyItemStack((ItemStack)recipeItems[invX + invY * recipeWidth]);
                        if (ingredient != null && ingredient.stackSize > 1) {
                            ingredient.stackSize = 1;
                        }
                        if (ingredient != null && (ingredient.getItemDamageForDisplay() == -1 || ingredient.getItemDamageForDisplay() == Short.MAX_VALUE)) {
                            ingredient.setItemDamage(0);
                        }
                        this.uncraftingMatrix.setInventorySlotContents(invX + invY * 3, ingredient);
                    }
                }
                if (inputStack.isItemDamaged()) {
                    int damagedParts = this.countDamagedParts(inputStack);
                    for (int i2 = 0; i2 < 9 && damagedParts > 0; ++i2) {
                        if (!this.isDamageableComponent(this.uncraftingMatrix.getStackInSlot(i2))) continue;
                        this.uncraftingMatrix.getStackInSlot((int)i2).stackSize = 0;
                        --damagedParts;
                    }
                }
                for (i = 0; i < 9; ++i) {
                    ItemStack ingredient = this.uncraftingMatrix.getStackInSlot(i);
                    if (!this.isIngredientProblematic(ingredient)) continue;
                    ingredient.stackSize = 0;
                }
                this.uncraftingMatrix.numberOfInputItems = recipe.getRecipeOutput().stackSize;
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
                this.uncraftingMatrix.recraftingCost = 0;
            } else {
                for (int i = 0; i < 9; ++i) {
                    this.uncraftingMatrix.setInventorySlotContents(i, null);
                }
                this.uncraftingMatrix.numberOfInputItems = 0;
                this.uncraftingMatrix.uncraftingCost = 0;
            }
        }
        if (par1IInventory == this.assemblyMatrix || par1IInventory == this.tinkerInput) {
            if (this.isMatrixEmpty(this.tinkerInput)) {
                this.tinkerResult.setInventorySlotContents(0, CraftingManager.getInstance().findMatchingRecipe(this.assemblyMatrix, this.worldObj));
                this.uncraftingMatrix.recraftingCost = 0;
            } else {
                this.tinkerResult.setInventorySlotContents(0, null);
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
                this.uncraftingMatrix.recraftingCost = 0;
            }
        }
        if (par1IInventory != this.combineMatrix && !this.isMatrixEmpty(this.uncraftingMatrix) && !this.isMatrixEmpty((IInventory)this.assemblyMatrix)) {
            for (int i = 0; i < 9; ++i) {
                if (this.assemblyMatrix.getStackInSlot(i) != null) {
                    this.combineMatrix.setInventorySlotContents(i, this.assemblyMatrix.getStackInSlot(i));
                    continue;
                }
                if (this.uncraftingMatrix.getStackInSlot(i) != null && this.uncraftingMatrix.getStackInSlot((int)i).stackSize > 0) {
                    this.combineMatrix.setInventorySlotContents(i, this.uncraftingMatrix.getStackInSlot(i));
                    continue;
                }
                this.combineMatrix.setInventorySlotContents(i, null);
            }
            ItemStack result = CraftingManager.getInstance().findMatchingRecipe(this.combineMatrix, this.worldObj);
            ItemStack input = this.tinkerInput.getStackInSlot(0);
            if (result != null && this.isValidMatchForInput(input, result)) {
                NBTTagCompound inputTags = input.getTagCompound();
                if (inputTags != null) {
                    inputTags = (NBTTagCompound)inputTags.copy();
                }
                Map resultInnateEnchantments = null;
                if (result.isItemEnchanted()) {
                    resultInnateEnchantments = EnchantmentHelper.getEnchantments((ItemStack)result);
                }
                Map inputEnchantments = null;
                if (input.isItemEnchanted()) {
                    inputEnchantments = EnchantmentHelper.getEnchantments((ItemStack)input);
                    for (Object key : inputEnchantments.keySet()) {
                        int enchID = (Integer)key;
                        Enchantment ench = Enchantment.enchantmentsList[enchID];
                        if (ench.canApply(result)) continue;
                        inputEnchantments.remove(key);
                    }
                }
                if (inputTags != null) {
                    inputTags.removeTag("ench");
                    result.setTagCompound((NBTTagCompound)inputTags.copy());
                    if (inputEnchantments != null) {
                        EnchantmentHelper.setEnchantments((Map)inputEnchantments, (ItemStack)result);
                    }
                }
                this.tinkerResult.setInventorySlotContents(0, result);
                this.uncraftingMatrix.uncraftingCost = 0;
                this.uncraftingMatrix.recraftingCost = this.calculateRecraftingCost();
                if (this.uncraftingMatrix.recraftingCost > 0 && !result.hasDisplayName()) {
                    result.setRepairCost(input.getRepairCost() + 2);
                }
                if (resultInnateEnchantments != null && resultInnateEnchantments.size() > 0) {
                    for (Object key : resultInnateEnchantments.keySet()) {
                        int enchID = (Integer)key;
                        int level = (Integer)resultInnateEnchantments.get(key);
                        Enchantment ench = Enchantment.enchantmentsList[enchID];
                        if (EnchantmentHelper.getEnchantmentLevel((int)enchID, (ItemStack)result) > level) {
                            level = EnchantmentHelper.getEnchantmentLevel((int)enchID, (ItemStack)result);
                        }
                        if (EnchantmentHelper.getEnchantmentLevel((int)enchID, (ItemStack)result) >= level) continue;
                        result.addEnchantment(ench, level);
                    }
                }
            }
        }
    }

    protected boolean isIngredientProblematic(ItemStack ingredient) {
        return ingredient != null && (ingredient.getItem().hasContainerItem(ingredient) || ingredient.getUnlocalizedName().contains("itemMatter"));
    }

    public IRecipe getRecipeFor(ItemStack inputStack) {
        if (inputStack != null) {
            for (IRecipe recipe : CraftingManager.getInstance().getRecipeList()) {
                if (!(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe) || recipe.getRecipeOutput().getItem() != inputStack.getItem() || inputStack.stackSize < recipe.getRecipeOutput().stackSize || recipe.getRecipeOutput().getHasSubtypes() && recipe.getRecipeOutput().getItemDamage() != inputStack.getItemDamage()) continue;
                return recipe;
            }
        }
        return null;
    }

    public boolean isValidMatchForInput(ItemStack inputStack, ItemStack resultStack) {
        if (inputStack.getItem() instanceof ItemPickaxe && resultStack.getItem() instanceof ItemPickaxe) {
            return true;
        }
        if (inputStack.getItem() instanceof ItemAxe && resultStack.getItem() instanceof ItemAxe) {
            return true;
        }
        if (inputStack.getItem() instanceof ItemSpade && resultStack.getItem() instanceof ItemSpade) {
            return true;
        }
        if (inputStack.getItem() instanceof ItemHoe && resultStack.getItem() instanceof ItemHoe) {
            return true;
        }
        if (inputStack.getItem() instanceof ItemSword && resultStack.getItem() instanceof ItemSword) {
            return true;
        }
        if (inputStack.getItem() instanceof ItemBow && resultStack.getItem() instanceof ItemBow) {
            return true;
        }
        if (inputStack.getItem() instanceof ItemArmor && resultStack.getItem() instanceof ItemArmor) {
            ItemArmor inputArmor = (ItemArmor)inputStack.getItem();
            ItemArmor resultArmor = (ItemArmor)resultStack.getItem();
            return inputArmor.armorType == resultArmor.armorType;
        }
        return false;
    }

    public int getUncraftingCost() {
        return this.uncraftingMatrix.uncraftingCost;
    }

    public int getRecraftingCost() {
        return this.uncraftingMatrix.recraftingCost;
    }

    public int calculateUncraftingCost() {
        if (!this.isMatrixEmpty((IInventory)this.assemblyMatrix)) {
            return 0;
        }
        return this.countDamageableParts(this.uncraftingMatrix);
    }

    public int calculateRecraftingCost() {
        if (this.tinkerInput.getStackInSlot(0) == null || !this.tinkerInput.getStackInSlot(0).isItemEnchanted() || this.tinkerResult.getStackInSlot(0) == null) {
            return 0;
        }
        ItemStack input = this.tinkerInput.getStackInSlot(0);
        ItemStack output = this.tinkerResult.getStackInSlot(0);
        int cost = 0;
        cost += input.getRepairCost();
        int enchantCost = this.countTotalEnchantmentCost(input);
        cost += enchantCost;
        int damagedCost = (1 + this.countDamagedParts(input)) * EnchantmentHelper.getEnchantments((ItemStack)output).size();
        cost += damagedCost;
        int enchantabilityDifference = input.getItem().getItemEnchantability() - output.getItem().getItemEnchantability();
        cost += enchantabilityDifference;
        cost = Math.max(1, cost);
        return cost;
    }

    public int countHighestEnchantmentCost(ItemStack itemStack) {
        int count = 0;
        for (Enchantment ench : Enchantment.enchantmentsList) {
            int level;
            if (ench == null || (level = EnchantmentHelper.getEnchantmentLevel((int)ench.effectId, (ItemStack)itemStack)) <= count) continue;
            count += this.getWeightModifier(ench) * level;
        }
        return count;
    }

    public int countTotalEnchantmentCost(ItemStack itemStack) {
        int count = 0;
        for (Enchantment ench : Enchantment.enchantmentsList) {
            int level;
            if (ench == null || (level = EnchantmentHelper.getEnchantmentLevel((int)ench.effectId, (ItemStack)itemStack)) <= 0) continue;
            count += this.getWeightModifier(ench) * level;
            ++count;
        }
        return count;
    }

    public int getWeightModifier(Enchantment ench) {
        switch (ench.getWeight()) {
            case 1: {
                return 8;
            }
            case 2: {
                return 4;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
        }
        return 1;
    }

    public ItemStack slotClick(int slotNum, int mouseButton, int shiftHeld, EntityPlayer par4EntityPlayer) {
        if (slotNum > 0 && par4EntityPlayer.inventory.getItemStack() == null && ((Slot)this.inventorySlots.get((int)slotNum)).inventory == this.assemblyMatrix && !((Slot)this.inventorySlots.get(slotNum)).getHasStack() && this.isMatrixEmpty((IInventory)this.assemblyMatrix)) {
            slotNum -= 9;
        }
        if (slotNum > 0 && ((Slot)this.inventorySlots.get((int)slotNum)).inventory == this.tinkerResult && this.calculateRecraftingCost() > par4EntityPlayer.experienceLevel && !par4EntityPlayer.capabilities.isCreativeMode) {
            return null;
        }
        if (slotNum > 0 && ((Slot)this.inventorySlots.get((int)slotNum)).inventory == this.uncraftingMatrix && this.calculateUncraftingCost() > par4EntityPlayer.experienceLevel && !par4EntityPlayer.capabilities.isCreativeMode) {
            return null;
        }
        if (slotNum > 0 && ((Slot)this.inventorySlots.get((int)slotNum)).inventory == this.uncraftingMatrix && TwilightForestMod.disableUncrafting) {
            return null;
        }
        if (slotNum > 0 && ((Slot)this.inventorySlots.get((int)slotNum)).inventory == this.uncraftingMatrix && (((Slot)this.inventorySlots.get(slotNum)).getStack() == null || ((Slot)this.inventorySlots.get((int)slotNum)).getStack().stackSize == 0)) {
            return null;
        }
        ItemStack ret = super.slotClick(slotNum, mouseButton, shiftHeld, par4EntityPlayer);
        if (slotNum > 0 && ((Slot)this.inventorySlots.get((int)slotNum)).inventory instanceof InventoryTFGoblinInput) {
            this.onCraftMatrixChanged(this.tinkerInput);
        }
        return ret;
    }

    protected void retrySlotClick(int slotNum, int mouseButton, boolean par3, EntityPlayer par4EntityPlayer) {
        if (((Slot)this.inventorySlots.get((int)slotNum)).inventory == this.uncraftingMatrix) {
            slotNum += 9;
        }
        this.slotClick(slotNum, mouseButton, 1, par4EntityPlayer);
    }

    private boolean isMatrixEmpty(IInventory matrix) {
        boolean matrixEmpty = true;
        for (int i = 0; i < matrix.getSizeInventory(); ++i) {
            if (matrix.getStackInSlot(i) == null) continue;
            matrixEmpty = false;
        }
        return matrixEmpty;
    }

    public boolean isDamageableComponent(ItemStack itemStack) {
        return itemStack != null && itemStack.getItem() != Items.stick;
    }

    public int countDamageableParts(IInventory matrix) {
        int count = 0;
        for (int i = 0; i < matrix.getSizeInventory(); ++i) {
            if (!this.isDamageableComponent(matrix.getStackInSlot(i))) continue;
            ++count;
        }
        return count;
    }

    public int countDamagedParts(ItemStack input) {
        int totalMax4 = Math.max(4, this.countDamageableParts(this.uncraftingMatrix));
        float damage = (float)input.getItemDamage() / (float)input.getMaxDamage();
        int damagedParts = (int)Math.ceil((float)totalMax4 * damage);
        return damagedParts;
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotNum) {
        ItemStack copyItem = null;
        Slot transferSlot = (Slot)this.inventorySlots.get(slotNum);
        if (transferSlot != null && transferSlot.getHasStack()) {
            ItemStack transferStack = transferSlot.getStack();
            copyItem = transferStack.copy();
            if (slotNum == 0 || slotNum == 1) {
                if (!this.mergeItemStack(transferStack, 20, 56, true)) {
                    return null;
                }
                transferSlot.onSlotChange(transferStack, copyItem);
            } else if (slotNum >= 20 && slotNum < 47 ? !this.mergeItemStack(transferStack, 47, 56, false) : (slotNum >= 47 && slotNum < 56 ? !this.mergeItemStack(transferStack, 20, 47, false) : !this.mergeItemStack(transferStack, 20, 56, false))) {
                return null;
            }
            if (transferStack.stackSize == 0) {
                transferSlot.putStack((ItemStack)null);
            } else {
                transferSlot.onSlotChanged();
            }
            if (transferStack.stackSize == copyItem.stackSize) {
                return null;
            }
            transferSlot.onPickupFromSlot(player, transferStack);
        }
        return copyItem;
    }

    public void onContainerClosed(EntityPlayer par1EntityPlayer) {
        super.onContainerClosed(par1EntityPlayer);
        if (!this.worldObj.isRemote) {
            for (int i = 0; i < 9; ++i) {
                ItemStack assemblyStack = this.assemblyMatrix.getStackInSlotOnClosing(i);
                if (assemblyStack == null) continue;
                par1EntityPlayer.dropPlayerItemWithRandomChoice(assemblyStack, false);
            }
            ItemStack inputStack = this.tinkerInput.getStackInSlotOnClosing(0);
            if (inputStack != null) {
                par1EntityPlayer.dropPlayerItemWithRandomChoice(inputStack, false);
            }
        }
    }

    public ItemStack[] getRecipeItems(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return this.getRecipeItemsShaped((ShapedRecipes)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return this.getRecipeItemsOre((ShapedOreRecipe)recipe);
        }
        return null;
    }

    public ItemStack[] getRecipeItemsShaped(ShapedRecipes shaped) {
        return shaped.recipeItems;
    }

    public ItemStack[] getRecipeItemsOre(ShapedOreRecipe shaped) {
        try {
            Object[] objects = (Object[])ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)3);
            ItemStack[] items = new ItemStack[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] instanceof ItemStack) {
                    items[i] = (ItemStack)objects[i];
                }
                if (!(objects[i] instanceof ArrayList) || ((ArrayList)objects[i]).size() <= 0) continue;
                items[i] = (ItemStack)((ArrayList)objects[i]).get(0);
            }
            return items;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int getRecipeWidth(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return this.getRecipeWidthShaped((ShapedRecipes)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return this.getRecipeWidthOre((ShapedOreRecipe)recipe);
        }
        return -1;
    }

    public int getRecipeWidthShaped(ShapedRecipes shaped) {
        return shaped.recipeWidth;
    }

    public int getRecipeWidthOre(ShapedOreRecipe shaped) {
        try {
            return (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)4);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int getRecipeHeight(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return this.getRecipeHeightShaped((ShapedRecipes)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return this.getRecipeHeightOre((ShapedOreRecipe)recipe);
        }
        return -1;
    }

    public int getRecipeHeightShaped(ShapedRecipes shaped) {
        return shaped.recipeHeight;
    }

    public int getRecipeHeightOre(ShapedOreRecipe shaped) {
        try {
            return (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)5);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public boolean canInteractWith(EntityPlayer var1) {
        return true;
    }
}

