/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.EntityAITFHoverBeam;
import twilightforest.entity.ai.EntityAITFHoverSummon;
import twilightforest.entity.ai.EntityAITFHoverThenDrop;
import twilightforest.entity.boss.EntityTFIceCrystal;
import twilightforest.entity.boss.EntityTFSnowQueenIceShield;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class EntityTFSnowQueen
extends EntityMob
implements IBossDisplayData,
IEntityMultiPart,
IBreathAttacker {
    private static final int MAX_SUMMONS = 6;
    private static final int BEAM_FLAG = 21;
    private static final int PHASE_FLAG = 22;
    private static final int MAX_DAMAGE_WHILE_BEAMING = 25;
    private static final float BREATH_DAMAGE = 4.0f;
    public Entity[] iceArray;
    private int summonsRemaining = 0;
    private int successfulDrops;
    private int maxDrops;
    private int damageWhileBeaming;

    public EntityTFSnowQueen(World par1World) {
        super(par1World);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAITFHoverSummon(this, EntityPlayer.class, 1.0));
        this.tasks.addTask(2, (EntityAIBase)new EntityAITFHoverThenDrop(this, EntityPlayer.class, 80, 20));
        this.tasks.addTask(3, (EntityAIBase)new EntityAITFHoverBeam(this, EntityPlayer.class, 80, 100));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, true));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.setSize(0.7f, 2.2f);
        this.iceArray = new Entity[7];
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i] = new EntityTFSnowQueenIceShield(this);
        }
        this.setCurrentPhase(Phase.SUMMON);
        this.isImmuneToFire = true;
        this.experienceValue = 317;
    }

    public boolean canBePushed() {
        return false;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.23f);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(7.0);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(200.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(21, (Object)0);
        this.dataWatcher.addObject(22, (Object)0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.ice.noise";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.ice.hurt";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.ice.death";
    }

    protected Item getDropItem() {
        return Items.snowball;
    }

    protected void enchantEquipment() {
        super.enchantEquipment();
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        IEntityLivingData data = super.onSpawnWithEgg(par1EntityLivingData);
        return data;
    }

    public void onLivingUpdate() {
        float pz;
        float py;
        float px;
        int i;
        super.onLivingUpdate();
        for (i = 0; i < 3; ++i) {
            px = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.3f;
            py = this.getEyeHeight() + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.5f;
            pz = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.3f;
            TwilightForestMod.proxy.spawnParticle(this.worldObj, "snowguardian", this.lastTickPosX + (double)px, this.lastTickPosY + (double)py, this.lastTickPosZ + (double)pz, 0.0, 0.0, 0.0);
        }
        if (this.getCurrentPhase() == Phase.DROP) {
            for (i = 0; i < this.iceArray.length; ++i) {
                px = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.5f;
                py = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.5f;
                pz = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.5f;
                TwilightForestMod.proxy.spawnParticle(this.worldObj, "snowwarning", this.iceArray[i].lastTickPosX + (double)px, this.iceArray[i].lastTickPosY + (double)py, this.iceArray[i].lastTickPosZ + (double)pz, 0.0, 0.0, 0.0);
            }
        }
        if (this.isBreathing() && this.isEntityAlive()) {
            Vec3 look = this.getLookVec();
            double dist = 0.5;
            double px2 = this.posX + look.xCoord * dist;
            double py2 = this.posY + (double)1.7f + look.yCoord * dist;
            double pz2 = this.posZ + look.zCoord * dist;
            for (int i2 = 0; i2 < 10; ++i2) {
                double dx = look.xCoord;
                double dy = 0.0;
                double dz = look.zCoord;
                double spread = 2.0 + this.getRNG().nextDouble() * 2.5;
                double velocity = 2.0 + this.getRNG().nextDouble() * 0.15;
                dx += this.getRNG().nextGaussian() * 0.0075 * spread;
                dy += this.getRNG().nextGaussian() * 0.0075 * spread;
                dz += this.getRNG().nextGaussian() * 0.0075 * spread;
                TwilightForestMod.proxy.spawnParticle(this.worldObj, "icebeam", px2, py2, pz2, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
    }

    public void onUpdate() {
        super.onUpdate();
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i].onUpdate();
            if (i < this.iceArray.length - 1) {
                Vec3 blockPos = this.getIceShieldPosition(i);
                this.iceArray[i].setPosition(blockPos.xCoord, blockPos.yCoord, blockPos.zCoord);
                this.iceArray[i].rotationYaw = this.getIceShieldAngle(i);
            } else {
                this.iceArray[i].setPosition(this.posX, this.posY - 1.0, this.posZ);
                this.iceArray[i].rotationYaw = this.getIceShieldAngle(i);
            }
            if (this.worldObj.isRemote) continue;
            this.applyShieldCollisions(this.iceArray[i]);
        }
        if (this.deathTime > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                String explosionType = this.rand.nextBoolean() ? "hugeexplosion" : "explode";
                this.worldObj.spawnParticle(explosionType, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
            }
        }
    }

    protected void dropFewItems(boolean par1, int par2) {
        int i;
        this.dropBow();
        int totalDrops = this.rand.nextInt(4 + par2) + 1;
        for (i = 0; i < totalDrops; ++i) {
            this.dropItem(Item.getItemFromBlock((Block)Blocks.packed_ice), 7);
        }
        totalDrops = this.rand.nextInt(5 + par2) + 5;
        for (i = 0; i < totalDrops; ++i) {
            this.dropItem(Items.snowball, 16);
        }
        this.entityDropItem(new ItemStack(TFItems.trophy, 1, 4), 0.0f);
    }

    private void dropBow() {
        int bowType = this.rand.nextInt(2);
        if (bowType == 0) {
            this.entityDropItem(new ItemStack(TFItems.tripleBow), 0.0f);
        } else {
            this.entityDropItem(new ItemStack(TFItems.seekerBow), 0.0f);
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightProgressGlacier);
        }
        if (!this.worldObj.isRemote) {
            int dx = MathHelper.floor_double((double)this.posX);
            int dy = MathHelper.floor_double((double)this.posY);
            int dz = MathHelper.floor_double((double)this.posZ);
            if (this.worldObj.provider instanceof WorldProviderTwilightForest) {
                ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)this.worldObj.provider).getChunkProvider();
                TFFeature nearbyFeature = ((TFWorldChunkManager)this.worldObj.provider.worldChunkMgr).getFeatureAt(dx, dz, this.worldObj);
                if (nearbyFeature == TFFeature.lichTower) {
                    chunkProvider.setStructureConquered(dx, dy, dz, true);
                }
            }
        }
    }

    private void applyShieldCollisions(Entity collider) {
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(collider, collider.boundingBox.expand((double)-0.2f, (double)-0.2f, (double)-0.2f));
        for (Entity collided : list) {
            if (!collided.canBePushed()) continue;
            this.applyShieldCollision(collider, collided);
        }
    }

    protected void applyShieldCollision(Entity collider, Entity collided) {
        if (collided != this) {
            boolean attackSuccess;
            collided.applyEntityCollision(collider);
            if (collided instanceof EntityLivingBase && (attackSuccess = super.attackEntityAsMob(collided))) {
                collided.motionY += (double)0.4f;
                this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
            }
        }
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (this.getCurrentPhase() == Phase.SUMMON && this.getSummonsRemaining() == 0 && this.countMyMinions() <= 0) {
            this.setCurrentPhase(Phase.DROP);
        }
        if (this.getCurrentPhase() == Phase.DROP && this.successfulDrops >= this.maxDrops) {
            this.setCurrentPhase(Phase.BEAM);
        }
        if (this.getCurrentPhase() == Phase.BEAM && this.damageWhileBeaming >= 25) {
            this.setCurrentPhase(Phase.SUMMON);
        }
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float damage) {
        boolean result = super.attackEntityFrom(par1DamageSource, damage);
        if (result && this.getCurrentPhase() == Phase.BEAM) {
            this.damageWhileBeaming = (int)((float)this.damageWhileBeaming + damage);
        }
        return result;
    }

    private Vec3 getIceShieldPosition(int i) {
        return this.getIceShieldPosition(this.getIceShieldAngle(i), 1.0f);
    }

    private float getIceShieldAngle(int i) {
        return 60.0f * (float)i + (float)this.ticksExisted * 5.0f;
    }

    public Vec3 getIceShieldPosition(float angle, float distance) {
        double var1 = Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double var3 = Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return Vec3.createVectorHelper((double)(this.posX + var1), (double)(this.posY + this.getShieldYOffset()), (double)(this.posZ + var3));
    }

    public double getShieldYOffset() {
        return 0.1f;
    }

    protected void fall(float par1) {
    }

    public World func_82194_d() {
        return this.worldObj;
    }

    public boolean attackEntityFromPart(EntityDragonPart entitydragonpart, DamageSource damagesource, float i) {
        return false;
    }

    public Entity[] getParts() {
        return this.iceArray;
    }

    public boolean destroyBlocksInAABB(AxisAlignedBB par1AxisAlignedBB) {
        int minX = MathHelper.floor_double((double)par1AxisAlignedBB.minX);
        int minY = MathHelper.floor_double((double)par1AxisAlignedBB.minY);
        int minZ = MathHelper.floor_double((double)par1AxisAlignedBB.minZ);
        int maxX = MathHelper.floor_double((double)par1AxisAlignedBB.maxX);
        int maxY = MathHelper.floor_double((double)par1AxisAlignedBB.maxY);
        int maxZ = MathHelper.floor_double((double)par1AxisAlignedBB.maxZ);
        boolean wasBlocked = false;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dy = minY; dy <= maxY; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    Block block = this.worldObj.getBlock(dx, dy, dz);
                    if (block == Blocks.air) continue;
                    int currentMeta = this.worldObj.getBlockMetadata(dx, dy, dz);
                    if (block == Blocks.ice || block == Blocks.packed_ice) {
                        this.worldObj.setBlock(dx, dy, dz, Blocks.air, 0, 2);
                        this.worldObj.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)block) + (currentMeta << 12));
                        continue;
                    }
                    wasBlocked = true;
                }
            }
        }
        return wasBlocked;
    }

    @Override
    public boolean isBreathing() {
        return this.getDataWatcher().getWatchableObjectByte(21) == 1;
    }

    @Override
    public void setBreathing(boolean flag) {
        this.getDataWatcher().updateObject(21, (Object)((byte)(flag ? 1 : 0)));
    }

    public Phase getCurrentPhase() {
        return Phase.values()[this.getDataWatcher().getWatchableObjectByte(22)];
    }

    public void setCurrentPhase(Phase currentPhase) {
        this.getDataWatcher().updateObject(22, (Object)((byte)currentPhase.ordinal()));
        if (currentPhase == Phase.SUMMON) {
            this.setSummonsRemaining(6);
        }
        if (currentPhase == Phase.DROP) {
            this.successfulDrops = 0;
            this.maxDrops = 2 + this.rand.nextInt(3);
        }
        if (currentPhase == Phase.BEAM) {
            this.damageWhileBeaming = 0;
        }
    }

    public int getSummonsRemaining() {
        return this.summonsRemaining;
    }

    public void setSummonsRemaining(int summonsRemaining) {
        this.summonsRemaining = summonsRemaining;
    }

    public void summonMinionAt(EntityLivingBase targetedEntity) {
        Vec3 minionSpot = this.findVecInLOSOf((Entity)targetedEntity);
        EntityTFIceCrystal minion = new EntityTFIceCrystal(this.worldObj);
        minion.setPosition(minionSpot.xCoord, minionSpot.yCoord, minionSpot.zCoord);
        this.worldObj.spawnEntityInWorld((Entity)minion);
        minion.setAttackTarget(targetedEntity);
        minion.setToDieIn30Seconds();
        --this.summonsRemaining;
    }

    protected Vec3 findVecInLOSOf(Entity targetEntity) {
        if (targetEntity == null) {
            return null;
        }
        double tx = 0.0;
        double ty = 0.0;
        double tz = 0.0;
        int tries = 100;
        for (int i = 0; i < tries; ++i) {
            float halfWidth;
            AxisAlignedBB destBox;
            tx = targetEntity.posX + this.rand.nextGaussian() * 16.0;
            ty = targetEntity.posY + this.rand.nextGaussian() * 8.0;
            tz = targetEntity.posZ + this.rand.nextGaussian() * 16.0;
            boolean groundFlag = false;
            int bx = MathHelper.floor_double((double)tx);
            int by = MathHelper.floor_double((double)ty);
            int bz = MathHelper.floor_double((double)tz);
            while (!groundFlag && ty > 0.0) {
                Block whatsThere = this.worldObj.getBlock(bx, by - 1, bz);
                if (whatsThere == Blocks.air || !whatsThere.getMaterial().isSolid()) {
                    ty -= 1.0;
                    --by;
                    continue;
                }
                groundFlag = true;
            }
            if (by != 0 && this.canEntitySee(targetEntity, tx, ty, tz) && this.worldObj.getCollidingBoundingBoxes((Entity)this, destBox = AxisAlignedBB.getBoundingBox((double)(tx - (double)(halfWidth = this.width / 2.0f)), (double)(ty - (double)this.yOffset + (double)this.ySize), (double)(tz - (double)halfWidth), (double)(tx + (double)halfWidth), (double)(ty - (double)this.yOffset + (double)this.ySize + (double)this.height), (double)(tz + (double)halfWidth))).size() <= 0 && !this.worldObj.isAnyLiquid(destBox)) break;
        }
        if (tries == 99) {
            return null;
        }
        return Vec3.createVectorHelper((double)tx, (double)ty, (double)tz);
    }

    protected boolean canEntitySee(Entity entity, double dx, double dy, double dz) {
        return this.worldObj.rayTraceBlocks(Vec3.createVectorHelper((double)entity.posX, (double)(entity.posY + (double)entity.getEyeHeight()), (double)entity.posZ), Vec3.createVectorHelper((double)dx, (double)dy, (double)dz)) == null;
    }

    public int countMyMinions() {
        List nearbyMinons = this.worldObj.getEntitiesWithinAABB(EntityTFIceCrystal.class, AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(32.0, 16.0, 32.0));
        return nearbyMinons.size();
    }

    public void incrementSuccessfulDrops() {
        ++this.successfulDrops;
    }

    @Override
    public void doBreathAttack(Entity target) {
    }

    public static enum Phase {
        SUMMON,
        DROP,
        BEAM;

    }
}

