/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.entity.boss.EntityTFLich;

public class EntityTFLichMinion
extends EntityZombie {
    EntityTFLich master;

    public EntityTFLichMinion(World par1World) {
        super(par1World);
        this.master = null;
    }

    public EntityTFLichMinion(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y, z);
    }

    public EntityTFLichMinion(World par1World, EntityTFLich entityTFLich) {
        super(par1World);
        this.master = entityTFLich;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        EntityLivingBase prevTarget = this.getAttackTarget();
        if (super.attackEntityFrom(par1DamageSource, par2)) {
            if (par1DamageSource.getEntity() instanceof EntityTFLich) {
                this.setAttackTarget(prevTarget);
                this.setRevengeTarget(prevTarget);
                this.addPotionEffect(new PotionEffect(Potion.moveSpeed.id, 200, 4));
                this.addPotionEffect(new PotionEffect(Potion.damageBoost.id, 200, 1));
            }
            return true;
        }
        return false;
    }

    public void onLivingUpdate() {
        if (this.master == null) {
            this.findNewMaster();
        }
        if (this.master == null || this.master.isDead) {
            this.setHealth(0.0f);
        }
        super.onLivingUpdate();
    }

    private void findNewMaster() {
        List nearbyLiches = this.worldObj.getEntitiesWithinAABB(EntityTFLich.class, AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(32.0, 16.0, 32.0));
        for (EntityTFLich nearbyLich : nearbyLiches) {
            if (nearbyLich.isShadowClone() || !nearbyLich.wantsNewMinion(this)) continue;
            this.master = nearbyLich;
            this.master.makeBlackMagicTrail(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ, this.master.posX, this.master.posY + (double)this.master.getEyeHeight(), this.master.posZ);
            this.setAttackTarget(this.master.getAttackTarget());
            break;
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    protected void addRandomArmor() {
        float[] equipChances = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
        if (this.rand.nextFloat() < equipChances[2]) {
            float var2;
            int var1 = this.rand.nextInt(2);
            float f = var2 = this.worldObj.difficultySetting == EnumDifficulty.HARD ? 0.1f : 0.25f;
            if (this.rand.nextFloat() < 0.07f) {
                ++var1;
            }
            if (this.rand.nextFloat() < 0.07f) {
                ++var1;
            }
            if (this.rand.nextFloat() < 0.07f) {
                ++var1;
            }
            for (int var3 = 3; var3 >= 0; --var3) {
                Item var5;
                ItemStack var4 = this.func_130225_q(var3);
                if (var3 < 3 && this.rand.nextFloat() < var2) break;
                if (var4 != null || (var5 = EntityTFLichMinion.getArmorItemForSlot((int)(var3 + 1), (int)var1)) == null) continue;
                this.setCurrentItemOrArmor(var3 + 1, new ItemStack(var5));
            }
        }
    }
}

