/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.entity.EntityTFSwarmSpider;
import twilightforest.entity.boss.EntityTFLichBolt;
import twilightforest.entity.boss.EntityTFLichBomb;
import twilightforest.entity.boss.EntityTFLichMinion;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class EntityTFLich
extends EntityMob
implements IBossDisplayData {
    private static final int DATA_ISCLONE = 21;
    private static final int DATA_SHIELDSTRENGTH = 17;
    private static final int DATA_MINIONSLEFT = 18;
    private static final int DATA_BOSSHEALTH = 19;
    private static final int DATA_ATTACKTYPE = 20;
    EntityTFLich masterLich;
    private static final ItemStack[] heldItems = new ItemStack[]{new ItemStack(TFItems.scepterTwilight, 1), new ItemStack(TFItems.scepterZombie, 1), new ItemStack(Items.golden_sword, 1)};
    public static final int MAX_SHADOW_CLONES = 2;
    public static final int INITIAL_SHIELD_STRENGTH = 5;
    public static final int MAX_ACTIVE_MINIONS = 3;
    public static final int INITIAL_MINIONS_TO_SUMMON = 9;
    public static final int MAX_HEALTH = 100;

    public EntityTFLich(World world) {
        super(world);
        this.setSize(1.1f, 2.5f);
        this.setShadowClone(false);
        this.masterLich = null;
        this.isImmuneToFire = true;
        this.setShieldStrength(5);
        this.setMinionsToSummon(9);
        this.experienceValue = 217;
    }

    public EntityTFLich(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y, z);
    }

    public EntityTFLich(World world, EntityTFLich otherLich) {
        this(world);
        this.setShadowClone(true);
        this.masterLich = otherLich;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(21, (Object)0);
        this.dataWatcher.addObject(17, (Object)0);
        this.dataWatcher.addObject(18, (Object)0);
        this.dataWatcher.addObject(19, (Object)new Integer(100));
        this.dataWatcher.addObject(20, (Object)0);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(100.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(6.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.8f);
    }

    public ItemStack getHeldItem() {
        return heldItems[this.getPhase() - 1];
    }

    protected void dropFewItems(boolean par1, int par2) {
        int i;
        this.dropScepter();
        int totalDrops = this.rand.nextInt(3 + par2) + 2;
        for (i = 0; i < totalDrops; ++i) {
            this.dropGoldThing();
        }
        totalDrops = this.rand.nextInt(4 + par2) + 1;
        for (i = 0; i < totalDrops; ++i) {
            this.dropItem(Items.ender_pearl, 1);
        }
        totalDrops = this.rand.nextInt(5 + par2) + 5;
        for (i = 0; i < totalDrops; ++i) {
            this.dropItem(Items.bone, 1);
        }
        this.entityDropItem(new ItemStack(TFItems.trophy, 1, 2), 0.0f);
    }

    private void dropScepter() {
        int scepterType = this.rand.nextInt(3);
        switch (scepterType) {
            case 0: {
                this.entityDropItem(new ItemStack(TFItems.scepterZombie), 0.0f);
                break;
            }
            case 1: {
                this.entityDropItem(new ItemStack(TFItems.scepterLifeDrain), 0.0f);
                break;
            }
            default: {
                this.entityDropItem(new ItemStack(TFItems.scepterTwilight), 0.0f);
            }
        }
    }

    private void dropGoldThing() {
        ItemStack goldThing;
        int thingType = this.rand.nextInt(5);
        switch (thingType) {
            case 0: {
                goldThing = new ItemStack(Items.golden_sword);
                break;
            }
            case 1: {
                goldThing = new ItemStack((Item)Items.golden_helmet);
                break;
            }
            case 2: {
                goldThing = new ItemStack((Item)Items.golden_chestplate);
                break;
            }
            case 3: {
                goldThing = new ItemStack((Item)Items.golden_leggings);
                break;
            }
            default: {
                goldThing = new ItemStack((Item)Items.golden_boots);
            }
        }
        EnchantmentHelper.addRandomEnchantment((Random)this.rand, (ItemStack)goldThing, (int)(10 + this.rand.nextInt(30)));
        this.entityDropItem(goldThing, 0.0f);
    }

    public void setInWeb() {
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean handleLavaMovement() {
        return false;
    }

    public boolean isInWater() {
        return false;
    }

    public int getPhase() {
        if (this.isShadowClone() || this.getShieldStrength() > 0) {
            return 1;
        }
        if (this.getMinionsToSummon() > 0) {
            return 2;
        }
        return 3;
    }

    public void onLivingUpdate() {
        float angle = this.renderYawOffset * 3.141593f / 180.0f;
        double dx = this.posX + (double)MathHelper.cos((float)angle) * 0.65;
        double dy = this.posY + (double)this.height * 0.94;
        double dz = this.posZ + (double)MathHelper.sin((float)angle) * 0.65;
        int factor = (80 - this.attackTime) / 10;
        int particles = factor > 0 ? this.rand.nextInt(factor) : 1;
        for (int j1 = 0; j1 < particles; ++j1) {
            float sparkle = 1.0f - ((float)this.attackTime + 1.0f) / 60.0f;
            sparkle *= sparkle;
            float red = 0.37f * sparkle;
            float grn = 0.99f * sparkle;
            float blu = 0.89f * sparkle;
            if (this.getNextAttackType() != 0) {
                red = 0.99f * sparkle;
                grn = 0.47f * sparkle;
                blu = 0.0f * sparkle;
            }
            this.worldObj.spawnParticle("mobSpell", dx + this.rand.nextGaussian() * 0.025, dy + this.rand.nextGaussian() * 0.025, dz + this.rand.nextGaussian() * 0.025, (double)red, (double)grn, (double)blu);
        }
        if (this.isShadowClone()) {
            this.checkForMaster();
        }
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(19, (Object)((int)this.getHealth()));
        }
        super.onLivingUpdate();
    }

    public boolean attackEntityFrom(DamageSource damageSource, float damage) {
        if (damageSource.getDamageType() == "inWall" && this.entityToAttack != null) {
            this.teleportToSightOfEntity(this.entityToAttack);
        }
        if (this.isShadowClone()) {
            this.worldObj.playSoundAtEntity((Entity)this, "random.fizz", 1.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            return false;
        }
        Entity prevTarget = this.entityToAttack;
        if (damageSource.getEntity() instanceof EntityTFLich) {
            return false;
        }
        if (this.getShieldStrength() > 0) {
            if (damageSource.isUnblockable() && damage > 2.0f) {
                if (this.getShieldStrength() > 0) {
                    this.setShieldStrength(this.getShieldStrength() - 1);
                    this.worldObj.playSoundAtEntity((Entity)this, "random.break", 1.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
            } else {
                this.worldObj.playSoundAtEntity((Entity)this, "random.break", 1.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                if (damageSource.getEntity() instanceof EntityPlayer) {
                    this.entityToAttack = damageSource.getEntity();
                }
            }
            return false;
        }
        if (super.attackEntityFrom(damageSource, damage)) {
            if (this.entityToAttack instanceof EntityTFLich) {
                this.entityToAttack = prevTarget;
            }
            if (this.getPhase() < 3 || this.rand.nextInt(4) == 0) {
                this.teleportToSightOfEntity(this.entityToAttack);
            }
            return true;
        }
        return false;
    }

    protected void attackEntity(Entity targetedEntity, float f) {
        if (!this.isShadowClone() && this.attackTime % 15 == 0) {
            this.popNearbyMob();
        }
        if (this.getPhase() == 1) {
            if (this.attackTime == 60 && !this.worldObj.isRemote) {
                this.teleportToSightOfEntity(targetedEntity);
                if (!this.isShadowClone()) {
                    this.checkAndSpawnClones(targetedEntity);
                }
            }
            if (this.canEntityBeSeen(targetedEntity) && this.attackTime == 0 && f < 20.0f) {
                if (this.getNextAttackType() == 0) {
                    this.launchBoltAt(targetedEntity);
                } else {
                    this.launchBombAt(targetedEntity);
                }
                if (this.rand.nextInt(3) > 0) {
                    this.setNextAttackType(0);
                } else {
                    this.setNextAttackType(1);
                }
                this.attackTime = 100;
            }
            this.hasAttacked = true;
        }
        if (this.getPhase() == 2 && !this.isShadowClone()) {
            this.despawnClones();
            if (this.attackTime % 15 == 0) {
                this.checkAndSpawnMinions(targetedEntity);
            }
            if (this.attackTime == 0) {
                if (f < 2.0f) {
                    this.attackEntityAsMob(targetedEntity);
                    this.attackTime = 20;
                } else if (f < 20.0f && this.canEntityBeSeen(targetedEntity)) {
                    if (this.getNextAttackType() == 0) {
                        this.launchBoltAt(targetedEntity);
                    } else {
                        this.launchBombAt(targetedEntity);
                    }
                    if (this.rand.nextInt(2) > 0) {
                        this.setNextAttackType(0);
                    } else {
                        this.setNextAttackType(1);
                    }
                    this.attackTime = 60;
                } else {
                    this.teleportToSightOfEntity(targetedEntity);
                    this.attackTime = 20;
                }
            }
            this.hasAttacked = true;
        }
        if (this.getPhase() == 3 && this.attackTime <= 0 && f < 2.0f && targetedEntity.boundingBox.maxY > this.boundingBox.minY && targetedEntity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            this.attackEntityAsMob(targetedEntity);
            this.hasAttacked = true;
        }
    }

    protected void launchBoltAt(Entity targetedEntity) {
        float bodyFacingAngle = this.renderYawOffset * 3.141593f / 180.0f;
        double sx = this.posX + (double)MathHelper.cos((float)bodyFacingAngle) * 0.65;
        double sy = this.posY + (double)this.height * 0.82;
        double sz = this.posZ + (double)MathHelper.sin((float)bodyFacingAngle) * 0.65;
        double tx = targetedEntity.posX - sx;
        double ty = targetedEntity.boundingBox.minY + (double)(targetedEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
        double tz = targetedEntity.posZ - sz;
        this.worldObj.playSoundAtEntity((Entity)this, "mob.ghast.fireball", this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        EntityTFLichBolt projectile = new EntityTFLichBolt(this.worldObj, (EntityLivingBase)this);
        projectile.setThrowableHeading(tx, ty, tz, projectile.func_70182_d(), 1.0f);
        projectile.setLocationAndAngles(sx, sy, sz, this.rotationYaw, this.rotationPitch);
        this.worldObj.spawnEntityInWorld((Entity)projectile);
    }

    protected void launchBombAt(Entity targetedEntity) {
        float bodyFacingAngle = this.renderYawOffset * 3.141593f / 180.0f;
        double sx = this.posX + (double)MathHelper.cos((float)bodyFacingAngle) * 0.65;
        double sy = this.posY + (double)this.height * 0.82;
        double sz = this.posZ + (double)MathHelper.sin((float)bodyFacingAngle) * 0.65;
        double tx = targetedEntity.posX - sx;
        double ty = targetedEntity.boundingBox.minY + (double)(targetedEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
        double tz = targetedEntity.posZ - sz;
        this.worldObj.playSoundAtEntity((Entity)this, "mob.ghast.fireball", this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        EntityTFLichBomb projectile = new EntityTFLichBomb(this.worldObj, (EntityLivingBase)this);
        projectile.setThrowableHeading(tx, ty, tz, projectile.func_40077_c(), 1.0f);
        projectile.setLocationAndAngles(sx, sy, sz, this.rotationYaw, this.rotationPitch);
        this.worldObj.spawnEntityInWorld((Entity)projectile);
    }

    protected void popNearbyMob() {
        List nearbyMobs = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(32.0, 16.0, 32.0));
        for (Entity entity : nearbyMobs) {
            if (!(entity instanceof EntityLiving) || !this.canPop(entity) || !this.canEntityBeSeen(entity)) continue;
            EntityLiving mob = (EntityLiving)entity;
            if (!this.worldObj.isRemote) {
                mob.setDead();
                mob.spawnExplosionParticle();
            }
            this.makeRedMagicTrail(mob.posX, mob.posY + (double)mob.height / 2.0, mob.posZ, this.posX, this.posY + (double)this.height / 2.0, this.posZ);
            break;
        }
    }

    protected boolean canPop(Entity nearby) {
        Class[] poppable;
        for (Class pop : poppable = new Class[]{EntitySkeleton.class, EntityZombie.class, EntityEnderman.class, EntitySpider.class, EntityCreeper.class, EntityTFSwarmSpider.class}) {
            if (nearby.getClass() != pop) continue;
            return true;
        }
        return false;
    }

    protected void checkAndSpawnClones(Entity targetedEntity) {
        if (this.countMyClones() < 2) {
            this.spawnShadowClone(targetedEntity);
        }
    }

    protected int countMyClones() {
        List nearbyLiches = this.worldObj.getEntitiesWithinAABB(EntityTFLich.class, AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(32.0, 16.0, 32.0));
        int count = 0;
        for (EntityTFLich nearbyLich : nearbyLiches) {
            if (!nearbyLich.isShadowClone() || nearbyLich.masterLich != this) continue;
            ++count;
        }
        return count;
    }

    public boolean wantsNewClone(EntityTFLich clone) {
        return clone.isShadowClone() && this.countMyClones() < 2;
    }

    protected void spawnShadowClone(Entity targetedEntity) {
        Vec3 cloneSpot = this.findVecInLOSOf(targetedEntity);
        EntityTFLich newClone = new EntityTFLich(this.worldObj, this);
        newClone.setPosition(cloneSpot.xCoord, cloneSpot.yCoord, cloneSpot.zCoord);
        this.worldObj.spawnEntityInWorld((Entity)newClone);
        newClone.entityToAttack = targetedEntity;
        newClone.attackTime = 60 + this.rand.nextInt(3) - this.rand.nextInt(3);
        this.makeTeleportTrail(this.posX, this.posY, this.posZ, cloneSpot.xCoord, cloneSpot.yCoord, cloneSpot.zCoord);
    }

    protected void despawnClones() {
        List nearbyLiches = this.worldObj.getEntitiesWithinAABB(((Object)((Object)this)).getClass(), AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(32.0, 16.0, 32.0));
        for (EntityTFLich nearbyLich : nearbyLiches) {
            if (!nearbyLich.isShadowClone()) continue;
            nearbyLich.isDead = true;
        }
    }

    protected void checkAndSpawnMinions(Entity targetedEntity) {
        int minions;
        if (!this.worldObj.isRemote && this.getMinionsToSummon() > 0 && (minions = this.countMyMinions()) < 3) {
            this.spawnMinionAt((EntityLivingBase)targetedEntity);
            this.setMinionsToSummon(this.getMinionsToSummon() - 1);
        }
    }

    protected int countMyMinions() {
        List nearbyMinons = this.worldObj.getEntitiesWithinAABB(EntityTFLichMinion.class, AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(32.0, 16.0, 32.0));
        int count = 0;
        for (EntityTFLichMinion nearbyMinon : nearbyMinons) {
            if (nearbyMinon.master != this) continue;
            ++count;
        }
        return count;
    }

    protected void spawnMinionAt(EntityLivingBase targetedEntity) {
        Vec3 minionSpot = this.findVecInLOSOf((Entity)targetedEntity);
        EntityTFLichMinion minion = new EntityTFLichMinion(this.worldObj, this);
        minion.setPosition(minionSpot.xCoord, minionSpot.yCoord, minionSpot.zCoord);
        this.worldObj.spawnEntityInWorld((Entity)minion);
        minion.setAttackTarget(targetedEntity);
        minion.spawnExplosionParticle();
        this.worldObj.playSoundAtEntity((Entity)minion, "random.pop", 1.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        this.makeBlackMagicTrail(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ, minionSpot.xCoord, minionSpot.yCoord + (double)minion.height / 2.0, minionSpot.zCoord);
    }

    public boolean wantsNewMinion(EntityTFLichMinion minion) {
        return this.countMyMinions() < 3;
    }

    protected void checkForMaster() {
        if (this.masterLich == null) {
            this.findNewMaster();
        }
        if (!this.worldObj.isRemote && (this.masterLich == null || this.masterLich.isDead)) {
            this.isDead = true;
        }
    }

    private void findNewMaster() {
        List nearbyLiches = this.worldObj.getEntitiesWithinAABB(EntityTFLich.class, AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(32.0, 16.0, 32.0));
        for (EntityTFLich nearbyLich : nearbyLiches) {
            if (nearbyLich.isShadowClone() || !nearbyLich.wantsNewClone(this)) continue;
            this.masterLich = nearbyLich;
            this.makeTeleportTrail(this.posX, this.posY, this.posZ, nearbyLich.posX, nearbyLich.posY, nearbyLich.posZ);
            this.setAttackTarget(this.masterLich.getAttackTarget());
            break;
        }
    }

    protected void teleportToSightOfEntity(Entity entity) {
        Vec3 dest = this.findVecInLOSOf(entity);
        double srcX = this.posX;
        double srcY = this.posY;
        double srcZ = this.posZ;
        if (dest != null) {
            this.teleportToNoChecks(dest.xCoord, dest.yCoord, dest.zCoord);
            this.faceEntity(entity, 100.0f, 100.0f);
            this.renderYawOffset = this.rotationYaw;
            if (!this.canEntityBeSeen(entity)) {
                this.teleportToNoChecks(srcX, srcY, srcZ);
            }
        }
    }

    protected Vec3 findVecInLOSOf(Entity targetEntity) {
        if (targetEntity == null) {
            return null;
        }
        double tx = 0.0;
        double ty = 0.0;
        double tz = 0.0;
        int tries = 100;
        for (int i = 0; i < tries; ++i) {
            float halfWidth;
            AxisAlignedBB destBox;
            tx = targetEntity.posX + this.rand.nextGaussian() * 16.0;
            ty = targetEntity.posY + this.rand.nextGaussian() * 8.0;
            tz = targetEntity.posZ + this.rand.nextGaussian() * 16.0;
            boolean groundFlag = false;
            int bx = MathHelper.floor_double((double)tx);
            int by = MathHelper.floor_double((double)ty);
            int bz = MathHelper.floor_double((double)tz);
            while (!groundFlag && ty > 0.0) {
                Block whatsThere = this.worldObj.getBlock(bx, by - 1, bz);
                if (whatsThere == Blocks.air || !whatsThere.getMaterial().isSolid()) {
                    ty -= 1.0;
                    --by;
                    continue;
                }
                groundFlag = true;
            }
            if (by != 0 && this.canEntitySee(targetEntity, tx, ty, tz) && this.worldObj.getCollidingBoundingBoxes((Entity)this, destBox = AxisAlignedBB.getBoundingBox((double)(tx - (double)(halfWidth = this.width / 2.0f)), (double)(ty - (double)this.yOffset + (double)this.ySize), (double)(tz - (double)halfWidth), (double)(tx + (double)halfWidth), (double)(ty - (double)this.yOffset + (double)this.ySize + (double)this.height), (double)(tz + (double)halfWidth))).size() <= 0 && !this.worldObj.isAnyLiquid(destBox)) break;
        }
        if (tries == 99) {
            return null;
        }
        return Vec3.createVectorHelper((double)tx, (double)ty, (double)tz);
    }

    protected boolean canEntitySee(Entity entity, double dx, double dy, double dz) {
        return this.worldObj.rayTraceBlocks(Vec3.createVectorHelper((double)entity.posX, (double)(entity.posY + (double)entity.getEyeHeight()), (double)entity.posZ), Vec3.createVectorHelper((double)dx, (double)dy, (double)dz)) == null;
    }

    protected boolean teleportToNoChecks(double destX, double destY, double destZ) {
        double srcX = this.posX;
        double srcY = this.posY;
        double srcZ = this.posZ;
        this.setPosition(destX, destY, destZ);
        this.makeTeleportTrail(srcX, srcY, srcZ, destX, destY, destZ);
        this.worldObj.playSoundEffect(srcX, srcY, srcZ, "mob.endermen.portal", 1.0f, 1.0f);
        this.worldObj.playSoundAtEntity((Entity)this, "mob.endermen.portal", 1.0f, 1.0f);
        this.isJumping = false;
        return true;
    }

    protected void makeTeleportTrail(double srcX, double srcY, double srcZ, double destX, double destY, double destZ) {
        int particles = 128;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            float f = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            double tx = srcX + (destX - srcX) * trailFactor + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            double ty = srcY + (destY - srcY) * trailFactor + this.rand.nextDouble() * (double)this.height;
            double tz = srcZ + (destZ - srcZ) * trailFactor + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            this.worldObj.spawnParticle("spell", tx, ty, tz, (double)f, (double)f1, (double)f2);
        }
    }

    protected void makeRedMagicTrail(double srcX, double srcY, double srcZ, double destX, double destY, double destZ) {
        int particles = 32;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            float f = 1.0f;
            float f1 = 0.5f;
            float f2 = 0.5f;
            double tx = srcX + (destX - srcX) * trailFactor + this.rand.nextGaussian() * 0.005;
            double ty = srcY + (destY - srcY) * trailFactor + this.rand.nextGaussian() * 0.005;
            double tz = srcZ + (destZ - srcZ) * trailFactor + this.rand.nextGaussian() * 0.005;
            this.worldObj.spawnParticle("mobSpell", tx, ty, tz, (double)f, (double)f1, (double)f2);
        }
    }

    protected void makeBlackMagicTrail(double srcX, double srcY, double srcZ, double destX, double destY, double destZ) {
        int particles = 32;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            float f = 0.2f;
            float f1 = 0.2f;
            float f2 = 0.2f;
            double tx = srcX + (destX - srcX) * trailFactor + this.rand.nextGaussian() * 0.005;
            double ty = srcY + (destY - srcY) * trailFactor + this.rand.nextGaussian() * 0.005;
            double tz = srcZ + (destZ - srcZ) * trailFactor + this.rand.nextGaussian() * 0.005;
            this.worldObj.spawnParticle("mobSpell", tx, ty, tz, (double)f, (double)f1, (double)f2);
        }
    }

    public boolean isShadowClone() {
        return (this.dataWatcher.getWatchableObjectByte(21) & 2) != 0;
    }

    public void setShadowClone(boolean par1) {
        byte var2 = this.dataWatcher.getWatchableObjectByte(21);
        if (par1) {
            this.dataWatcher.updateObject(21, (Object)((byte)(var2 | 2)));
        } else {
            this.dataWatcher.updateObject(21, (Object)((byte)(var2 & 0xFFFFFFFD)));
        }
    }

    public byte getShieldStrength() {
        return this.dataWatcher.getWatchableObjectByte(17);
    }

    public void setShieldStrength(int shieldStrength) {
        this.dataWatcher.updateObject(17, (Object)((byte)shieldStrength));
    }

    public byte getMinionsToSummon() {
        return this.dataWatcher.getWatchableObjectByte(18);
    }

    public void setMinionsToSummon(int minionsToSummon) {
        this.dataWatcher.updateObject(18, (Object)((byte)minionsToSummon));
    }

    public byte getNextAttackType() {
        return this.dataWatcher.getWatchableObjectByte(20);
    }

    public void setNextAttackType(int attackType) {
        this.dataWatcher.updateObject(20, (Object)((byte)attackType));
    }

    protected String getLivingSound() {
        return "mob.blaze.breathe";
    }

    protected String getHurtSound() {
        return "mob.blaze.hit";
    }

    protected String getDeathSound() {
        return "mob.blaze.death";
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBoolean("ShadowClone", this.isShadowClone());
        nbttagcompound.setByte("ShieldStrength", this.getShieldStrength());
        nbttagcompound.setByte("MinionsToSummon", this.getMinionsToSummon());
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setShadowClone(nbttagcompound.getBoolean("ShadowClone"));
        this.setShieldStrength(nbttagcompound.getByte("ShieldStrength"));
        this.setMinionsToSummon(nbttagcompound.getByte("MinionsToSummon"));
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightKillLich);
        }
        if (!this.worldObj.isRemote && !this.isShadowClone()) {
            int dx = MathHelper.floor_double((double)this.posX);
            int dy = MathHelper.floor_double((double)this.posY);
            int dz = MathHelper.floor_double((double)this.posZ);
            if (this.worldObj.provider instanceof WorldProviderTwilightForest) {
                ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)this.worldObj.provider).getChunkProvider();
                TFFeature nearbyFeature = ((TFWorldChunkManager)this.worldObj.provider.worldChunkMgr).getFeatureAt(dx, dz, this.worldObj);
                if (nearbyFeature == TFFeature.lichTower) {
                    chunkProvider.setStructureConquered(dx, dy, dz, true);
                }
            }
        }
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }
}

