/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.entity.EntityTFYeti;
import twilightforest.entity.TFDamageSources;
import twilightforest.entity.boss.EntityTFYetiAlpha;

public class EntityTFIceBomb
extends EntityThrowable {
    private int zoneTimer = 80;
    private boolean hasHit;

    public EntityTFIceBomb(World world) {
        super(world);
    }

    public EntityTFIceBomb(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    protected void onImpact(MovingObjectPosition mop) {
        double dist;
        if (this.getThrower() != null && this.getThrower() instanceof EntityTFYetiAlpha && (dist = this.getDistanceSqToEntity((Entity)this.getThrower())) <= 100.0) {
            this.setDead();
        }
        this.motionY = 0.0;
        this.hasHit = true;
        if (!this.worldObj.isRemote) {
            this.doTerrainEffects();
        }
    }

    private void doTerrainEffects() {
        int range = 3;
        int ix = MathHelper.floor_double((double)this.lastTickPosX);
        int iy = MathHelper.floor_double((double)this.lastTickPosY);
        int iz = MathHelper.floor_double((double)this.lastTickPosZ);
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    this.doTerrainEffect(ix + x, iy + y, iz + z);
                }
            }
        }
    }

    private void doTerrainEffect(int x, int y, int z) {
        if (this.worldObj.getBlock(x, y, z).getMaterial() == Material.water) {
            this.worldObj.setBlock(x, y, z, Blocks.ice);
        }
        if (this.worldObj.getBlock(x, y, z).getMaterial() == Material.lava) {
            this.worldObj.setBlock(x, y, z, Blocks.obsidian);
        }
        if (this.worldObj.isAirBlock(x, y, z) && Blocks.snow_layer.canPlaceBlockAt(this.worldObj, x, y, z)) {
            this.worldObj.setBlock(x, y, z, Blocks.snow_layer);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.hasHit) {
            if (!this.worldObj.isRemote) {
                this.motionX *= 0.1;
                this.motionY *= 0.1;
                this.motionZ *= 0.1;
            }
            --this.zoneTimer;
            this.makeIceZone();
            if (this.zoneTimer <= 0) {
                this.detonate();
            }
        } else {
            this.makeTrail();
        }
    }

    public void makeTrail() {
        for (int i = 0; i < 10; ++i) {
            double dx = this.posX + (double)(0.75f * (this.rand.nextFloat() - 0.5f));
            double dy = this.posY + (double)(0.75f * (this.rand.nextFloat() - 0.5f));
            double dz = this.posZ + (double)(0.75f * (this.rand.nextFloat() - 0.5f));
            TwilightForestMod.proxy.spawnParticle(this.worldObj, "snowstuff", dx, dy, dz, 0.0, 0.0, 0.0);
        }
    }

    private void makeIceZone() {
        if (this.worldObj.isRemote) {
            for (int i = 0; i < 20; ++i) {
                double dx = this.posX + (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 3.0f);
                double dy = this.posY + (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 3.0f);
                double dz = this.posZ + (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 3.0f);
                TwilightForestMod.proxy.spawnParticle(this.worldObj, "snowstuff", dx, dy, dz, 0.0, 0.0, 0.0);
            }
        } else if (this.zoneTimer % 10 == 0) {
            this.hitNearbyEntities();
        }
    }

    private void hitNearbyEntities() {
        ArrayList nearby = new ArrayList(this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.expand(3.0, 2.0, 3.0)));
        for (Entity entity : nearby) {
            if (!(entity instanceof EntityLivingBase) || entity == this.getThrower()) continue;
            if (entity instanceof EntityTFYeti) {
                entity.setDead();
                int ix = MathHelper.floor_double((double)entity.lastTickPosX);
                int iy = MathHelper.floor_double((double)entity.lastTickPosY);
                int iz = MathHelper.floor_double((double)entity.lastTickPosZ);
                this.worldObj.setBlock(ix, iy, iz, Blocks.ice);
                this.worldObj.setBlock(ix, iy + 1, iz, Blocks.ice);
                continue;
            }
            entity.attackEntityFrom(TFDamageSources.iceBomb, 1.0f);
            int chillLevel = 2;
            ((EntityLivingBase)entity).addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 100, chillLevel, true));
        }
    }

    private void detonate() {
        this.setDead();
    }

    public Block getBlock() {
        return Blocks.packed_ice;
    }

    protected float func_70182_d() {
        return 0.75f;
    }

    protected float getGravityVelocity() {
        return this.hasHit ? 0.0f : 0.025f;
    }

    protected float func_70183_g() {
        return -20.0f;
    }
}

