/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityTFHydraMortar
extends EntityThrowable {
    private static final int BURN_FACTOR = 5;
    private static final int DIRECT_DAMAGE = 18;
    public EntityLivingBase playerReflects = null;
    public int fuse = 80;
    public boolean megaBlast = false;

    public EntityTFHydraMortar(World par1World) {
        super(par1World);
        this.setSize(0.75f, 0.75f);
    }

    public EntityTFHydraMortar(World par1World, EntityLivingBase par2EntityLiving) {
        super(par1World, par2EntityLiving);
        this.setSize(0.75f, 0.75f);
    }

    public void onUpdate() {
        super.onUpdate();
        this.func_145771_j(this.posX, (this.boundingBox.minY + this.boundingBox.maxY) / 2.0, this.posZ);
        if (this.onGround) {
            if (!this.worldObj.isRemote) {
                this.motionX *= 0.9;
                this.motionY *= 0.9;
                this.motionZ *= 0.9;
            }
            if (this.fuse-- <= 0) {
                this.detonate();
            }
        }
    }

    public void setToBlasting() {
        this.megaBlast = true;
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.entityHit == null && !this.megaBlast) {
            this.motionY = 0.0;
            this.onGround = true;
        } else {
            this.detonate();
        }
    }

    public float func_145772_a(Explosion par1Explosion, World par2World, int par3, int par4, int par5, Block par6Block) {
        float var6 = super.func_145772_a(par1Explosion, par2World, par3, par4, par5, par6Block);
        if (this.megaBlast && par6Block != Blocks.bedrock && par6Block != Blocks.end_portal && par6Block != Blocks.end_portal_frame) {
            var6 = Math.min(0.8f, var6);
        }
        return var6;
    }

    protected void detonate() {
        float explosionPower = this.megaBlast ? 4.0f : 0.1f;
        this.worldObj.newExplosion((Entity)this, this.posX, this.posY, this.posZ, explosionPower, true, true);
        if (!this.worldObj.isRemote) {
            ArrayList nearbyList = new ArrayList(this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.expand(1.0, 1.0, 1.0)));
            for (Entity nearby : nearbyList) {
                if (!nearby.attackEntityFrom(DamageSource.causeFireballDamage(null, (Entity)this.getThrower()), 18.0f) || nearby.isImmuneToFire()) continue;
                nearby.setFire(5);
            }
        }
        this.setDead();
    }

    public boolean attackEntityFrom(DamageSource damagesource, float i) {
        this.setBeenAttacked();
        if (damagesource.getEntity() != null && !this.worldObj.isRemote) {
            Vec3 vec3d = damagesource.getEntity().getLookVec();
            if (vec3d != null) {
                this.setThrowableHeading(vec3d.xCoord, vec3d.yCoord + 1.0, vec3d.zCoord, 1.5f, 0.1f);
                this.onGround = false;
                this.fuse += 20;
            }
            if (damagesource.getEntity() instanceof EntityLivingBase) {
                this.playerReflects = (EntityLivingBase)damagesource.getEntity();
            }
            return true;
        }
        return false;
    }

    public EntityLivingBase getThrower() {
        if (this.playerReflects != null) {
            return this.playerReflects;
        }
        return super.getThrower();
    }

    public boolean isBurning() {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public float getCollisionBorderSize() {
        return 1.5f;
    }

    protected float getGravityVelocity() {
        return 0.05f;
    }

    protected float func_70182_d() {
        return 0.75f;
    }

    protected float func_70183_g() {
        return -20.0f;
    }
}

