/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.entity.boss.EntityTFYetiAlpha;

public class EntityTFFallingIce
extends Entity {
    private static final int HANG_TIME = 100;
    private int fallTime;
    private float hurtAmount;
    private int hurtMax;

    public EntityTFFallingIce(World par1World) {
        super(par1World);
        this.setSize(2.98f, 2.98f);
        this.hurtAmount = 10.0f;
        this.hurtMax = 30;
    }

    public EntityTFFallingIce(World par1World, int x, int y, int z) {
        this(par1World);
        this.preventEntitySpawning = true;
        this.setPosition(x, y, z);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected void entityInit() {
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        ++this.fallTime;
        if (this.fallTime > 100) {
            this.motionY -= (double)0.04f;
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (!this.worldObj.isRemote && this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
            this.motionY *= -0.5;
            this.setDead();
        }
        if (!this.worldObj.isRemote) {
            ArrayList nearby = new ArrayList(this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox));
            for (Entity entity : nearby) {
                EntityTFFallingIce otherIce;
                if (!(entity instanceof EntityTFFallingIce) || (otherIce = (EntityTFFallingIce)entity).getFallTime() >= this.fallTime) continue;
                otherIce.setDead();
            }
            this.destroyIceInAABB(this.boundingBox.expand(0.5, 0.0, 0.5));
        }
        this.makeTrail();
    }

    public void makeTrail() {
        for (int i = 0; i < 2; ++i) {
            double dx = this.posX + (double)(2.0f * (this.rand.nextFloat() - this.rand.nextFloat()));
            double dy = this.posY - 3.0 + (double)(3.0f * (this.rand.nextFloat() - this.rand.nextFloat()));
            double dz = this.posZ + (double)(2.0f * (this.rand.nextFloat() - this.rand.nextFloat()));
            TwilightForestMod.proxy.spawnParticle(this.worldObj, "snowwarning", dx, dy, dz, 0.0, -1.0, 0.0);
        }
    }

    protected void fall(float par1) {
        int distance = MathHelper.ceiling_float_int((float)(par1 - 1.0f));
        if (distance > 0) {
            ArrayList nearby = new ArrayList(this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.expand(2.0, 0.0, 2.0)));
            DamageSource damagesource = DamageSource.fallingBlock;
            for (Entity entity : nearby) {
                if (entity instanceof EntityTFYetiAlpha) continue;
                entity.attackEntityFrom(damagesource, (float)Math.min(MathHelper.floor_float((float)((float)distance * this.hurtAmount)), this.hurtMax));
            }
        }
        for (int i = 0; i < 200; ++i) {
            double dx = this.posX + (double)(3.0f * (this.rand.nextFloat() - this.rand.nextFloat()));
            double dy = this.posY + 2.0 + (double)(3.0f * (this.rand.nextFloat() - this.rand.nextFloat()));
            double dz = this.posZ + (double)(3.0f * (this.rand.nextFloat() - this.rand.nextFloat()));
            this.worldObj.spawnParticle("blockcrack_" + Block.getIdFromBlock((Block)Blocks.packed_ice) + "_0", dx, dy, dz, 0.0, 0.0, 0.0);
        }
        this.playSound(Blocks.anvil.stepSound.getBreakSound(), 3.0f, 0.5f);
        this.playSound(Blocks.packed_ice.stepSound.getBreakSound(), 3.0f, 0.5f);
    }

    public void destroyIceInAABB(AxisAlignedBB par1AxisAlignedBB) {
        int minX = MathHelper.floor_double((double)par1AxisAlignedBB.minX);
        int minY = MathHelper.floor_double((double)par1AxisAlignedBB.minY);
        int minZ = MathHelper.floor_double((double)par1AxisAlignedBB.minZ);
        int maxX = MathHelper.floor_double((double)par1AxisAlignedBB.maxX);
        int maxY = MathHelper.floor_double((double)par1AxisAlignedBB.maxY);
        int maxZ = MathHelper.floor_double((double)par1AxisAlignedBB.maxZ);
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dy = minY; dy <= maxY; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    Block block = this.worldObj.getBlock(dx, dy, dz);
                    if (block != Blocks.ice && block != Blocks.packed_ice && block != Blocks.stone) continue;
                    this.worldObj.setBlock(dx, dy, dz, Blocks.air, 0, 3);
                }
            }
        }
    }

    protected void readEntityFromNBT(NBTTagCompound var1) {
    }

    protected void writeEntityToNBT(NBTTagCompound var1) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderOnFire() {
        return false;
    }

    public Block getBlock() {
        return Blocks.packed_ice;
    }

    public int getFallTime() {
        return this.fallTime;
    }
}

