/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import twilightforest.entity.EntityTFRedcap;
import twilightforest.entity.ai.EntityAITFRedcapBase;

public class EntityAITFRedcapLightTNT
extends EntityAITFRedcapBase {
    private float pursueSpeed;
    private int delayTemptCounter;
    private int tntX;
    private int tntY;
    private int tntZ;

    public EntityAITFRedcapLightTNT(EntityTFRedcap hostEntity, float speed) {
        this.entityObj = hostEntity;
        this.pursueSpeed = speed;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        ChunkCoordinates nearbyTNT = this.findBlockTNTNearby(8);
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        if (nearbyTNT != null) {
            this.tntX = nearbyTNT.posX;
            this.tntY = nearbyTNT.posY;
            this.tntZ = nearbyTNT.posZ;
            return true;
        }
        return false;
    }

    public boolean continueExecuting() {
        return this.entityObj.worldObj.getBlock(this.tntX, this.tntY, this.tntZ) == Blocks.tnt;
    }

    public void startExecuting() {
        this.entityObj.setCurrentItemOrArmor(0, EntityTFRedcap.heldFlint);
    }

    public void resetTask() {
        this.entityObj.getNavigator().clearPathEntity();
        this.entityObj.setCurrentItemOrArmor(0, this.entityObj.getPick());
        this.delayTemptCounter = 20;
    }

    public void updateTask() {
        this.entityObj.getLookHelper().setLookPosition((double)this.tntX, (double)this.tntY, (double)this.tntZ, 30.0f, (float)this.entityObj.getVerticalFaceSpeed());
        if (this.entityObj.getDistance(this.tntX, this.tntY, this.tntZ) < 2.4) {
            this.entityObj.playLivingSound();
            Blocks.tnt.onBlockDestroyedByPlayer(this.entityObj.worldObj, this.tntX, this.tntY, this.tntZ, 1);
            this.entityObj.worldObj.setBlock(this.tntX, this.tntY, this.tntZ, Blocks.air, 0, 2);
            this.entityObj.getNavigator().clearPathEntity();
        } else {
            this.entityObj.getNavigator().tryMoveToXYZ((double)this.tntX, (double)this.tntY, (double)this.tntZ, (double)this.pursueSpeed);
        }
    }
}

