/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import twilightforest.entity.EntityTFRedcap;

public abstract class EntityAITFRedcapBase
extends EntityAIBase {
    protected EntityTFRedcap entityObj;

    public boolean isTargetLookingAtMe(EntityLivingBase attackTarget) {
        double dz = this.entityObj.posZ - attackTarget.posZ;
        double dx = this.entityObj.posX - attackTarget.posX;
        float angle = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float difference = MathHelper.abs((float)((attackTarget.rotationYaw - angle) % 360.0f));
        return difference < 60.0f || difference > 300.0f;
    }

    public ChunkCoordinates findBlockTNTNearby(int range) {
        int entityPosX = MathHelper.floor_double((double)this.entityObj.posX);
        int entityPosY = MathHelper.floor_double((double)this.entityObj.posY);
        int entityPosZ = MathHelper.floor_double((double)this.entityObj.posZ);
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    if (this.entityObj.worldObj.getBlock(entityPosX + x, entityPosY + y, entityPosZ + z) != Blocks.tnt) continue;
                    return new ChunkCoordinates(entityPosX + x, entityPosY + y, entityPosZ + z);
                }
            }
        }
        return null;
    }

    public boolean isLitTNTNearby(int range) {
        AxisAlignedBB expandedBox = this.entityObj.boundingBox.expand((double)range, (double)range, (double)range);
        List nearbyTNT = this.entityObj.worldObj.getEntitiesWithinAABB(EntityTNTPrimed.class, expandedBox);
        return nearbyTNT.size() > 0;
    }
}

