/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFNatureBolt;
import twilightforest.entity.EntityTFSlimeProjectile;
import twilightforest.entity.EntityTFTomeBolt;
import twilightforest.entity.boss.EntityTFLichBolt;

public class EntityAITFMagicAttack
extends EntityAIBase {
    public static final int SLIME = 4;
    public static final int LICH = 3;
    public static final int TOME = 2;
    public static final int NATURE = 1;
    World worldObj;
    EntityLiving entityHost;
    EntityLivingBase attackTarget;
    int rangedAttackTime = 0;
    float moveSpeed;
    int ticksLookingAtTarget = 0;
    int rangedAttackID;
    int maxRangedAttackTime;
    float attackChance;

    public EntityAITFMagicAttack(EntityLiving par1EntityLiving, float speed, int id, int time) {
        this(par1EntityLiving, speed, id, time, 1.0f);
    }

    public EntityAITFMagicAttack(EntityLiving par1EntityLiving, float speed, int id, int time, float chance) {
        this.entityHost = par1EntityLiving;
        this.worldObj = par1EntityLiving.worldObj;
        this.moveSpeed = speed;
        this.rangedAttackID = id;
        this.maxRangedAttackTime = time;
        this.attackChance = chance;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        EntityLivingBase var1 = this.entityHost.getAttackTarget();
        if (var1 == null || this.entityHost.getRNG().nextFloat() > this.attackChance) {
            return false;
        }
        this.attackTarget = var1;
        return true;
    }

    public boolean continueExecuting() {
        return this.shouldExecute() || !this.entityHost.getNavigator().noPath();
    }

    public void resetTask() {
        this.attackTarget = null;
    }

    public void updateTask() {
        double maxRange = 100.0;
        double targetDistance = this.entityHost.getDistanceSq(this.attackTarget.posX, this.attackTarget.boundingBox.minY, this.attackTarget.posZ);
        boolean canSee = this.entityHost.getEntitySenses().canSee((Entity)this.attackTarget);
        this.ticksLookingAtTarget = canSee ? ++this.ticksLookingAtTarget : 0;
        if (targetDistance <= maxRange && this.ticksLookingAtTarget >= 20) {
            this.entityHost.getNavigator().clearPathEntity();
        } else {
            this.entityHost.getNavigator().tryMoveToEntityLiving((Entity)this.attackTarget, (double)this.moveSpeed);
        }
        this.entityHost.getLookHelper().setLookPositionWithEntity((Entity)this.attackTarget, 30.0f, 30.0f);
        this.rangedAttackTime = Math.max(this.rangedAttackTime - 1, 0);
        if (this.rangedAttackTime <= 0 && targetDistance <= maxRange && canSee) {
            this.doRangedAttack();
            this.rangedAttackTime = this.maxRangedAttackTime;
        }
    }

    protected void doRangedAttack() {
        EntityThrowable projectile = null;
        if (this.rangedAttackID == 1) {
            projectile = new EntityTFNatureBolt(this.worldObj, (EntityLivingBase)this.entityHost);
            this.worldObj.playSoundAtEntity((Entity)this.entityHost, "mob.ghast.fireball", 1.0f, 1.0f / (this.entityHost.getRNG().nextFloat() * 0.4f + 0.8f));
        } else if (this.rangedAttackID == 2) {
            projectile = new EntityTFTomeBolt(this.worldObj, (EntityLivingBase)this.entityHost);
            this.worldObj.playSoundAtEntity((Entity)this.entityHost, "mob.ghast.fireball", 1.0f, 1.0f / (this.entityHost.getRNG().nextFloat() * 0.4f + 0.8f));
        } else if (this.rangedAttackID == 3) {
            projectile = new EntityTFLichBolt(this.worldObj, (EntityLivingBase)this.entityHost);
            this.worldObj.playSoundAtEntity((Entity)this.entityHost, "mob.ghast.fireball", 1.0f, 1.0f / (this.entityHost.getRNG().nextFloat() * 0.4f + 0.8f));
        } else if (this.rangedAttackID == 4) {
            projectile = new EntityTFSlimeProjectile(this.worldObj, (EntityLivingBase)this.entityHost);
            this.worldObj.playSoundAtEntity((Entity)this.entityHost, "mob.slime.small", 1.0f, 1.0f / (this.entityHost.getRNG().nextFloat() * 0.4f + 0.8f));
        }
        if (projectile != null) {
            double tx = this.attackTarget.posX - this.entityHost.posX;
            double ty = this.attackTarget.posY + (double)this.attackTarget.getEyeHeight() - (double)1.1f - projectile.posY;
            double tz = this.attackTarget.posZ - this.entityHost.posZ;
            float heightOffset = MathHelper.sqrt_double((double)(tx * tx + tz * tz)) * 0.2f;
            projectile.setThrowableHeading(tx, ty + (double)heightOffset, tz, 0.6f, 6.0f);
            this.worldObj.spawnEntityInWorld((Entity)projectile);
        }
    }
}

