/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import twilightforest.entity.boss.EntityTFSnowQueen;

public class EntityAITFHoverBeam
extends EntityAIBase {
    private static final float HOVER_HEIGHT = 3.0f;
    private static final float HOVER_RADIUS = 4.0f;
    private Class<? extends EntityLivingBase> classTarget;
    private EntityTFSnowQueen attacker;
    private double hoverPosX;
    private double hoverPosY;
    private double hoverPosZ;
    private int hoverTimer;
    private int beamTimer;
    private int maxHoverTime;
    private int maxBeamTime;
    private int seekTimer;
    private int maxSeekTime;
    private double beamY;
    private boolean isInPosition;

    public EntityAITFHoverBeam(EntityTFSnowQueen entityTFSnowQueen, Class<EntityPlayer> class1, int hoverTime, int dropTime) {
        this.attacker = entityTFSnowQueen;
        this.classTarget = class1;
        this.setMutexBits(3);
        this.maxHoverTime = hoverTime;
        this.maxSeekTime = hoverTime;
        this.maxBeamTime = dropTime;
        this.hoverTimer = 0;
        this.isInPosition = false;
    }

    public boolean shouldExecute() {
        EntityLivingBase target = this.attacker.getAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.isEntityAlive()) {
            return false;
        }
        if (this.classTarget != null && !this.classTarget.isAssignableFrom(target.getClass())) {
            return false;
        }
        return this.attacker.getCurrentPhase() == EntityTFSnowQueen.Phase.BEAM;
    }

    public boolean continueExecuting() {
        EntityLivingBase target = this.attacker.getAttackTarget();
        if (target == null || !target.isEntityAlive()) {
            return false;
        }
        if (this.attacker.getCurrentPhase() != EntityTFSnowQueen.Phase.BEAM) {
            return false;
        }
        if (this.seekTimer >= this.maxSeekTime) {
            return false;
        }
        return this.beamTimer < this.maxBeamTime;
    }

    public void startExecuting() {
        EntityLivingBase target = this.attacker.getAttackTarget();
        if (target != null) {
            this.makeNewHoverSpot(target);
        }
    }

    public void resetTask() {
        this.seekTimer = 0;
        this.hoverTimer = 0;
        this.beamTimer = 0;
        this.isInPosition = false;
        this.attacker.setBreathing(false);
    }

    public void updateTask() {
        EntityLivingBase target;
        if (this.attacker.getDistanceSq(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 1.0) {
            this.isInPosition = true;
        }
        if (this.isInPosition) {
            ++this.hoverTimer;
        } else {
            ++this.seekTimer;
        }
        if (this.hoverTimer >= this.maxHoverTime) {
            ++this.beamTimer;
            this.attacker.setBreathing(true);
            Entity target2 = this.getHeadLookTarget();
            if (target2 != null) {
                this.attacker.doBreathAttack(target2);
            }
            this.hoverPosY -= (double)0.05f;
            if (this.hoverPosY < this.beamY) {
                this.hoverPosY = this.beamY;
            }
        }
        double offsetX = this.hoverPosX - this.attacker.posX;
        double offsetY = this.hoverPosY - this.attacker.posY;
        double offsetZ = this.hoverPosZ - this.attacker.posZ;
        double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        if ((distanceDesired = (double)MathHelper.sqrt_double((double)distanceDesired)) > 0.5) {
            double velX = offsetX / distanceDesired * 0.05;
            double velY = offsetY / distanceDesired * 0.1;
            double velZ = offsetZ / distanceDesired * 0.05;
            this.attacker.addVelocity(velX, velY += (double)0.02f, velZ);
        }
        if ((target = this.attacker.getAttackTarget()) != null) {
            float tracking = this.isInPosition ? 1.0f : 20.0f;
            this.attacker.faceEntity((Entity)target, tracking, tracking);
            this.attacker.getLookHelper().setLookPositionWithEntity((Entity)target, tracking, tracking);
        }
    }

    private Entity getHeadLookTarget() {
        Entity pointedEntity = null;
        double range = 30.0;
        Vec3 srcVec = Vec3.createVectorHelper((double)this.attacker.posX, (double)(this.attacker.posY + 0.25), (double)this.attacker.posZ);
        Vec3 lookVec = this.attacker.getLook(1.0f);
        Vec3 destVec = srcVec.addVector(lookVec.xCoord * range, lookVec.yCoord * range, lookVec.zCoord * range);
        float var9 = 3.0f;
        List possibleList = this.attacker.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this.attacker, this.attacker.boundingBox.addCoord(lookVec.xCoord * range, lookVec.yCoord * range, lookVec.zCoord * range).expand((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.canBeCollidedWith() || possibleEntity == this.attacker) continue;
            float borderSize = possibleEntity.getCollisionBorderSize();
            AxisAlignedBB collisionBB = possibleEntity.boundingBox.expand((double)borderSize, (double)borderSize, (double)borderSize);
            MovingObjectPosition interceptPos = collisionBB.calculateIntercept(srcVec, destVec);
            if (collisionBB.isVecInside(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (interceptPos == null || !((possibleDist = srcVec.distanceTo(interceptPos.hitVec)) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    private void makeNewHoverSpot(EntityLivingBase target) {
        double hx = 0.0;
        double hy = 0.0;
        double hz = 0.0;
        int tries = 100;
        for (int i = 0; !(i >= tries || !this.isPositionOccupied(hx = target.posX + (double)((this.attacker.getRNG().nextFloat() - this.attacker.getRNG().nextFloat()) * 4.0f), hy = target.posY + 3.0, hz = target.posZ + (double)((this.attacker.getRNG().nextFloat() - this.attacker.getRNG().nextFloat()) * 4.0f)) && this.canEntitySee((Entity)this.attacker, hx, hy, hz) && this.canEntitySee((Entity)target, hx, hy, hz)); ++i) {
        }
        this.hoverPosX = hx;
        this.hoverPosY = hy;
        this.hoverPosZ = hz;
        this.beamY = target.posY;
        this.seekTimer = 0;
    }

    private boolean isPositionOccupied(double hx, double hy, double hz) {
        float radius = this.attacker.width / 2.0f;
        AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox((double)(hx - (double)radius), (double)hy, (double)(hz - (double)radius), (double)(hx + (double)radius), (double)(hy + (double)this.attacker.height), (double)(hz + (double)radius));
        boolean isOccupied = this.attacker.worldObj.getCollidingBoundingBoxes((Entity)this.attacker, aabb).isEmpty();
        return isOccupied;
    }

    protected boolean canEntitySee(Entity entity, double dx, double dy, double dz) {
        return entity.worldObj.rayTraceBlocks(Vec3.createVectorHelper((double)entity.posX, (double)(entity.posY + (double)entity.getEyeHeight()), (double)entity.posZ), Vec3.createVectorHelper((double)dx, (double)dy, (double)dz)) == null;
    }
}

