/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityAITFGiantAttackOnCollide
extends EntityAIBase {
    World worldObj;
    EntityCreature attacker;
    int attackTick;
    double speedTowardsTarget;
    boolean longMemory;
    PathEntity entityPathEntity;
    Class<? extends EntityLivingBase> classTarget;
    private int delayTicks;
    private double pathX;
    private double pathY;
    private double pathZ;
    private int failedPathFindingPenalty;

    public EntityAITFGiantAttackOnCollide(EntityCreature par1EntityCreature, Class<? extends EntityLivingBase> par2Class, double par3, boolean par5) {
        this(par1EntityCreature, par3, par5);
        this.classTarget = par2Class;
    }

    public EntityAITFGiantAttackOnCollide(EntityCreature par1EntityCreature, double par2, boolean par4) {
        this.attacker = par1EntityCreature;
        this.worldObj = par1EntityCreature.worldObj;
        this.speedTowardsTarget = par2;
        this.longMemory = par4;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        EntityLivingBase entitylivingbase = this.attacker.getAttackTarget();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.isEntityAlive()) {
            return false;
        }
        if (this.classTarget != null && !this.classTarget.isAssignableFrom(entitylivingbase.getClass())) {
            return false;
        }
        if (--this.delayTicks <= 0) {
            this.entityPathEntity = this.attacker.getNavigator().getPathToEntityLiving((Entity)entitylivingbase);
            this.delayTicks = 4 + this.attacker.getRNG().nextInt(7);
            return this.entityPathEntity != null;
        }
        return true;
    }

    public boolean continueExecuting() {
        EntityLivingBase entitylivingbase = this.attacker.getAttackTarget();
        return entitylivingbase == null ? false : (!entitylivingbase.isEntityAlive() ? false : (!this.longMemory ? !this.attacker.getNavigator().noPath() : this.attacker.isWithinHomeDistance(MathHelper.floor_double((double)entitylivingbase.posX), MathHelper.floor_double((double)entitylivingbase.posY), MathHelper.floor_double((double)entitylivingbase.posZ))));
    }

    public void startExecuting() {
        this.attacker.getNavigator().setPath(this.entityPathEntity, this.speedTowardsTarget);
        this.delayTicks = 0;
    }

    public void resetTask() {
        this.attacker.getNavigator().clearPathEntity();
    }

    public void updateTask() {
        EntityLivingBase entitylivingbase = this.attacker.getAttackTarget();
        this.attacker.getLookHelper().setLookPositionWithEntity((Entity)entitylivingbase, 30.0f, 30.0f);
        double distanceToAttacker = this.attacker.getDistanceSq(entitylivingbase.posX, entitylivingbase.boundingBox.minY, entitylivingbase.posZ);
        double attackRange = this.attacker.width * this.attacker.height;
        --this.delayTicks;
        if ((this.longMemory || this.attacker.getEntitySenses().canSee((Entity)entitylivingbase)) && this.delayTicks <= 0 && (this.pathX == 0.0 && this.pathY == 0.0 && this.pathZ == 0.0 || entitylivingbase.getDistanceSq(this.pathX, this.pathY, this.pathZ) >= 1.0 || this.attacker.getRNG().nextFloat() < 0.05f)) {
            PathPoint finalPathPoint;
            this.pathX = entitylivingbase.posX;
            this.pathY = entitylivingbase.boundingBox.minY;
            this.pathZ = entitylivingbase.posZ;
            this.delayTicks = this.failedPathFindingPenalty + 4 + this.attacker.getRNG().nextInt(7);
            this.failedPathFindingPenalty = this.attacker.getNavigator().getPath() != null ? ((finalPathPoint = this.attacker.getNavigator().getPath().getFinalPathPoint()) != null && entitylivingbase.getDistanceSq((double)finalPathPoint.xCoord, (double)finalPathPoint.yCoord, (double)finalPathPoint.zCoord) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            if (distanceToAttacker > 1024.0) {
                this.delayTicks += 10;
            } else if (distanceToAttacker > 256.0) {
                this.delayTicks += 5;
            }
            if (!this.attacker.getNavigator().tryMoveToEntityLiving((Entity)entitylivingbase, this.speedTowardsTarget)) {
                this.delayTicks += 15;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        if (distanceToAttacker <= attackRange && this.attackTick <= 0) {
            this.attackTick = 20;
            if (this.attacker.getHeldItem() != null) {
                this.attacker.swingItem();
            }
            this.attacker.attackEntityAsMob((Entity)entitylivingbase);
        }
    }
}

