/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import twilightforest.entity.passive.EntityTFQuestRam;

public class EntityAITFFindLoose
extends EntityAIBase {
    private EntityCreature temptedEntity;
    private Item temptID;
    private float pursueSpeed;
    private int delayTemptCounter;
    private EntityItem temptingItem;

    public EntityAITFFindLoose(EntityTFQuestRam entityTFQuestRam, float speed, Item blockID) {
        this.temptedEntity = entityTFQuestRam;
        this.pursueSpeed = speed;
        this.temptID = blockID;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingItem = null;
        List nearbyItems = this.temptedEntity.worldObj.getEntitiesWithinAABB(EntityItem.class, this.temptedEntity.boundingBox.expand(16.0, 4.0, 16.0));
        for (EntityItem itemNearby : nearbyItems) {
            if (itemNearby.getEntityItem().getItem() != this.temptID || !itemNearby.isEntityAlive()) continue;
            this.temptingItem = itemNearby;
            break;
        }
        return this.temptingItem != null;
    }

    public boolean continueExecuting() {
        return this.shouldExecute();
    }

    public void startExecuting() {
    }

    public void resetTask() {
        this.temptingItem = null;
        this.temptedEntity.getNavigator().clearPathEntity();
        this.delayTemptCounter = 100;
    }

    public void updateTask() {
        this.temptedEntity.getLookHelper().setLookPositionWithEntity((Entity)this.temptingItem, 30.0f, (float)this.temptedEntity.getVerticalFaceSpeed());
        if (this.temptedEntity.getDistanceSqToEntity((Entity)this.temptingItem) < 6.25) {
            this.temptedEntity.getNavigator().clearPathEntity();
        } else {
            this.temptedEntity.getNavigator().tryMoveToXYZ(this.temptingItem.posX, this.temptingItem.posY, this.temptingItem.posZ, (double)this.pursueSpeed);
        }
    }
}

