/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import twilightforest.entity.passive.EntityTFQuestRam;

public class EntityAITFEatLoose
extends EntityAIBase {
    private EntityTFQuestRam temptedQuestRam;
    private Item temptID;
    private int delayTemptCounter;
    private EntityItem temptingItem;

    public EntityAITFEatLoose(EntityTFQuestRam entityTFQuestRam, Item blockID) {
        this.temptedQuestRam = entityTFQuestRam;
        this.temptID = blockID;
        this.setMutexBits(0);
    }

    public boolean shouldExecute() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingItem = null;
        List nearbyItems = this.temptedQuestRam.worldObj.getEntitiesWithinAABB(EntityItem.class, this.temptedQuestRam.boundingBox.expand(2.0, 2.0, 2.0));
        for (EntityItem itemNearby : nearbyItems) {
            if (itemNearby.getEntityItem().getItem() != this.temptID || this.temptedQuestRam.isColorPresent(itemNearby.getEntityItem().getItemDamage()) || !itemNearby.isEntityAlive()) continue;
            this.temptingItem = itemNearby;
            break;
        }
        return this.temptingItem != null;
    }

    public boolean continueExecuting() {
        return this.shouldExecute();
    }

    public void startExecuting() {
    }

    public void resetTask() {
        this.temptingItem = null;
        this.temptedQuestRam.getNavigator().clearPathEntity();
        this.delayTemptCounter = 100;
    }

    public void updateTask() {
        this.temptedQuestRam.getLookHelper().setLookPositionWithEntity((Entity)this.temptingItem, 30.0f, (float)this.temptedQuestRam.getVerticalFaceSpeed());
        if (this.temptedQuestRam.getDistanceSqToEntity((Entity)this.temptingItem) < 6.25 && !this.temptedQuestRam.isColorPresent(this.temptingItem.getEntityItem().getItemDamage())) {
            this.temptingItem.setDead();
            this.temptedQuestRam.playLivingSound();
            this.temptedQuestRam.setColorPresent(this.temptingItem.getEntityItem().getItemDamage());
            this.temptedQuestRam.animateAddColor(this.temptingItem.getEntityItem().getItemDamage(), 50);
        }
    }
}

