/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import twilightforest.entity.IBreathAttacker;

public class EntityAITFBreathAttack
extends EntityAIBase {
    private EntityLiving entityHost;
    private EntityLivingBase attackTarget;
    protected double breathX;
    protected double breathY;
    protected double breathZ;
    private int maxDuration;
    private float attackChance;
    private float breathRange;
    private int durationLeft;

    public EntityAITFBreathAttack(EntityLiving par1EntityLiving, float speed, float range, int time, float chance) {
        this.entityHost = par1EntityLiving;
        this.breathRange = range;
        this.maxDuration = time;
        this.attackChance = chance;
        this.setMutexBits(7);
    }

    public boolean shouldExecute() {
        this.attackTarget = this.entityHost.getAttackTarget();
        if (this.attackTarget == null || this.entityHost.getDistanceToEntity((Entity)this.attackTarget) > this.breathRange || !this.entityHost.canEntityBeSeen((Entity)this.attackTarget)) {
            return false;
        }
        this.breathX = this.attackTarget.posX;
        this.breathY = this.attackTarget.posY + (double)this.attackTarget.getEyeHeight();
        this.breathZ = this.attackTarget.posZ;
        return this.entityHost.getRNG().nextFloat() < this.attackChance;
    }

    public void startExecuting() {
        this.durationLeft = this.maxDuration;
        if (this.entityHost instanceof IBreathAttacker) {
            ((IBreathAttacker)this.entityHost).setBreathing(true);
        }
    }

    public boolean continueExecuting() {
        return this.durationLeft > 0 && !this.entityHost.isDead && !this.attackTarget.isDead && this.entityHost.getDistanceToEntity((Entity)this.attackTarget) <= this.breathRange && this.entityHost.canEntityBeSeen((Entity)this.attackTarget);
    }

    public void updateTask() {
        Entity target;
        --this.durationLeft;
        this.entityHost.getLookHelper().setLookPosition(this.breathX, this.breathY, this.breathZ, 100.0f, 100.0f);
        this.faceVec(this.breathX, this.breathY, this.breathZ, 100.0f, 100.0f);
        if (this.maxDuration - this.durationLeft > 5 && (target = this.getHeadLookTarget()) != null) {
            ((IBreathAttacker)this.entityHost).doBreathAttack(target);
        }
    }

    public void resetTask() {
        this.durationLeft = 0;
        if (this.entityHost instanceof IBreathAttacker) {
            ((IBreathAttacker)this.entityHost).setBreathing(false);
        }
    }

    private Entity getHeadLookTarget() {
        Entity pointedEntity = null;
        double range = 30.0;
        Vec3 srcVec = Vec3.createVectorHelper((double)this.entityHost.posX, (double)(this.entityHost.posY + 0.25), (double)this.entityHost.posZ);
        Vec3 lookVec = this.entityHost.getLook(1.0f);
        Vec3 destVec = srcVec.addVector(lookVec.xCoord * range, lookVec.yCoord * range, lookVec.zCoord * range);
        float var9 = 3.0f;
        List possibleList = this.entityHost.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this.entityHost, this.entityHost.boundingBox.addCoord(lookVec.xCoord * range, lookVec.yCoord * range, lookVec.zCoord * range).expand((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.canBeCollidedWith() || possibleEntity == this.entityHost) continue;
            float borderSize = possibleEntity.getCollisionBorderSize();
            AxisAlignedBB collisionBB = possibleEntity.boundingBox.expand((double)borderSize, (double)borderSize, (double)borderSize);
            MovingObjectPosition interceptPos = collisionBB.calculateIntercept(srcVec, destVec);
            if (collisionBB.isVecInside(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (interceptPos == null || !((possibleDist = srcVec.distanceTo(interceptPos.hitVec)) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void faceVec(double xCoord, double yCoord, double zCoord, float yawConstraint, float pitchConstraint) {
        double xOffset = xCoord - this.entityHost.posX;
        double zOffset = zCoord - this.entityHost.posZ;
        double yOffset = this.entityHost.posY + 0.25 - yCoord;
        double distance = MathHelper.sqrt_double((double)(xOffset * xOffset + zOffset * zOffset));
        float xyAngle = (float)(Math.atan2(zOffset, xOffset) * 180.0 / Math.PI) - 90.0f;
        float zdAngle = (float)(-(Math.atan2(yOffset, distance) * 180.0 / Math.PI));
        this.entityHost.rotationPitch = -this.updateRotation(this.entityHost.rotationPitch, zdAngle, pitchConstraint);
        this.entityHost.rotationYaw = this.updateRotation(this.entityHost.rotationYaw, xyAngle, yawConstraint);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float var4 = MathHelper.wrapAngleTo180_float((float)(par2 - par1));
        if (var4 > par3) {
            var4 = par3;
        }
        if (var4 < -par3) {
            var4 = -par3;
        }
        return par1 + var4;
    }
}

