/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.entity.ai.EntityAITFThrowRider;
import twilightforest.item.TFItems;

public class EntityTFYeti
extends EntityMob {
    private static final int ANGER_FLAG = 16;

    public EntityTFYeti(World par1World) {
        super(par1World);
        this.setSize(1.4f, 2.4f);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAITFThrowRider((EntityCreature)this, 1.0f));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false));
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.38);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(0.0);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(4.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
    }

    public void onLivingUpdate() {
        if (this.riddenByEntity != null) {
            this.setSize(1.4f, 2.4f);
            if (this.riddenByEntity.isSneaking()) {
                this.riddenByEntity.setSneaking(false);
            }
        } else {
            this.setSize(1.4f, 2.4f);
        }
        super.onLivingUpdate();
        if (this.riddenByEntity != null) {
            this.getLookHelper().setLookPositionWithEntity(this.riddenByEntity, 100.0f, 100.0f);
            Vec3 riderPos = this.getRiderPosition();
            this.func_145771_j(riderPos.xCoord, riderPos.yCoord, riderPos.zCoord);
        }
    }

    public boolean interact(EntityPlayer par1EntityPlayer) {
        return super.interact(par1EntityPlayer);
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        if (this.riddenByEntity == null && par1Entity.ridingEntity == null) {
            par1Entity.mountEntity((Entity)this);
        }
        return super.attackEntityAsMob(par1Entity);
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.getSourceOfDamage() != null) {
            this.setAngry(true);
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    public boolean isAngry() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 2) != 0;
    }

    public void setAngry(boolean anger) {
        byte b0 = this.dataWatcher.getWatchableObjectByte(16);
        if (anger) {
            this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 | 2)));
        } else {
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("Angry", this.isAngry());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setAngry(par1NBTTagCompound.getBoolean("Angry"));
    }

    public void updateRiderPosition() {
        if (this.riddenByEntity != null) {
            Vec3 riderPos = this.getRiderPosition();
            this.riddenByEntity.setPosition(riderPos.xCoord, riderPos.yCoord, riderPos.zCoord);
        }
    }

    public double getMountedYOffset() {
        return 2.25;
    }

    public Vec3 getRiderPosition() {
        if (this.riddenByEntity != null) {
            float distance = 0.4f;
            double var1 = Math.cos((double)(this.rotationYaw + 90.0f) * Math.PI / 180.0) * (double)distance;
            double var3 = Math.sin((double)(this.rotationYaw + 90.0f) * Math.PI / 180.0) * (double)distance;
            return Vec3.createVectorHelper((double)(this.posX + var1), (double)(this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset()), (double)(this.posZ + var3));
        }
        return Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    public boolean getCanSpawnHere() {
        if (this.worldObj.getBiomeGenForCoords(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posZ)) == TFBiomeBase.tfSnow) {
            return this.worldObj.checkNoEntityCollision(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).size() == 0;
        }
        return super.getCanSpawnHere();
    }

    protected boolean isValidLightLevel() {
        int z;
        int x = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.getBiomeGenForCoords(x, z = MathHelper.floor_double((double)this.posZ)) == TFBiomeBase.tfSnow) {
            return true;
        }
        return super.isValidLightLevel();
    }

    protected Item getDropItem() {
        return TFItems.arcticFur;
    }
}

