/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;

public class EntityTFWraith
extends EntityFlying
implements IMob {
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    private Entity targetedEntity;
    private int aggroCooldown;
    public int prevAttackCounter;
    public int attackCounter;

    public EntityTFWraith(World world) {
        super(world);
    }

    public EntityTFWraith(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y, z);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.5);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(5.0);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    public boolean canTriggerWalking() {
        return false;
    }

    protected void updateEntityActionState() {
        if (!this.worldObj.isRemote && this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL) {
            this.setDead();
        }
        this.despawnEntity();
        this.prevAttackCounter = this.attackCounter;
        double d = this.waypointX - this.posX;
        double d1 = this.waypointY - this.posY;
        double d2 = this.waypointZ - this.posZ;
        double d3 = MathHelper.sqrt_double((double)(d * d + d1 * d1 + d2 * d2));
        if (d3 < 1.0 || d3 > 60.0) {
            this.waypointX = this.posX + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointY = this.posY + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointZ = this.posZ + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.rand.nextInt(5) + 2;
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d3)) {
                this.motionX += d / d3 * 0.1;
                this.motionY += d1 / d3 * 0.1;
                this.motionZ += d2 / d3 * 0.1;
            } else {
                this.waypointX = this.posX;
                this.waypointY = this.posY;
                this.waypointZ = this.posZ;
                this.targetedEntity = null;
            }
        }
        if (this.targetedEntity != null && this.targetedEntity.isDead) {
            this.targetedEntity = null;
        }
        if (this.targetedEntity == null || this.aggroCooldown-- <= 0) {
            this.targetedEntity = this.findPlayerToAttack();
            if (this.targetedEntity != null) {
                this.aggroCooldown = 20;
            }
        } else {
            float f1 = this.targetedEntity.getDistanceToEntity((Entity)this);
            if (this.canEntityBeSeen(this.targetedEntity)) {
                this.attackEntity(this.targetedEntity, f1);
            } else {
                this.attackBlockedEntity(this.targetedEntity, f1);
            }
        }
        double d4 = 64.0;
        if (this.targetedEntity != null && this.targetedEntity.getDistanceSqToEntity((Entity)this) < d4 * d4) {
            double d5 = this.targetedEntity.posX - this.posX;
            double d7 = this.targetedEntity.posZ - this.posZ;
            this.renderYawOffset = this.rotationYaw = -((float)Math.atan2(d5, d7)) * 180.0f / 3.141593f;
            if (this.canEntityBeSeen(this.targetedEntity)) {
                if (this.attackCounter == 10) {
                    // empty if block
                }
                ++this.attackCounter;
                if (this.attackCounter == 20) {
                    this.waypointX = this.targetedEntity.posX;
                    this.waypointY = this.targetedEntity.posY - (double)this.targetedEntity.height + 0.5;
                    this.waypointZ = this.targetedEntity.posZ;
                    this.attackCounter = -40;
                }
            } else if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        } else {
            this.renderYawOffset = this.rotationYaw = -((float)Math.atan2(this.motionX, this.motionZ)) * 180.0f / 3.141593f;
            if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        }
    }

    protected void attackEntity(Entity entity, float f) {
        if (this.attackTime <= 0 && f < 2.0f && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            float damage = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getBaseValue();
            entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), damage);
        }
    }

    protected void attackBlockedEntity(Entity entity, float f) {
    }

    public boolean attackEntityFrom(DamageSource damagesource, float i) {
        if (super.attackEntityFrom(damagesource, i)) {
            Entity entity = damagesource.getEntity();
            if (this.riddenByEntity == entity || this.ridingEntity == entity) {
                return true;
            }
            if (entity != this) {
                this.targetedEntity = entity;
            }
            return true;
        }
        return false;
    }

    protected Entity findPlayerToAttack() {
        EntityPlayer entityplayer = this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, 16.0);
        if (entityplayer != null && this.canEntityBeSeen((Entity)entityplayer)) {
            return entityplayer;
        }
        return null;
    }

    private boolean isCourseTraversable(double d, double d1, double d2, double d3) {
        double d4 = (this.waypointX - this.posX) / d3;
        double d5 = (this.waypointY - this.posY) / d3;
        double d6 = (this.waypointZ - this.posZ) / d3;
        AxisAlignedBB axisalignedbb = this.boundingBox.copy();
        int i = 1;
        while ((double)i < d3) {
            axisalignedbb.offset(d4, d5, d6);
            if (this.worldObj.getCollidingBoundingBoxes((Entity)this, axisalignedbb).size() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.wraith.wraith";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.wraith.wraith";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.wraith.wraith";
    }

    protected Item getDropItem() {
        return Items.glowstone_dust;
    }

    public void onDeath(DamageSource damageSource) {
        super.onDeath(damageSource);
        if (damageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)damageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            int chunkX = MathHelper.floor_double((double)this.posX) >> 4;
            int chunkZ = MathHelper.floor_double((double)this.posZ) >> 4;
            if (TFFeature.getNearestFeature(chunkX, chunkZ, this.worldObj) == TFFeature.hill3) {
                ((EntityPlayer)damageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHill3);
            }
        }
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.getSavedLightValue(EnumSkyBlock.Sky, i, j = MathHelper.floor_double((double)this.boundingBox.minY), k = MathHelper.floor_double((double)this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int l = this.worldObj.getBlockLightValue(i, j, k);
        if (this.worldObj.isThundering()) {
            int i1 = this.worldObj.skylightSubtracted;
            this.worldObj.skylightSubtracted = 10;
            l = this.worldObj.getBlockLightValue(i, j, k);
            this.worldObj.skylightSubtracted = i1;
        }
        return l <= this.rand.nextInt(8);
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.difficultySetting != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && super.getCanSpawnHere();
    }
}

