/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.entity.EntityTFHostileWolf;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.EntityAITFBreathAttack;
import twilightforest.item.TFItems;

public class EntityTFWinterWolf
extends EntityTFHostileWolf
implements IBreathAttacker {
    private static final int BREATH_FLAG = 21;
    public static final int BREATH_DURATION = 10;
    public static final int BREATH_DAMAGE = 2;

    public EntityTFWinterWolf(World world) {
        super(world);
        this.setSize(1.4f, 1.9f);
        this.tasks.taskEntries.clear();
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAITFBreathAttack((EntityLiving)this, 1.0f, 5.0f, 30, 0.1f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.targetTasks.taskEntries.clear();
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(21, (Object)0);
    }

    public int getAttackStrength(Entity par1Entity) {
        return 6;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        int damage = this.getAttackStrength(par1Entity);
        return par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)damage);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.isBreathing()) {
            Vec3 look = this.getLookVec();
            double dist = 0.5;
            double px = this.posX + look.xCoord * dist;
            double py = this.posY + 1.25 + look.yCoord * dist;
            double pz = this.posZ + look.zCoord * dist;
            for (int i = 0; i < 10; ++i) {
                double dx = look.xCoord;
                double dy = look.yCoord;
                double dz = look.zCoord;
                double spread = 5.0 + this.getRNG().nextDouble() * 2.5;
                double velocity = 3.0 + this.getRNG().nextDouble() * 0.15;
                dx += this.getRNG().nextGaussian() * (double)0.0075f * spread;
                dy += this.getRNG().nextGaussian() * (double)0.0075f * spread;
                dz += this.getRNG().nextGaussian() * (double)0.0075f * spread;
                TwilightForestMod.proxy.spawnParticle(this.worldObj, "snowstuff", px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
            this.playBreathSound();
        }
    }

    public void playBreathSound() {
        this.worldObj.playSoundEffect(this.posX + 0.5, this.posY + 0.5, this.posZ + 0.5, "mob.ghast.fireball", this.rand.nextFloat() * 0.5f, this.rand.nextFloat() * 0.5f);
    }

    protected float getSoundPitch() {
        return (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.6f;
    }

    @Override
    public boolean isBreathing() {
        return this.getDataWatcher().getWatchableObjectByte(21) == 1;
    }

    @Override
    public void setBreathing(boolean flag) {
        this.getDataWatcher().updateObject(21, (Object)((byte)(flag ? 1 : 0)));
    }

    @Override
    public void doBreathAttack(Entity target) {
    }

    @Override
    protected boolean isValidLightLevel() {
        int z;
        int x = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.getBiomeGenForCoords(x, z = MathHelper.floor_double((double)this.posZ)) == TFBiomeBase.tfSnow) {
            return true;
        }
        return super.isValidLightLevel();
    }

    protected Item getDropItem() {
        return TFItems.arcticFur;
    }
}

