/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import twilightforest.TFAchievementPage;
import twilightforest.block.TFBlocks;
import twilightforest.entity.ai.EntityAITFCollideAttackFixed;
import twilightforest.entity.boss.EntityTFIceBomb;
import twilightforest.item.TFItems;

public class EntityTFTroll
extends EntityMob
implements IRangedAttackMob {
    private static final int ROCK_FLAG = 16;
    private EntityAIArrowAttack aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 60, 15.0f);
    private EntityAITFCollideAttackFixed aiAttackOnCollide = new EntityAITFCollideAttackFixed((EntityCreature)this, EntityPlayer.class, 1.2, false);

    public EntityTFTroll(World world) {
        super(world);
        this.setSize(1.4f, 2.4f);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        if (world != null && !world.isRemote) {
            this.setCombatTask();
        }
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.28);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(7.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    public boolean hasRock() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 2) != 0;
    }

    public void setHasRock(boolean rock) {
        byte b0 = this.dataWatcher.getWatchableObjectByte(16);
        if (rock) {
            this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 | 2)));
        } else {
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
        this.setCombatTask();
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.swingItem();
        return super.attackEntityAsMob(par1Entity);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("HasRock", this.hasRock());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setHasRock(par1NBTTagCompound.getBoolean("HasRock"));
    }

    public void setCombatTask() {
        this.tasks.removeTask((EntityAIBase)this.aiAttackOnCollide);
        this.tasks.removeTask((EntityAIBase)this.aiArrowAttack);
        if (this.hasRock()) {
            this.tasks.addTask(4, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.tasks.addTask(4, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    protected void onDeathUpdate() {
        super.onDeathUpdate();
        if (this.deathTime % 5 == 0) {
            this.ripenTrollBerNearby(this.deathTime / 5);
        }
    }

    private void ripenTrollBerNearby(int offset) {
        int sx = MathHelper.floor_double((double)this.posX);
        int sy = MathHelper.floor_double((double)this.posY);
        int sz = MathHelper.floor_double((double)this.posZ);
        int range = 12;
        for (int dx = -range; dx < range; ++dx) {
            for (int dy = -range; dy < range; ++dy) {
                for (int dz = -range; dz < range; ++dz) {
                    int cx = sx + dx;
                    int cy = sy + dy;
                    int cz = sz + dz;
                    this.ripenBer(offset, cx, cy, cz);
                }
            }
        }
    }

    private void ripenBer(int offset, int cx, int cy, int cz) {
        if (this.worldObj.getBlock(cx, cy, cz) == TFBlocks.unripeTrollBer && this.rand.nextBoolean() && Math.abs(cx + cy + cz) % 5 == offset) {
            this.worldObj.setBlock(cx, cy, cz, TFBlocks.trollBer);
            this.worldObj.playAuxSFX(2004, cx, cy, cz, 0);
        }
    }

    public void onDeath(DamageSource damageSource) {
        super.onDeath(damageSource);
        if (damageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)damageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    private void makeTrollStoneInAABB(AxisAlignedBB par1AxisAlignedBB) {
        int minX = MathHelper.ceiling_double_int((double)par1AxisAlignedBB.minX);
        int minY = MathHelper.ceiling_double_int((double)par1AxisAlignedBB.minY);
        int minZ = MathHelper.ceiling_double_int((double)par1AxisAlignedBB.minZ);
        int maxX = MathHelper.floor_double((double)par1AxisAlignedBB.maxX);
        int maxY = MathHelper.floor_double((double)par1AxisAlignedBB.maxY);
        int maxZ = MathHelper.floor_double((double)par1AxisAlignedBB.maxZ);
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dy = minY; dy <= maxY; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    Block currentID = this.worldObj.getBlock(dx, dy, dz);
                    if (currentID != Blocks.air) continue;
                    this.worldObj.setBlock(dx, dy, dz, TFBlocks.trollSteinn);
                    this.worldObj.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)TFBlocks.trollSteinn) + 0);
                }
            }
        }
    }

    protected Item getDropItem() {
        return null;
    }

    protected void dropRareDrop(int p_70600_1_) {
        this.dropItem(TFItems.magicBeans, 1);
    }

    public void attackEntityWithRangedAttack(EntityLivingBase target, float par2) {
        if (this.hasRock()) {
            EntityTFIceBomb ice = new EntityTFIceBomb(this.worldObj, (EntityLivingBase)this);
            double d0 = target.posX - this.posX;
            double d1 = target.posY + (double)target.getEyeHeight() - (double)1.1f - target.posY;
            double d2 = target.posZ - this.posZ;
            float f1 = MathHelper.sqrt_double((double)(d0 * d0 + d2 * d2)) * 0.2f;
            ice.setThrowableHeading(d0, d1 + (double)f1, d2, 0.75f, 12.0f);
            this.playSound("random.bow", 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
            this.worldObj.spawnEntityInWorld((Entity)ice);
        }
    }

    public void swingItem() {
        if (!this.isSwingInProgress || this.swingProgressInt >= this.getArmSwingAnimationEnd() / 2 || this.swingProgressInt < 0) {
            this.swingProgressInt = -1;
            this.isSwingInProgress = true;
            if (this.worldObj instanceof WorldServer) {
                ((WorldServer)this.worldObj).getEntityTracker().func_151247_a((Entity)this, (Packet)new S0BPacketAnimation((Entity)this, 0));
            }
        }
    }

    protected void updateArmSwingProgress() {
        int maxSwing = this.getArmSwingAnimationEnd();
        if (this.isSwingInProgress) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= maxSwing) {
                this.swingProgressInt = 0;
                this.isSwingInProgress = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / (float)maxSwing;
    }

    private int getArmSwingAnimationEnd() {
        return 6;
    }
}

