/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class EntityTFTowerTermite
extends EntityMob {
    private int allySummonCooldown;

    public EntityTFTowerTermite(World par1World) {
        super(par1World);
        this.setSize(0.3f, 0.7f);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(15.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.27);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(5.0);
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected Entity findPlayerToAttack() {
        double var1 = 8.0;
        return this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, var1);
    }

    protected String getLivingSound() {
        return "mob.silverfish.say";
    }

    protected String getHurtSound() {
        return "mob.silverfish.hit";
    }

    protected String getDeathSound() {
        return "mob.silverfish.kill";
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        if (this.allySummonCooldown <= 0 && (par1DamageSource instanceof EntityDamageSource || par1DamageSource == DamageSource.magic)) {
            this.allySummonCooldown = 20;
        }
        return super.attackEntityFrom(par1DamageSource, (float)par2);
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (this.allySummonCooldown > 0) {
            --this.allySummonCooldown;
            if (this.allySummonCooldown == 0) {
                this.tryToSummonAllies();
            }
        }
        if (this.getAttackTarget() == null && this.getNavigator().noPath()) {
            this.tryToBurrow();
        }
    }

    protected void tryToSummonAllies() {
        int sx = MathHelper.floor_double((double)this.posX);
        int sy = MathHelper.floor_double((double)this.posY);
        int sz = MathHelper.floor_double((double)this.posZ);
        boolean stopSummoning = false;
        int dy = 0;
        while (!stopSummoning && dy <= 5 && dy >= -5) {
            int dx = 0;
            while (!stopSummoning && dx <= 10 && dx >= -10) {
                int dz = 0;
                while (!stopSummoning && dz <= 10 && dz >= -10) {
                    Block blockID = this.worldObj.getBlock(sx + dx, sy + dy, sz + dz);
                    int blockMeta = this.worldObj.getBlockMetadata(sx + dx, sy + dy, sz + dz);
                    if (blockID == TFBlocks.towerWood && blockMeta == 4) {
                        this.worldObj.playAuxSFX(2001, sx + dx, sy + dy, sz + dz, Block.getIdFromBlock((Block)blockID) + (blockMeta << 12));
                        this.worldObj.setBlock(sx + dx, sy + dy, sz + dz, Blocks.air, 0, 3);
                        TFBlocks.towerWood.onBlockDestroyedByPlayer(this.worldObj, sx + dx, sy + dy, sz + dz, 4);
                        if (this.rand.nextBoolean()) {
                            stopSummoning = true;
                            break;
                        }
                    }
                    dz = dz <= 0 ? 1 - dz : 0 - dz;
                }
                dx = dx <= 0 ? 1 - dx : 0 - dx;
            }
            dy = dy <= 0 ? 1 - dy : 0 - dy;
        }
    }

    protected void tryToBurrow() {
        int blockMetaNearby;
        int x = MathHelper.floor_double((double)this.posX);
        int y = MathHelper.floor_double((double)(this.posY + 0.5));
        int z = MathHelper.floor_double((double)this.posZ);
        int randomFacing = this.rand.nextInt(6);
        Block blockIDNearby = this.worldObj.getBlock(x += Facing.offsetsXForSide[randomFacing], y += Facing.offsetsYForSide[randomFacing], z += Facing.offsetsZForSide[randomFacing]);
        if (this.canBurrowIn(blockIDNearby, blockMetaNearby = this.worldObj.getBlockMetadata(x, y, z))) {
            this.worldObj.setBlock(x, y, z, TFBlocks.towerWood, 4, 3);
            this.spawnExplosionParticle();
            this.setDead();
        }
    }

    protected boolean canBurrowIn(Block blockIDNearby, int blockMetaNearby) {
        return blockIDNearby == TFBlocks.towerWood && blockMetaNearby == 0;
    }

    protected boolean isInfestedBlock(Block blockIDNearby, int blockMetaNearby) {
        return blockIDNearby == TFBlocks.towerWood && blockMetaNearby == 4;
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.playSound("mob.silverfish.step", 0.15f, 1.0f);
    }

    protected Item getDropItem() {
        return TFItems.borerEssence;
    }

    public void onUpdate() {
        this.renderYawOffset = this.rotationYaw;
        super.onUpdate();
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ARTHROPOD;
    }
}

