/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFSwarmSpider;

public class EntityTFTowerBroodling
extends EntityTFSwarmSpider {
    public EntityTFTowerBroodling(World world) {
        this(world, true);
    }

    public EntityTFTowerBroodling(World world, boolean spawnMore) {
        super(world, spawnMore);
        this.experienceValue = 3;
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(7.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    @Override
    protected boolean spawnAnother() {
        EntityTFTowerBroodling another = new EntityTFTowerBroodling(this.worldObj, false);
        double sx = this.posX + (this.rand.nextBoolean() ? 0.9 : -0.9);
        double sy = this.posY;
        double sz = this.posZ + (this.rand.nextBoolean() ? 0.9 : -0.9);
        another.setLocationAndAngles(sx, sy, sz, this.rand.nextFloat() * 360.0f, 0.0f);
        if (!another.getCanSpawnHere()) {
            another.setDead();
            return false;
        }
        this.worldObj.spawnEntityInWorld((Entity)another);
        return true;
    }
}

