/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;

public class EntityTFSwarmSpider
extends EntitySpider {
    protected boolean shouldSpawn = false;

    public EntityTFSwarmSpider(World world) {
        this(world, true);
    }

    public EntityTFSwarmSpider(World world, boolean spawnMore) {
        super(world);
        this.setSize(0.8f, 0.4f);
        this.setSpawnMore(spawnMore);
        this.experienceValue = 2;
    }

    public EntityTFSwarmSpider(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y, z);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(3.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(1.0);
    }

    public float spiderScaleAmount() {
        return 0.5f;
    }

    public float getRenderSizeModifier() {
        return 0.5f;
    }

    public void onUpdate() {
        if (this.shouldSpawnMore()) {
            if (!this.worldObj.isRemote) {
                int more = 1 + this.rand.nextInt(2);
                for (int i = 0; i < more; ++i) {
                    if (this.spawnAnother()) continue;
                    this.spawnAnother();
                }
            }
            this.setSpawnMore(false);
        }
        super.onUpdate();
    }

    protected void attackEntity(Entity entity, float f) {
        if (!(this.attackTime > 0 || this.isAirBorne && this.rand.nextInt(4) == 0)) {
            this.attackTime = 20;
        } else {
            super.attackEntity(entity, f);
        }
    }

    protected Entity findPlayerToAttack() {
        double var2 = 16.0;
        return this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, var2);
    }

    protected boolean spawnAnother() {
        EntityTFSwarmSpider another = new EntityTFSwarmSpider(this.worldObj, false);
        double sx = this.posX + (this.rand.nextBoolean() ? 0.9 : -0.9);
        double sy = this.posY;
        double sz = this.posZ + (this.rand.nextBoolean() ? 0.9 : -0.9);
        another.setLocationAndAngles(sx, sy, sz, this.rand.nextFloat() * 360.0f, 0.0f);
        if (!another.getCanSpawnHere()) {
            another.setDead();
            return false;
        }
        this.worldObj.spawnEntityInWorld((Entity)another);
        return true;
    }

    protected boolean isValidLightLevel() {
        int chunkZ;
        int chunkX = MathHelper.floor_double((double)this.posX) >> 4;
        if (TFFeature.getNearestFeature(chunkX, chunkZ = MathHelper.floor_double((double)this.posZ) >> 4, this.worldObj) == TFFeature.hedgeMaze) {
            return true;
        }
        return super.isValidLightLevel();
    }

    public boolean shouldSpawnMore() {
        return this.shouldSpawn;
    }

    public void setSpawnMore(boolean flag) {
        this.shouldSpawn = flag;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBoolean("SpawnMore", this.shouldSpawnMore());
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSpawnMore(nbttagcompound.getBoolean("SpawnMore"));
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            int chunkX = MathHelper.floor_double((double)this.posX) >> 4;
            int chunkZ = MathHelper.floor_double((double)this.posZ) >> 4;
            if (TFFeature.getNearestFeature(chunkX, chunkZ, this.worldObj) == TFFeature.hedgeMaze) {
                ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHedge);
            }
        }
    }

    protected float getSoundPitch() {
        return (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.5f;
    }

    public int getMaxSpawnedInChunk() {
        return 16;
    }
}

