/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityTFSlideBlock
extends Entity
implements IEntityAdditionalSpawnData {
    private static final int WARMUP_TIME = 20;
    private Block myBlock;
    private int myMeta;
    private short slideTime;
    private boolean canDropItem = true;
    float moveX;
    float moveY;
    float moveZ;

    public EntityTFSlideBlock(World world) {
        super(world);
        this.preventEntitySpawning = true;
        this.entityCollisionReduction = 1.0f;
        this.setSize(0.98f, 0.98f);
    }

    public EntityTFSlideBlock(World world, double x, double y, double z, Block block, int meta) {
        super(world);
        this.myBlock = block;
        this.myMeta = meta;
        this.preventEntitySpawning = true;
        this.entityCollisionReduction = 1.0f;
        this.setSize(0.98f, 0.98f);
        this.setPosition(x, y, z);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
        this.determineMoveDirection();
    }

    private void determineMoveDirection() {
        this.moveX = 0.0f;
        this.moveY = 0.0f;
        this.moveZ = 0.0f;
        int bx = MathHelper.floor_double((double)this.posX);
        int by = MathHelper.floor_double((double)this.posY);
        int bz = MathHelper.floor_double((double)this.posZ);
        if ((this.myMeta & 0xC) == 4) {
            if (!this.worldObj.isAirBlock(bx, by + 1, bz) && this.worldObj.isAirBlock(bx, by - 1, bz)) {
                this.moveY = -1.0f;
            } else if (!this.worldObj.isAirBlock(bx, by - 1, bz) && this.worldObj.isAirBlock(bx, by + 1, bz)) {
                this.moveY = 1.0f;
            } else if (!this.worldObj.isAirBlock(bx, by, bz + 1) && this.worldObj.isAirBlock(bx, by, bz - 1)) {
                this.moveZ = -1.0f;
            } else if (!this.worldObj.isAirBlock(bx, by, bz - 1) && this.worldObj.isAirBlock(bx, by, bz + 1)) {
                this.moveZ = 1.0f;
            } else if (this.worldObj.isAirBlock(bx, by - 1, bz)) {
                this.moveY = -1.0f;
            } else if (this.worldObj.isAirBlock(bx, by + 1, bz)) {
                this.moveY = 1.0f;
            } else if (this.worldObj.isAirBlock(bx, by, bz - 1)) {
                this.moveZ = -1.0f;
            } else if (this.worldObj.isAirBlock(bx, by, bz + 1)) {
                this.moveZ = 1.0f;
            }
        } else if ((this.myMeta & 0xC) == 8) {
            if (!this.worldObj.isAirBlock(bx, by + 1, bz) && this.worldObj.isAirBlock(bx, by - 1, bz)) {
                this.moveY = -1.0f;
            } else if (!this.worldObj.isAirBlock(bx, by - 1, bz) && this.worldObj.isAirBlock(bx, by + 1, bz)) {
                this.moveY = 1.0f;
            } else if (!this.worldObj.isAirBlock(bx + 1, by, bz) && this.worldObj.isAirBlock(bx - 1, by, bz)) {
                this.moveX = -1.0f;
            } else if (!this.worldObj.isAirBlock(bx - 1, by, bz) && this.worldObj.isAirBlock(bx + 1, by, bz)) {
                this.moveX = 1.0f;
            } else if (this.worldObj.isAirBlock(bx, by - 1, bz)) {
                this.moveY = -1.0f;
            } else if (this.worldObj.isAirBlock(bx, by + 1, bz)) {
                this.moveY = 1.0f;
            } else if (this.worldObj.isAirBlock(bx - 1, by, bz)) {
                this.moveX = -1.0f;
            } else if (this.worldObj.isAirBlock(bx + 1, by, bz)) {
                this.moveX = 1.0f;
            }
        } else if ((this.myMeta & 0xC) == 0) {
            if (!this.worldObj.isAirBlock(bx + 1, by, bz) && this.worldObj.isAirBlock(bx - 1, by, bz)) {
                this.moveX = -1.0f;
            } else if (!this.worldObj.isAirBlock(bx - 1, by, bz) && this.worldObj.isAirBlock(bx + 1, by, bz)) {
                this.moveX = 1.0f;
            } else if (!this.worldObj.isAirBlock(bx, by, bz + 1) && this.worldObj.isAirBlock(bx, by, bz - 1)) {
                this.moveZ = -1.0f;
            } else if (!this.worldObj.isAirBlock(bx, by, bz - 1) && this.worldObj.isAirBlock(bx, by, bz + 1)) {
                this.moveZ = 1.0f;
            } else if (this.worldObj.isAirBlock(bx - 1, by, bz)) {
                this.moveX = -1.0f;
            } else if (this.worldObj.isAirBlock(bx + 1, by, bz)) {
                this.moveX = 1.0f;
            } else if (this.worldObj.isAirBlock(bx, by, bz - 1)) {
                this.moveZ = -1.0f;
            } else if (this.worldObj.isAirBlock(bx, by, bz + 1)) {
                this.moveZ = 1.0f;
            }
        }
    }

    protected void entityInit() {
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public void onUpdate() {
        if (this.myBlock == null || this.myBlock.getMaterial() == Material.air) {
            this.setDead();
        } else {
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            this.slideTime = (short)(this.slideTime + 1);
            if (this.slideTime > 20) {
                this.motionX += (double)this.moveX * (double)0.04f;
                this.motionY += (double)this.moveY * (double)0.04f;
                this.motionZ += (double)this.moveZ * (double)0.04f;
                this.moveEntity(this.motionX, this.motionY, this.motionZ);
            }
            this.motionX *= (double)0.98f;
            this.motionY *= (double)0.98f;
            this.motionZ *= (double)0.98f;
            if (this.slideTime % 5 == 0) {
                this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "TwilightForest:random.slider", 1.0f, 0.9f + this.rand.nextFloat() * 0.4f);
            }
            if (!this.worldObj.isRemote) {
                int bx = MathHelper.floor_double((double)this.posX);
                int by = MathHelper.floor_double((double)this.posY);
                int bz = MathHelper.floor_double((double)this.posZ);
                if (this.slideTime == 1) {
                    if (this.worldObj.getBlock(bx, by, bz) != this.myBlock) {
                        this.setDead();
                        return;
                    }
                    this.worldObj.setBlockToAir(bx, by, bz);
                }
                if (this.slideTime == 60) {
                    this.motionX = 0.0;
                    this.motionY = 0.0;
                    this.motionZ = 0.0;
                    this.moveX *= -1.0f;
                    this.moveY *= -1.0f;
                    this.moveZ *= -1.0f;
                }
                if (this.isCollided || this.isStopped()) {
                    this.motionX *= (double)0.7f;
                    this.motionZ *= (double)0.7f;
                    this.motionY *= (double)0.7f;
                    this.setDead();
                    if (!(this.worldObj.canPlaceEntityOnSide(this.myBlock, bx, by, bz, true, 1, (Entity)null, (ItemStack)null) && this.worldObj.setBlock(bx, by, bz, this.myBlock, this.myMeta, 3) || !this.canDropItem)) {
                        this.entityDropItem(new ItemStack(this.myBlock, 1, this.myBlock.damageDropped(this.myMeta)), 0.0f);
                    }
                } else if (this.slideTime > 100 && !this.worldObj.isRemote && (by < 1 || by > 256) || this.slideTime > 600) {
                    if (this.canDropItem) {
                        this.entityDropItem(new ItemStack(this.myBlock, 1, this.myBlock.damageDropped(this.myMeta)), 0.0f);
                    }
                    this.setDead();
                }
                this.damageKnockbackEntities(this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox), this);
            }
        }
    }

    private void damageKnockbackEntities(List<Entity> par1List, Entity me) {
        for (Entity entity : par1List) {
            if (!(entity instanceof EntityLivingBase)) continue;
            entity.attackEntityFrom(DamageSource.generic, 5.0f);
            double kx = (this.posX - entity.posX) * 2.0;
            double kz = (this.posZ - entity.posZ) * 2.0;
            ((EntityLivingBase)entity).knockBack((Entity)this, 5.0f, kx, kz);
        }
    }

    public AxisAlignedBB getCollisionBox(Entity p_70114_1_) {
        return null;
    }

    private boolean isStopped() {
        return this.moveX == 0.0f && this.moveY == 0.0f && this.moveZ == 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderOnFire() {
        return false;
    }

    protected void readEntityFromNBT(NBTTagCompound nbtTagCompound) {
        this.myBlock = Block.getBlockById((int)nbtTagCompound.getInteger("TileID"));
        this.myMeta = nbtTagCompound.getByte("Meta");
        this.slideTime = nbtTagCompound.getShort("Time");
        this.moveX = nbtTagCompound.getFloat("MoveX");
        this.moveY = nbtTagCompound.getFloat("MoveY");
        this.moveZ = nbtTagCompound.getFloat("MoveZ");
    }

    protected void writeEntityToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.setInteger("TileID", Block.getIdFromBlock((Block)this.myBlock));
        nbtTagCompound.setByte("Meta", (byte)this.myMeta);
        nbtTagCompound.setShort("Time", this.slideTime);
        nbtTagCompound.setFloat("MoveX", this.moveX);
        nbtTagCompound.setFloat("MoveY", this.moveY);
        nbtTagCompound.setFloat("MoveZ", this.moveZ);
    }

    public Block getBlock() {
        return this.myBlock;
    }

    public int getMeta() {
        return this.myMeta;
    }

    public void writeSpawnData(ByteBuf buffer) {
        int blockData = Block.getIdFromBlock((Block)this.myBlock) + (this.myMeta << 16);
        buffer.writeInt(blockData);
    }

    public void readSpawnData(ByteBuf additionalData) {
        int blockData = additionalData.readInt();
        this.myBlock = Block.getBlockById((int)(blockData & 0xFFFF));
        this.myMeta = blockData >> 16;
    }

    public boolean canBePushed() {
        return false;
    }

    public boolean isPushedByWater() {
        return false;
    }
}

