/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.entity.ai.EntityAITFChargeAttack;
import twilightforest.entity.ai.EntityAITFKidnapRider;

public class EntityTFPinchBeetle
extends EntityMob {
    public EntityTFPinchBeetle(World world) {
        super(world);
        this.setSize(1.2f, 1.1f);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAITFKidnapRider((EntityCreature)this, 2.0f));
        this.tasks.addTask(2, (EntityAIBase)new EntityAITFChargeAttack((EntityCreature)this, 2.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.23);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    public int getTotalArmorValue() {
        int var1 = super.getTotalArmorValue() + 2;
        if (var1 > 20) {
            var1 = 20;
        }
        return var1;
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "mob.spider.say";
    }

    protected String getDeathSound() {
        return "mob.spider.death";
    }

    protected void func_145780_a(int var1, int var2, int var3, Block var4) {
        this.worldObj.playSoundAtEntity((Entity)this, "mob.spider.step", 0.15f, 1.0f);
    }

    public void onLivingUpdate() {
        if (this.riddenByEntity != null) {
            this.setSize(1.9f, 2.0f);
            if (this.riddenByEntity.isSneaking()) {
                this.riddenByEntity.setSneaking(false);
            }
        } else {
            this.setSize(1.2f, 1.1f);
        }
        super.onLivingUpdate();
        if (this.riddenByEntity != null) {
            this.getLookHelper().setLookPositionWithEntity(this.riddenByEntity, 100.0f, 100.0f);
            Vec3 riderPos = this.getRiderPosition();
            this.func_145771_j(riderPos.xCoord, riderPos.yCoord, riderPos.zCoord);
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    public int getAttackStrength(Entity par1Entity) {
        return 8;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 1.1f;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        if (this.riddenByEntity == null && par1Entity.ridingEntity == null) {
            par1Entity.mountEntity((Entity)this);
        }
        return super.attackEntityAsMob(par1Entity);
    }

    public boolean interact(EntityPlayer par1EntityPlayer) {
        return super.interact(par1EntityPlayer);
    }

    public float getEyeHeight() {
        return 0.25f;
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void updateRiderPosition() {
        if (this.riddenByEntity != null) {
            Vec3 riderPos = this.getRiderPosition();
            this.riddenByEntity.setPosition(riderPos.xCoord, riderPos.yCoord, riderPos.zCoord);
        }
    }

    public double getMountedYOffset() {
        return 0.75;
    }

    public Vec3 getRiderPosition() {
        if (this.riddenByEntity != null) {
            float distance = 0.9f;
            double var1 = Math.cos((double)(this.rotationYaw + 90.0f) * Math.PI / 180.0) * (double)distance;
            double var3 = Math.sin((double)(this.rotationYaw + 90.0f) * Math.PI / 180.0) * (double)distance;
            return Vec3.createVectorHelper((double)(this.posX + var1), (double)(this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset()), (double)(this.posZ + var3));
        }
        return Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
    }

    public boolean canRiderInteract() {
        return true;
    }
}

