/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityTFNatureBolt
extends EntityThrowable {
    private EntityPlayer playerTarget;

    public EntityTFNatureBolt(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    public EntityTFNatureBolt(World par1World, EntityLivingBase par2EntityLiving) {
        super(par1World, par2EntityLiving);
    }

    public EntityTFNatureBolt(World par1World) {
        super(par1World);
    }

    public void onUpdate() {
        super.onUpdate();
        this.makeTrail();
    }

    protected float getGravityVelocity() {
        return 0.003f;
    }

    public void makeTrail() {
        for (int i = 0; i < 5; ++i) {
            double dx = this.posX + 0.5 * (this.rand.nextDouble() - this.rand.nextDouble());
            double dy = this.posY + 0.5 * (this.rand.nextDouble() - this.rand.nextDouble());
            double dz = this.posZ + 0.5 * (this.rand.nextDouble() - this.rand.nextDouble());
            this.worldObj.spawnParticle("happyVillager", dx, dy, dz, 0.0, 0.0, 0.0);
        }
    }

    protected void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        byte poisonStrength;
        if (par1MovingObjectPosition.entityHit != null && par1MovingObjectPosition.entityHit instanceof EntityLivingBase && par1MovingObjectPosition.entityHit.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)this, (Entity)this.getThrower()), 2.0f) && (poisonStrength = (byte)(this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL ? 0 : (this.worldObj.difficultySetting == EnumDifficulty.NORMAL ? 3 : 7))) > 0) {
            ((EntityLivingBase)par1MovingObjectPosition.entityHit).addPotionEffect(new PotionEffect(Potion.poison.id, poisonStrength * 20, 0));
        }
        for (int i = 0; i < 8; ++i) {
            this.worldObj.spawnParticle("blockcrack_" + Block.getIdFromBlock((Block)Blocks.leaves) + "_0", this.posX, this.posY, this.posZ, this.rand.nextGaussian() * 0.05, this.rand.nextDouble() * 0.2, this.rand.nextGaussian() * 0.05);
        }
        if (!this.worldObj.isRemote) {
            this.setDead();
            if (par1MovingObjectPosition != null) {
                int dz;
                int dy;
                int dx = MathHelper.floor_double((double)par1MovingObjectPosition.blockX);
                Material materialHit = this.worldObj.getBlock(dx, dy = MathHelper.floor_double((double)par1MovingObjectPosition.blockY), dz = MathHelper.floor_double((double)par1MovingObjectPosition.blockZ)).getMaterial();
                if (materialHit == Material.grass && this.playerTarget != null) {
                    Items.dye.onItemUse(new ItemStack(Items.dye, 1, 15), this.playerTarget, this.worldObj, dx, dy, dz, 0, 0.0f, 0.0f, 0.0f);
                } else if (materialHit.isSolid() && this.canReplaceBlock(this.worldObj, dx, dy, dz)) {
                    this.worldObj.setBlock(dx, dy, dz, (Block)Blocks.leaves, 2, 3);
                }
            }
        }
    }

    private boolean canReplaceBlock(World worldObj, int dx, int dy, int dz) {
        Block blockID = worldObj.getBlock(dx, dy, dz);
        Block blockObj = blockID;
        float hardness = blockObj == null ? -1.0f : blockObj.getBlockHardness(worldObj, dx, dy, dz);
        return hardness >= 0.0f && hardness < 50.0f;
    }

    public void setTarget(EntityLivingBase attackTarget) {
        if (attackTarget instanceof EntityPlayer) {
            this.playerTarget = (EntityPlayer)attackTarget;
        }
    }
}

