/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class EntityTFMazeSlime
extends EntitySlime {
    private String slimeParticleString;

    public EntityTFMazeSlime(World par1World) {
        super(par1World);
        this.setSlimeSize(1 << 1 + this.rand.nextInt(2));
    }

    protected EntitySlime createInstance() {
        return new EntityTFMazeSlime(this.worldObj);
    }

    public void setSlimeSize(int par1) {
        super.setSlimeSize(par1);
        this.experienceValue = par1 + 3;
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.difficultySetting != EnumDifficulty.PEACEFUL && this.worldObj.checkNoEntityCollision(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox) && this.isValidLightLevel();
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        int size = this.getSlimeSize();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(2.0 * (double)size * (double)size);
    }

    protected boolean canDamagePlayer() {
        return true;
    }

    protected int getAttackStrength() {
        return super.getAttackStrength() + 3;
    }

    protected String getSlimeParticle() {
        if (this.slimeParticleString == null) {
            this.slimeParticleString = "blockcrack_" + Block.getIdFromBlock((Block)TFBlocks.mazestone) + "_1";
        }
        return this.slimeParticleString;
    }

    protected boolean isValidLightLevel() {
        int var3;
        int var2;
        int var1 = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.getSavedLightValue(EnumSkyBlock.Sky, var1, var2 = MathHelper.floor_double((double)this.boundingBox.minY), var3 = MathHelper.floor_double((double)this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int var4 = this.worldObj.getBlockLightValue(var1, var2, var3);
        if (this.worldObj.isThundering()) {
            int var5 = this.worldObj.skylightSubtracted;
            this.worldObj.skylightSubtracted = 10;
            var4 = this.worldObj.getBlockLightValue(var1, var2, var3);
            this.worldObj.skylightSubtracted = var5;
        }
        return var4 <= this.rand.nextInt(8);
    }

    protected float getSoundVolume() {
        return 0.1f * (float)this.getSlimeSize();
    }

    protected void dropRareDrop(int par1) {
        this.dropItem(TFItems.charmOfKeeping1, 1);
    }
}

