/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.entity.ai.EntityAITFFlockToSameKind;
import twilightforest.entity.ai.EntityAITFPanicOnFlockDeath;

public class EntityTFKobold
extends EntityMob {
    private boolean shy;

    public EntityTFKobold(World world) {
        super(world);
        this.setSize(0.8f, 1.1f);
        this.shy = true;
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAITFPanicOnFlockDeath((EntityCreature)this, 2.0f));
        this.tasks.addTask(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(4, (EntityAIBase)new EntityAITFFlockToSameKind((EntityLiving)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    public EntityTFKobold(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y, z);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(13.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.28);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.kobold.kobold";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.kobold.hurt";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.kobold.die";
    }

    protected Item getDropItem() {
        return Items.wheat;
    }

    protected void dropFewItems(boolean flag, int i) {
        super.dropFewItems(flag, i);
        if (this.rand.nextInt(2) == 0) {
            this.dropItem(Items.gold_nugget, 1 + i);
        }
    }

    public boolean isShy() {
        return this.shy && this.recentlyHit <= 0;
    }

    public boolean isPanicked() {
        return this.dataWatcher.getWatchableObjectByte(17) != 0;
    }

    public void setPanicked(boolean flag) {
        if (flag) {
            this.dataWatcher.updateObject(17, (Object)127);
        } else {
            this.dataWatcher.updateObject(17, (Object)0);
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.isPanicked()) {
            for (int i = 0; i < 2; ++i) {
                this.worldObj.spawnParticle("splash", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width * 0.5, this.posY + (double)this.getEyeHeight(), this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width * 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    public int getMaxSpawnedInChunk() {
        return 8;
    }
}

