/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFSkeletonDruid;

public class EntityTFKingSpider
extends EntitySpider {
    public EntityTFKingSpider(World world) {
        super(world);
        this.setSize(1.6f, 1.6f);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)0.2f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.35);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(6.0);
    }

    protected Entity findPlayerToAttack() {
        double var2 = 16.0;
        return this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, var2);
    }

    public float spiderScaleAmount() {
        return 1.9f;
    }

    public float getRenderSizeModifier() {
        return 2.0f;
    }

    public boolean isOnLadder() {
        return false;
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        IEntityLivingData par1EntityLivingData1 = super.onSpawnWithEgg(par1EntityLivingData);
        EntityTFSkeletonDruid druid = new EntityTFSkeletonDruid(this.worldObj);
        druid.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, 0.0f);
        druid.onSpawnWithEgg(null);
        this.worldObj.spawnEntityInWorld((Entity)druid);
        druid.mountEntity((Entity)this);
        return par1EntityLivingData1;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.5;
    }
}

