/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TwilightForestMod;
import twilightforest.entity.EntityTFIceSnowball;

public class EntityTFIceShooter
extends EntityMob
implements IRangedAttackMob {
    public EntityTFIceShooter(World world) {
        super(world);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.25, 20, 10.0f));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.setSize(0.8f, 1.8f);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.23f);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(3.0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public float getEyeHeight() {
        return this.height * 0.6f;
    }

    protected Item getDropItem() {
        return Items.snowball;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        for (int i = 0; i < 3; ++i) {
            float px = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.3f;
            float py = this.getEyeHeight() + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.5f;
            float pz = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.3f;
            TwilightForestMod.proxy.spawnParticle(this.worldObj, "snowguardian", this.lastTickPosX + (double)px, this.lastTickPosY + (double)py, this.lastTickPosZ + (double)pz, 0.0, 0.0, 0.0);
        }
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.ice.noise";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.ice.hurt";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.ice.death";
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    public int getMaxSpawnedInChunk() {
        return 8;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase par1EntityLivingBase, float par2) {
        EntityTFIceSnowball entitysnowball = new EntityTFIceSnowball(this.worldObj, (EntityLivingBase)this);
        double d0 = par1EntityLivingBase.posX - this.posX;
        double d1 = par1EntityLivingBase.posY + (double)par1EntityLivingBase.getEyeHeight() - (double)1.1f - entitysnowball.posY;
        double d2 = par1EntityLivingBase.posZ - this.posZ;
        float f1 = MathHelper.sqrt_double((double)(d0 * d0 + d2 * d2)) * 0.2f;
        entitysnowball.setThrowableHeading(d0, d1 + (double)f1, d2, 0.6f, 12.0f);
        this.playSound("random.bow", 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
        this.worldObj.spawnEntityInWorld((Entity)entitysnowball);
    }
}

