/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;

public class EntityTFIceExploder
extends EntityMob {
    private static final float EXPLOSION_RADIUS = 1.0f;

    public EntityTFIceExploder(World world) {
        super(world);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.setSize(0.8f, 1.8f);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.23f);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(3.0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected Item getDropItem() {
        return Items.snowball;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        for (int i = 0; i < 3; ++i) {
            float px = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.3f;
            float py = this.getEyeHeight() + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.5f;
            float pz = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.3f;
            TwilightForestMod.proxy.spawnParticle(this.worldObj, "snowguardian", this.lastTickPosX + (double)px, this.lastTickPosY + (double)py, this.lastTickPosZ + (double)pz, 0.0, 0.0, 0.0);
        }
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.ice.noise";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.ice.hurt";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.ice.death";
    }

    public float getEyeHeight() {
        return this.height * 0.6f;
    }

    public void onDeath(DamageSource damageSource) {
        super.onDeath(damageSource);
        if (damageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)damageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    protected void onDeathUpdate() {
        ++this.deathTime;
        if (this.deathTime == 60) {
            int i;
            boolean flag = this.worldObj.getGameRules().getGameRuleBooleanValue("mobGriefing");
            this.worldObj.createExplosion((Entity)this, this.posX, this.posY, this.posZ, 1.0f, flag);
            if (flag) {
                this.detonate();
            }
            if (!this.worldObj.isRemote && (this.recentlyHit > 0 || this.isPlayer()) && this.func_146066_aG() && this.worldObj.getGameRules().getGameRuleBooleanValue("doMobLoot")) {
                int j;
                for (i = this.getExperiencePoints(this.attackingPlayer); i > 0; i -= j) {
                    j = EntityXPOrb.getXPSplit((int)i);
                    this.worldObj.spawnEntityInWorld((Entity)new EntityXPOrb(this.worldObj, this.posX, this.posY, this.posZ, j));
                }
            }
            this.setDead();
            for (i = 0; i < 20; ++i) {
                double d2 = this.rand.nextGaussian() * 0.02;
                double d0 = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d2, d0, d1);
            }
        }
    }

    private void detonate() {
        int range = 4;
        int sx = MathHelper.floor_double((double)this.posX);
        int sy = MathHelper.floor_double((double)this.posY);
        int sz = MathHelper.floor_double((double)this.posZ);
        for (int dx = -range; dx <= range; ++dx) {
            for (int dy = -range; dy <= range; ++dy) {
                for (int dz = -range; dz <= range; ++dz) {
                    float randRange;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (!(distance < (double)(randRange = (float)range + (this.rand.nextFloat() - this.rand.nextFloat()) * 2.0f))) continue;
                    this.transformBlock(sx + dx, sy + dy, sz + dz);
                }
            }
        }
    }

    private void transformBlock(int x, int y, int z) {
        Block block = this.worldObj.getBlock(x, y, z);
        int meta = this.worldObj.getBlockMetadata(x, y, z);
        if (block.getExplosionResistance((Entity)this) < 8.0f && block.getBlockHardness(this.worldObj, x, y, z) >= 0.0f) {
            int blockColor = 0xFFFFFF;
            try {
                blockColor = block.colorMultiplier((IBlockAccess)this.worldObj, x, y, z);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            if (blockColor == 0xFFFFFF) {
                blockColor = block.getMapColor((int)meta).colorValue;
            }
            if (this.shouldTransformGlass(block, x, y, z)) {
                this.worldObj.setBlock(x, y, z, (Block)Blocks.stained_glass, this.getMetaForColor(blockColor), 3);
            } else if (this.shouldTransformClay(block, x, y, z)) {
                this.worldObj.setBlock(x, y, z, Blocks.stained_hardened_clay, this.getMetaForColor(blockColor), 3);
            }
        }
    }

    private boolean shouldTransformClay(Block block, int x, int y, int z) {
        return block.isNormalCube((IBlockAccess)this.worldObj, x, y, z);
    }

    private boolean shouldTransformGlass(Block block, int x, int y, int z) {
        return block != Blocks.air && this.isBlockNormalBounds(block, x, y, z) && (!block.getMaterial().isOpaque() || block.isLeaves((IBlockAccess)this.worldObj, x, y, z) || block == Blocks.ice || block == TFBlocks.auroraBlock);
    }

    private boolean isBlockNormalBounds(Block block, int x, int y, int z) {
        return block.getBlockBoundsMaxX() == 1.0 && block.getBlockBoundsMaxY() == 1.0 && block.getBlockBoundsMaxZ() == 1.0 && block.getBlockBoundsMinX() == 0.0 && block.getBlockBoundsMinY() == 0.0 && block.getBlockBoundsMinZ() == 0.0;
    }

    private int getMetaForColor(int blockColor) {
        int red = blockColor >> 16 & 0xFF;
        int green = blockColor >> 8 & 0xFF;
        int blue = blockColor & 0xFF;
        int bestColor = 0;
        int bestDifference = 1024;
        for (int i = 0; i < 15; ++i) {
            int iColor = Blocks.wool.getMapColor((int)i).colorValue;
            int iRed = iColor >> 16 & 0xFF;
            int iGreen = iColor >> 8 & 0xFF;
            int iBlue = iColor & 0xFF;
            int difference = Math.abs(red - iRed) + Math.abs(green - iGreen) + Math.abs(blue - iBlue);
            if (difference >= bestDifference) continue;
            bestColor = i;
            bestDifference = difference;
        }
        return bestColor;
    }

    public int getMaxSpawnedInChunk() {
        return 8;
    }
}

