/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.entity.ai.EntityAITFHeavySpearAttack;
import twilightforest.item.TFItems;

public class EntityTFGoblinKnightUpper
extends EntityMob {
    private static final int SHIELD_DAMAGE_THRESHOLD = 10;
    private static final int DATA_EQUIP = 17;
    public int shieldHits;
    public int heavySpearTimer;

    public EntityTFGoblinKnightUpper(World par1World) {
        super(par1World);
        this.setSize(1.1f, 1.3f);
        this.tasks.addTask(0, (EntityAIBase)new EntityAITFHeavySpearAttack(this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false));
        this.setHasArmor(true);
        this.setHasShield(true);
        this.shieldHits = 0;
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.28);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)0);
    }

    public boolean hasArmor() {
        return (this.dataWatcher.getWatchableObjectByte(17) & 1) > 0;
    }

    public void setHasArmor(boolean flag) {
        byte otherFlags = this.dataWatcher.getWatchableObjectByte(17);
        otherFlags = (byte)(otherFlags & 0x7E);
        if (flag) {
            this.dataWatcher.updateObject(17, (Object)((byte)(otherFlags | 1)));
        } else {
            this.dataWatcher.updateObject(17, (Object)otherFlags);
        }
    }

    public boolean hasShield() {
        return (this.dataWatcher.getWatchableObjectByte(17) & 2) > 0;
    }

    public void setHasShield(boolean flag) {
        byte otherFlags = this.dataWatcher.getWatchableObjectByte(17);
        otherFlags = (byte)(otherFlags & 0x7D);
        if (flag) {
            this.dataWatcher.updateObject(17, (Object)((byte)(otherFlags | 2)));
        } else {
            this.dataWatcher.updateObject(17, (Object)otherFlags);
        }
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("hasArmor", this.hasArmor());
        par1NBTTagCompound.setBoolean("hasShield", this.hasShield());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setHasArmor(par1NBTTagCompound.getBoolean("hasArmor"));
        this.setHasShield(par1NBTTagCompound.getBoolean("hasShield"));
    }

    public void onUpdate() {
        if (this.isEntityAlive()) {
            if (this.ridingEntity != null && this.ridingEntity instanceof EntityLiving && this.getAttackTarget() == null) {
                this.setAttackTarget(((EntityLiving)this.ridingEntity).getAttackTarget());
            }
            if (this.heavySpearTimer > 0) {
                --this.heavySpearTimer;
                if (this.heavySpearTimer == 25) {
                    this.landHeavySpearAttack();
                }
            }
            if (this.ridingEntity == null && this.hasShield()) {
                this.breakShield();
            }
        }
        super.onUpdate();
    }

    private void landHeavySpearAttack() {
        Vec3 vector = this.getLookVec();
        double dist = 1.25;
        double px = this.posX + vector.xCoord * dist;
        double py = this.boundingBox.minY - 0.75;
        double pz = this.posZ + vector.zCoord * dist;
        for (int i = 0; i < 50; ++i) {
            this.worldObj.spawnParticle("largesmoke", px, py, pz, (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.25f), 0.0, (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.25f));
        }
        double radius = 1.5;
        AxisAlignedBB spearBB = AxisAlignedBB.getBoundingBox((double)(px - radius), (double)(py - radius), (double)(pz - radius), (double)(px + radius), (double)(py + radius), (double)(pz + radius));
        List inBox = this.worldObj.getEntitiesWithinAABB(Entity.class, spearBB);
        for (Entity entity : inBox) {
            if (this.ridingEntity == null || entity == this.ridingEntity || entity == this) continue;
            super.attackEntityAsMob(entity);
        }
    }

    public int getAttackStrength(Entity par1Entity) {
        if (this.heavySpearTimer > 0) {
            return 20;
        }
        return 8;
    }

    public void updateRidden() {
        super.updateRidden();
        if (this.ridingEntity != null) {
            this.renderYawOffset = ((EntityLiving)this.ridingEntity).renderYawOffset;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.heavySpearTimer = 60;
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        if (this.heavySpearTimer > 0) {
            return false;
        }
        if (this.rand.nextInt(2) == 0) {
            this.startHeavySpearAttack();
            return false;
        }
        this.swingItem();
        return super.attackEntityAsMob(par1Entity);
    }

    private void startHeavySpearAttack() {
        this.heavySpearTimer = 60;
        this.worldObj.setEntityState((Entity)this, (byte)4);
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float damageAmount) {
        boolean attackSuccess;
        if (par1DamageSource == DamageSource.inWall && this.ridingEntity != null) {
            return false;
        }
        Entity attacker = null;
        if (par1DamageSource.getSourceOfDamage() != null) {
            attacker = par1DamageSource.getSourceOfDamage();
        }
        if (par1DamageSource.getEntity() != null) {
            attacker = par1DamageSource.getEntity();
        }
        if (attacker != null) {
            double dx = this.posX - attacker.posX;
            double dz = this.posZ - attacker.posZ;
            float angle = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float difference = MathHelper.abs((float)((this.renderYawOffset - angle) % 360.0f));
            if (this.hasShield() && difference > 150.0f && difference < 230.0f) {
                if (this.takeHitOnShield(par1DamageSource, damageAmount)) {
                    return false;
                }
            } else if (this.hasShield() && this.rand.nextBoolean()) {
                this.damageShield();
            }
            if (this.hasArmor() && (difference > 300.0f || difference < 60.0f)) {
                this.breakArmor();
            }
        }
        if ((attackSuccess = super.attackEntityFrom(par1DamageSource, damageAmount)) && this.ridingEntity != null && this.ridingEntity instanceof EntityLiving && attacker != null) {
            ((EntityLiving)this.ridingEntity).knockBack(attacker, damageAmount, 0.1, 0.1);
        }
        return attackSuccess;
    }

    public void breakArmor() {
        this.renderBrokenItemStack(new ItemStack((Item)Items.iron_chestplate));
        this.renderBrokenItemStack(new ItemStack((Item)Items.iron_chestplate));
        this.renderBrokenItemStack(new ItemStack((Item)Items.iron_chestplate));
        this.setHasArmor(false);
    }

    public void breakShield() {
        this.renderBrokenItemStack(new ItemStack((Item)Items.iron_chestplate));
        this.renderBrokenItemStack(new ItemStack((Item)Items.iron_chestplate));
        this.renderBrokenItemStack(new ItemStack((Item)Items.iron_chestplate));
        this.setHasShield(false);
    }

    public boolean takeHitOnShield(DamageSource par1DamageSource, float damageAmount) {
        EntityTFGoblinKnightUpper toKnockback;
        if (damageAmount > 10.0f && !this.worldObj.isRemote) {
            this.damageShield();
        } else {
            this.worldObj.playSoundAtEntity((Entity)this, "random.break", 1.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        EntityTFGoblinKnightUpper entityTFGoblinKnightUpper = toKnockback = this.ridingEntity != null && this.ridingEntity instanceof EntityLiving ? (EntityLiving)this.ridingEntity : this;
        if (par1DamageSource.getEntity() != null) {
            double d0 = par1DamageSource.getEntity().posX - this.posX;
            double d1 = par1DamageSource.getEntity().posZ - this.posZ;
            while (d0 * d0 + d1 * d1 < 1.0E-4) {
                d0 = (Math.random() - Math.random()) * 0.01;
                d1 = (Math.random() - Math.random()) * 0.01;
            }
            toKnockback.knockBack(par1DamageSource.getEntity(), 0.0f, d0 / 4.0, d1 / 4.0);
            if (par1DamageSource.getEntity() instanceof EntityLiving) {
                this.setRevengeTarget((EntityLivingBase)((EntityLiving)par1DamageSource.getEntity()));
            }
        }
        return true;
    }

    private void damageShield() {
        this.worldObj.playSoundAtEntity((Entity)this, "mob.zombie.metal", 0.25f, 0.25f);
        ++this.shieldHits;
        if (!this.worldObj.isRemote && this.shieldHits >= 3) {
            this.breakShield();
        }
    }

    public int getTotalArmorValue() {
        int armor = super.getTotalArmorValue();
        if (this.hasArmor()) {
            armor += 20;
        }
        if (armor > 20) {
            armor = 20;
        }
        return armor;
    }

    protected Item getDropItem() {
        return TFItems.armorShard;
    }
}

