/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFGoblinKnightUpper;
import twilightforest.entity.ai.EntityAITFRiderSpearAttack;
import twilightforest.item.TFItems;

public class EntityTFGoblinKnightLower
extends EntityMob {
    private static final int DATA_EQUIP = 17;

    public EntityTFGoblinKnightLower(World par1World) {
        super(par1World);
        this.setSize(0.7f, 1.1f);
        this.tasks.addTask(0, (EntityAIBase)new EntityAITFRiderSpearAttack(this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false));
        this.setHasArmor(true);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.28);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)0);
    }

    public boolean hasArmor() {
        return (this.dataWatcher.getWatchableObjectByte(17) & 1) > 0;
    }

    public void setHasArmor(boolean flag) {
        byte otherFlags = this.dataWatcher.getWatchableObjectByte(17);
        otherFlags = (byte)(otherFlags & 0x7E);
        if (flag) {
            this.dataWatcher.updateObject(17, (Object)((byte)(otherFlags | 1)));
        } else {
            this.dataWatcher.updateObject(17, (Object)otherFlags);
        }
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("hasArmor", this.hasArmor());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setHasArmor(par1NBTTagCompound.getBoolean("hasArmor"));
    }

    public void initCreature() {
        EntityTFGoblinKnightUpper upper = new EntityTFGoblinKnightUpper(this.worldObj);
        upper.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, 0.0f);
        upper.onSpawnWithEgg(null);
        this.worldObj.spawnEntityInWorld((Entity)upper);
        upper.mountEntity((Entity)this);
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        IEntityLivingData par1EntityLivingData1 = super.onSpawnWithEgg(par1EntityLivingData);
        EntityTFGoblinKnightUpper upper = new EntityTFGoblinKnightUpper(this.worldObj);
        upper.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, 0.0f);
        upper.onSpawnWithEgg(null);
        this.worldObj.spawnEntityInWorld((Entity)upper);
        upper.mountEntity((Entity)this);
        return par1EntityLivingData1;
    }

    public double getMountedYOffset() {
        return 1.0;
    }

    public void onUpdate() {
        if (this.isEntityAlive() && this.riddenByEntity != null && this.riddenByEntity instanceof EntityLiving && this.getAttackTarget() == null) {
            this.setAttackTarget(((EntityLiving)this.riddenByEntity).getAttackTarget());
        }
        super.onUpdate();
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityLiving) {
            return ((EntityLiving)this.riddenByEntity).attackEntityAsMob(par1Entity);
        }
        return super.attackEntityAsMob(par1Entity);
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float damageAmount) {
        Entity attacker = null;
        if (par1DamageSource.getSourceOfDamage() != null) {
            attacker = par1DamageSource.getSourceOfDamage();
        }
        if (par1DamageSource.getEntity() != null) {
            attacker = par1DamageSource.getEntity();
        }
        if (attacker != null) {
            double dx = this.posX - attacker.posX;
            double dz = this.posZ - attacker.posZ;
            float angle = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float difference = MathHelper.abs((float)((this.renderYawOffset - angle) % 360.0f));
            EntityTFGoblinKnightUpper upper = null;
            if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityTFGoblinKnightUpper) {
                upper = (EntityTFGoblinKnightUpper)this.riddenByEntity;
            }
            if (upper != null && upper.hasShield() && difference > 150.0f && difference < 230.0f && upper.takeHitOnShield(par1DamageSource, damageAmount)) {
                return false;
            }
            if (this.hasArmor() && (difference > 300.0f || difference < 60.0f)) {
                this.breakArmor();
            }
        }
        boolean attackSuccess = super.attackEntityFrom(par1DamageSource, damageAmount);
        return attackSuccess;
    }

    public void breakArmor() {
        this.renderBrokenItemStack(new ItemStack((Item)Items.iron_chestplate));
        this.renderBrokenItemStack(new ItemStack((Item)Items.iron_chestplate));
        this.renderBrokenItemStack(new ItemStack((Item)Items.iron_chestplate));
        this.setHasArmor(false);
    }

    public int getTotalArmorValue() {
        int armor = super.getTotalArmorValue();
        if (this.hasArmor()) {
            armor += 17;
        }
        if (armor > 20) {
            armor = 20;
        }
        return armor;
    }

    protected Item getDropItemId() {
        return TFItems.armorShard;
    }
}

