/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.entity.ai.EntityAITFMagicAttack;
import twilightforest.item.TFItems;

public class EntityTFDeathTome
extends EntityMob {
    public EntityTFDeathTome(World par1World) {
        super(par1World);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(4, (EntityAIBase)new EntityAITFMagicAttack((EntityLiving)this, 1.0f, 2, 60));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    public int getAttackStrength(Entity par1Entity) {
        return 4;
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.25);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        for (int i = 0; i < 1; ++i) {
            this.worldObj.spawnParticle("enchantmenttable", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * ((double)this.height - 0.75) + 0.5, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, 0.0, 0.5, 0.0);
        }
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.isFireDamage()) {
            par2 *= 2.0f;
        }
        if (super.attackEntityFrom(par1DamageSource, par2)) {
            if (this.rand.nextInt(2) == 0) {
                this.func_145778_a(Items.paper, 1, 1.0f);
            }
            return true;
        }
        return false;
    }

    protected Item getDropItem() {
        return Items.paper;
    }

    protected void dropFewItems(boolean par1, int par2) {
        int var3 = this.rand.nextInt(3 + par2);
        for (int var4 = 0; var4 < var3; ++var4) {
            this.dropItem(Items.paper, 1);
        }
        if (this.rand.nextInt(5) - par2 <= 0) {
            this.dropItem(Items.writable_book, 1);
        } else {
            this.dropItem(Items.book, 1);
        }
    }

    protected void dropRareDrop(int par1) {
        this.dropItem(TFItems.magicMapFocus, 1);
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }
}

