/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFGoblinChain;
import twilightforest.item.ItemTFChainBlock;

public class EntityTFChainBlock
extends EntityThrowable
implements IEntityMultiPart {
    private static final int MAX_SMASH = 12;
    private static final int MAX_CHAIN = 16;
    private boolean isReturning = false;
    private int blocksSmashed = 0;
    private double velX;
    private double velY;
    private double velZ;
    private boolean isAttached;
    private EntityLivingBase attachedTo;
    public EntityTFGoblinChain chain1;
    public EntityTFGoblinChain chain2;
    public EntityTFGoblinChain chain3;
    public EntityTFGoblinChain chain4;
    public EntityTFGoblinChain chain5;
    public Entity[] partsArray;

    public EntityTFChainBlock(World par1World) {
        super(par1World);
        this.setSize(0.6f, 0.6f);
        Entity[] entityArray = new Entity[5];
        this.chain1 = new EntityTFGoblinChain((Entity)this);
        entityArray[0] = this.chain1;
        this.chain2 = new EntityTFGoblinChain((Entity)this);
        entityArray[1] = this.chain2;
        this.chain3 = new EntityTFGoblinChain((Entity)this);
        entityArray[2] = this.chain3;
        this.chain4 = new EntityTFGoblinChain((Entity)this);
        entityArray[3] = this.chain4;
        this.chain5 = new EntityTFGoblinChain((Entity)this);
        entityArray[4] = this.chain5;
        this.partsArray = entityArray;
    }

    public EntityTFChainBlock(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    public EntityTFChainBlock(World par1World, EntityLivingBase par2EntityLiving) {
        super(par1World, par2EntityLiving);
        this.setSize(0.6f, 0.6f);
        this.isReturning = false;
    }

    public void setThrowableHeading(double x, double y, double z, float speed, float accuracy) {
        super.setThrowableHeading(x, y, z, speed, accuracy);
        this.velX = this.motionX;
        this.velY = this.motionY;
        this.velZ = this.motionZ;
    }

    protected float getGravityVelocity() {
        return 0.05f;
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.entityHit != null && mop.entityHit instanceof EntityLivingBase && mop.entityHit != this.getThrower() && mop.entityHit.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)((EntityPlayer)this.getThrower())), 10.0f)) {
            this.ticksExisted += 60;
        }
        if (!this.worldObj.isAirBlock(mop.blockX, mop.blockY, mop.blockZ)) {
            if (!this.isReturning) {
                this.worldObj.playSoundAtEntity((Entity)this, "random.anvil_land", 0.125f, this.rand.nextFloat());
            }
            if (!this.worldObj.isRemote && this.blocksSmashed < 12) {
                if (this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ).getBlockHardness(this.worldObj, mop.blockX, mop.blockY, mop.blockZ) > 0.3f) {
                    double bounce = 0.6;
                    this.velX *= bounce;
                    this.velY *= bounce;
                    this.velZ *= bounce;
                    switch (mop.sideHit) {
                        case 0: {
                            if (!(this.velY > 0.0)) break;
                            this.velY *= -bounce;
                            break;
                        }
                        case 1: {
                            if (!(this.velY < 0.0)) break;
                            this.velY *= -bounce;
                            break;
                        }
                        case 2: {
                            if (!(this.velZ > 0.0)) break;
                            this.velZ *= -bounce;
                            break;
                        }
                        case 3: {
                            if (!(this.velZ < 0.0)) break;
                            this.velZ *= -bounce;
                            break;
                        }
                        case 4: {
                            if (!(this.velX > 0.0)) break;
                            this.velX *= -bounce;
                            break;
                        }
                        case 5: {
                            if (!(this.velX < 0.0)) break;
                            this.velX *= -bounce;
                        }
                    }
                }
                this.affectBlocksInAABB(this.boundingBox, this.getThrower());
            }
            if (!this.worldObj.isRemote) {
                this.isReturning = true;
            }
            if (this.blocksSmashed > 12 && this.ticksExisted < 60) {
                this.ticksExisted += 60;
            }
        }
    }

    private boolean affectBlocksInAABB(AxisAlignedBB par1AxisAlignedBB, EntityLivingBase entity) {
        int minX = MathHelper.floor_double((double)par1AxisAlignedBB.minX);
        int minY = MathHelper.floor_double((double)par1AxisAlignedBB.minY);
        int minZ = MathHelper.floor_double((double)par1AxisAlignedBB.minZ);
        int maxX = MathHelper.floor_double((double)par1AxisAlignedBB.maxX);
        int maxY = MathHelper.floor_double((double)par1AxisAlignedBB.maxY);
        int maxZ = MathHelper.floor_double((double)par1AxisAlignedBB.maxZ);
        boolean hitBlock = false;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dy = minY; dy <= maxY; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    EntityPlayer player;
                    Block block = this.worldObj.getBlock(dx, dy, dz);
                    int currentMeta = this.worldObj.getBlockMetadata(dx, dy, dz);
                    if (block == Blocks.air || !(block.getExplosionResistance((Entity)this) < 7.0f) || !(block.getBlockHardness(this.worldObj, dx, dy, dz) >= 0.0f)) continue;
                    if (entity != null && entity instanceof EntityPlayer && block.canHarvestBlock(player = (EntityPlayer)entity, currentMeta)) {
                        block.harvestBlock(this.worldObj, player, dx, dy, dz, currentMeta);
                    }
                    this.worldObj.setBlockToAir(dx, dy, dz);
                    this.worldObj.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)block) + (currentMeta << 12));
                    ++this.blocksSmashed;
                    hitBlock = true;
                }
            }
        }
        return hitBlock;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.chain1 != null) {
            this.chain1.onUpdate();
            this.chain2.onUpdate();
            this.chain3.onUpdate();
            this.chain4.onUpdate();
            this.chain5.onUpdate();
        }
        if (this.getThrower() == null && !this.worldObj.isRemote) {
            this.setDead();
        }
        if (this.getThrower() != null) {
            float distToPlayer = this.getDistanceToEntity((Entity)this.getThrower());
            if (!this.isReturning && distToPlayer > 16.0f) {
                this.isReturning = true;
            }
            if (this.isReturning && distToPlayer < 1.0f) {
                if (this.getThrower() instanceof EntityPlayer) {
                    ItemTFChainBlock.setChainAsReturned((EntityPlayer)this.getThrower());
                }
                this.setDead();
            }
        }
        if (this.isReturning && !this.worldObj.isRemote && this.getThrower() != null) {
            EntityLivingBase returnTo = this.getThrower();
            Vec3 back = Vec3.createVectorHelper((double)(returnTo.posX - this.posX), (double)(returnTo.posY + (double)returnTo.getEyeHeight() - 1.200000023841858 - this.posY), (double)(returnTo.posZ - this.posZ)).normalize();
            float age = Math.min((float)this.ticksExisted * 0.03f, 1.0f);
            this.motionX = this.velX * (1.0 - (double)age) + back.xCoord * 2.0 * (double)age;
            this.motionY = this.velY * (1.0 - (double)age) + back.yCoord * 2.0 * (double)age - (double)this.getGravityVelocity();
            this.motionZ = this.velZ * (1.0 - (double)age) + back.zCoord * 2.0 * (double)age;
        }
        if (this.worldObj.isRemote && !this.isAttached) {
            List nearbyEntities = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(-this.motionX, -this.motionY, -this.motionZ).expand(2.0, 2.0, 2.0));
            for (int i = 0; i < nearbyEntities.size(); ++i) {
                Entity nearby = (Entity)nearbyEntities.get(i);
                if (!(nearby instanceof EntityPlayer)) continue;
                this.attachedTo = (EntityPlayer)nearby;
            }
            this.isAttached = true;
        }
        if (this.attachedTo != null) {
            Vec3 handVec = this.attachedTo.getLookVec();
            handVec.rotateAroundY(-0.4f);
            double sx = this.attachedTo.posX + handVec.xCoord;
            double sy = this.attachedTo.posY + handVec.yCoord - (double)0.6f;
            double sz = this.attachedTo.posZ + handVec.zCoord;
            double ox = sx - this.posX;
            double oy = sy - this.posY - 0.25;
            double oz = sz - this.posZ;
            this.chain1.setPosition(sx - ox * 0.05, sy - oy * 0.05, sz - oz * 0.05);
            this.chain2.setPosition(sx - ox * 0.25, sy - oy * 0.25, sz - oz * 0.25);
            this.chain3.setPosition(sx - ox * 0.45, sy - oy * 0.45, sz - oz * 0.45);
            this.chain4.setPosition(sx - ox * 0.65, sy - oy * 0.65, sz - oz * 0.65);
            this.chain5.setPosition(sx - ox * 0.85, sy - oy * 0.85, sz - oz * 0.85);
        }
    }

    protected float func_70182_d() {
        return 1.5f;
    }

    public World func_82194_d() {
        return this.worldObj;
    }

    public boolean attackEntityFromPart(EntityDragonPart p_70965_1_, DamageSource p_70965_2_, float p_70965_3_) {
        return false;
    }

    public Entity[] getParts() {
        return this.partsArray;
    }
}

