/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.entity.ai.EntityAITFChargeAttack;
import twilightforest.item.TFItems;

public class EntityTFBoggard
extends EntityMob {
    private boolean shy;

    public EntityTFBoggard(World world) {
        super(world);
        this.setSize(0.8f, 1.1f);
        this.shy = true;
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAITFChargeAttack((EntityCreature)this, 2.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false));
    }

    public EntityTFBoggard(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y, z);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(14.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.28);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(3.0);
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.redcap.redcap";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.redcap.redcaphurt";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.redcap.redcapdie";
    }

    protected Item getDropItem() {
        return Items.iron_boots;
    }

    protected void dropFewItems(boolean flag, int i) {
        if (this.rand.nextInt(5) == 0) {
            this.dropItem(TFItems.mazeMapFocus, 1 + i);
        }
        if (this.rand.nextInt(6) == 0) {
            this.dropItem((Item)Items.iron_boots, 1 + i);
        }
        if (this.rand.nextInt(9) == 0) {
            this.dropItem(Items.iron_pickaxe, 1 + i);
        }
    }

    public boolean isShy() {
        return this.shy && this.recentlyHit <= 0;
    }

    public boolean isTargetLookingAtMe() {
        double dz = this.posZ - this.entityToAttack.posZ;
        double dx = this.posX - this.entityToAttack.posX;
        float angle = (float)(Math.atan2(dz, dx) * 180.0 / 3.1415927410125732) - 90.0f;
        float difference = MathHelper.abs((float)((this.entityToAttack.rotationYaw - angle) % 360.0f));
        return difference < 60.0f || difference > 300.0f;
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            int chunkX = MathHelper.floor_double((double)this.posX) >> 4;
            int chunkZ = MathHelper.floor_double((double)this.posZ) >> 4;
            if (TFFeature.getNearestFeature(chunkX, chunkZ, this.worldObj) == TFFeature.hill1) {
                ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHill1);
            }
        }
    }

    public void moveEntityWithHeading(float par1, float par2) {
        super.moveEntityWithHeading(par1, par2);
    }
}

