/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySeekerArrow
extends EntityArrow {
    private EntityLivingBase homingTarget;
    double seekDistance = 5.0;

    public EntitySeekerArrow(World world) {
        super(world);
    }

    public EntitySeekerArrow(World world, EntityPlayer player, float velocity) {
        super(world, (EntityLivingBase)player, velocity);
    }

    public void onUpdate() {
        if (this.isThisArrowFlying()) {
            if (this.homingTarget == null) {
                double minX = this.lastTickPosX;
                double minY = this.lastTickPosY;
                double minZ = this.lastTickPosZ;
                double maxX = this.lastTickPosX;
                double maxY = this.lastTickPosY;
                double maxZ = this.lastTickPosZ;
                AxisAlignedBB targetBB = AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
                Vec3 courseVec = Vec3.createVectorHelper((double)(this.motionX * this.seekDistance), (double)(this.motionY * this.seekDistance), (double)(this.motionZ * this.seekDistance));
                courseVec.rotateAroundY(0.5235988f);
                targetBB = targetBB.addCoord(courseVec.xCoord, courseVec.yCoord, courseVec.zCoord);
                courseVec = Vec3.createVectorHelper((double)(this.motionX * this.seekDistance), (double)(this.motionY * this.seekDistance), (double)(this.motionZ * this.seekDistance));
                courseVec.rotateAroundY(-0.5235988f);
                targetBB = targetBB.addCoord(courseVec.xCoord, courseVec.yCoord, courseVec.zCoord);
                targetBB.minY -= 3.0;
                targetBB.maxY += 3.0;
                List targets = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, targetBB, IEntitySelector.selectAnything);
                double closestDot = 1.0;
                for (Object thing : targets) {
                    if (!(thing instanceof EntityLivingBase) || thing instanceof EntityPlayer) continue;
                    EntityLivingBase living = (EntityLivingBase)thing;
                    courseVec = Vec3.createVectorHelper((double)this.motionX, (double)this.motionY, (double)this.motionZ);
                    courseVec = courseVec.normalize();
                    Vec3 targetVec = Vec3.createVectorHelper((double)(this.posX - living.posX), (double)(this.posY - (living.posY + (double)living.getEyeHeight())), (double)(this.posZ - living.posZ));
                    double dot = courseVec.dotProduct(targetVec = targetVec.normalize());
                    if (!(dot < closestDot)) continue;
                    this.homingTarget = living;
                    closestDot = dot;
                }
            } else {
                Vec3 targetVec = Vec3.createVectorHelper((double)(this.posX - this.homingTarget.posX), (double)(this.posY - (this.homingTarget.posY + (double)this.homingTarget.getEyeHeight())), (double)(this.posZ - this.homingTarget.posZ));
                targetVec = targetVec.normalize();
                Vec3 courseVec = Vec3.createVectorHelper((double)(this.motionX * this.seekDistance), (double)(this.motionY * this.seekDistance), (double)(this.motionZ * this.seekDistance));
                double dotProduct = (courseVec = courseVec.normalize()).dotProduct(targetVec);
                if (dotProduct < 0.0) {
                    float currentSpeed = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
                    currentSpeed = (float)((double)currentSpeed * 1.0);
                    targetVec.xCoord *= (double)currentSpeed;
                    targetVec.yCoord *= (double)currentSpeed;
                    targetVec.zCoord *= (double)currentSpeed;
                    double dx = MathHelper.clamp_double((double)targetVec.xCoord, (double)-2.0, (double)2.0);
                    double dy = MathHelper.clamp_double((double)targetVec.yCoord, (double)-1.0, (double)1.0);
                    double dz = MathHelper.clamp_double((double)targetVec.zCoord, (double)-2.0, (double)2.0);
                    this.motionX -= dx;
                    this.motionY -= dy;
                    this.motionZ -= dz;
                } else {
                    this.homingTarget = null;
                }
            }
            this.motionY += (double)0.045f;
        }
        super.onUpdate();
    }

    private boolean isThisArrowFlying() {
        return (double)MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ)) > 1.0;
    }
}

