/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.blocks;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import twilightforest.block.TFBlocks;

public class RenderBlockTFThorns
implements ISimpleBlockRenderingHandler {
    final int renderID;

    public RenderBlockTFThorns(int blockComplexRenderID) {
        this.renderID = blockComplexRenderID;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        RenderBlockTFThorns.renderInvBlock(renderer, block, metadata);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int l = block.colorMultiplier(world, x, y, z);
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        int metadata = world.getBlockMetadata(x, y, z);
        int type = metadata & 0xC;
        switch (type) {
            default: {
                return this.renderCactusLikeY(block, x, y, z, f, f1, f2, metadata, world, renderer);
            }
            case 4: {
                return this.renderCactusLikeX(block, x, y, z, f, f1, f2, metadata, world, renderer);
            }
            case 8: 
        }
        return this.renderCactusLikeZ(block, x, y, z, f, f1, f2, metadata, world, renderer);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderID;
    }

    public boolean renderCactusLikeX(Block block, int x, int y, int z, float red, float green, float blue, int metadata, IBlockAccess world, RenderBlocks renderer) {
        this.setUVRotationX(renderer);
        Tessellator tessellator = Tessellator.instance;
        float middle = 0.5f;
        float full = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float bRed = middle * red;
        float tRed = full * red;
        float zRed = f5 * red;
        float xRed = f6 * red;
        float bGreen = middle * green;
        float tGreen = full * green;
        float zGreen = f5 * green;
        float xGreen = f6 * green;
        float bBlue = middle * blue;
        float tBlue = full * blue;
        float zBlue = f5 * blue;
        float xBlue = f6 * blue;
        float onePixel = 0.1875f;
        int blockBrightness = block.getMixedBrightnessForBlock(renderer.blockAccess, x, y, z);
        if (renderer.renderAllFaces || block.shouldSideBeRendered(renderer.blockAccess, x - 1, y, z, 4)) {
            tessellator.setBrightness(renderer.renderMinX > 0.0 ? blockBrightness : block.getMixedBrightnessForBlock(renderer.blockAccess, x - 1, y, z));
            tessellator.setColorOpaque_F(bRed, bGreen, bBlue);
            renderer.renderFaceXNeg(block, (double)x, (double)y, (double)z, renderer.getBlockIcon(block, renderer.blockAccess, x, y, z, 4));
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(renderer.blockAccess, x + 1, y, z, 5)) {
            tessellator.setBrightness(renderer.renderMaxX < 1.0 ? blockBrightness : block.getMixedBrightnessForBlock(renderer.blockAccess, x + 1, y, z));
            tessellator.setColorOpaque_F(tRed, tGreen, tBlue);
            renderer.renderFaceXPos(block, (double)x, (double)y, (double)z, renderer.getBlockIcon(block, renderer.blockAccess, x, y, z, 5));
        }
        this.drawXSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, onePixel, blockBrightness);
        this.resetUVRotation(renderer);
        if (this.canConnectTo(world, x, y, z + 1)) {
            this.setUVRotationZ(renderer);
            renderer.setRenderBounds(0.0, 0.0, (double)(1.0f - onePixel), 1.0, 1.0, 1.0);
            this.drawZSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
            this.resetUVRotation(renderer);
        }
        if (this.canConnectTo(world, x, y, z - 1)) {
            this.setUVRotationZ(renderer);
            renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, (double)onePixel);
            this.drawZSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
            this.resetUVRotation(renderer);
        }
        if (this.canConnectTo(world, x, y + 1, z)) {
            this.resetUVRotation(renderer);
            renderer.setRenderBounds(0.0, (double)(1.0f - onePixel), 0.0, 1.0, 1.0, 1.0);
            this.drawYSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
        }
        if (this.canConnectTo(world, x, y - 1, z)) {
            this.resetUVRotation(renderer);
            renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, (double)onePixel, 1.0);
            this.drawYSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
        }
        return true;
    }

    public boolean renderCactusLikeY(Block block, int x, int y, int z, float red, float green, float blue, int metadata, IBlockAccess world, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.instance;
        float middle = 0.5f;
        float full = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float bRed = middle * red;
        float tRed = full * red;
        float zRed = f5 * red;
        float xRed = f6 * red;
        float bGreen = middle * green;
        float tGreen = full * green;
        float zGreen = f5 * green;
        float xGreen = f6 * green;
        float bBlue = middle * blue;
        float tBlue = full * blue;
        float zBlue = f5 * blue;
        float xBlue = f6 * blue;
        float onePixel = 0.1875f;
        int blockBrightness = block.getMixedBrightnessForBlock(world, x, y, z);
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y - 1, z, 0)) {
            tessellator.setBrightness(renderer.renderMinY > 0.0 ? blockBrightness : block.getMixedBrightnessForBlock(world, x, y - 1, z));
            tessellator.setColorOpaque_F(bRed, bGreen, bBlue);
            renderer.renderFaceYNeg(block, (double)x, (double)y, (double)z, renderer.getBlockIcon(block, world, x, y, z, 0));
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y + 1, z, 1)) {
            tessellator.setBrightness(renderer.renderMaxY < 1.0 ? blockBrightness : block.getMixedBrightnessForBlock(world, x, y + 1, z));
            tessellator.setColorOpaque_F(tRed, tGreen, tBlue);
            renderer.renderFaceYPos(block, (double)x, (double)y, (double)z, renderer.getBlockIcon(block, world, x, y, z, 1));
        }
        this.drawYSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, onePixel, blockBrightness);
        if (this.canConnectTo(world, x + 1, y, z)) {
            this.setUVRotationX(renderer);
            renderer.setRenderBounds((double)(1.0f - onePixel), 0.0, 0.0, 1.0, 1.0, 1.0);
            this.drawXSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
            this.resetUVRotation(renderer);
        }
        if (this.canConnectTo(world, x - 1, y, z)) {
            this.setUVRotationX(renderer);
            renderer.setRenderBounds(0.0, 0.0, 0.0, (double)onePixel, 1.0, 1.0);
            this.drawXSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
            this.resetUVRotation(renderer);
        }
        if (this.canConnectTo(world, x, y, z + 1)) {
            this.setUVRotationZ(renderer);
            renderer.setRenderBounds(0.0, 0.0, (double)(1.0f - onePixel), 1.0, 1.0, 1.0);
            this.drawZSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
            this.resetUVRotation(renderer);
        }
        if (this.canConnectTo(world, x, y, z - 1)) {
            this.setUVRotationZ(renderer);
            renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, (double)onePixel);
            this.drawZSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
            this.resetUVRotation(renderer);
        }
        return true;
    }

    public boolean renderCactusLikeZ(Block block, int x, int y, int z, float red, float green, float blue, int metadata, IBlockAccess world, RenderBlocks renderer) {
        this.setUVRotationZ(renderer);
        Tessellator tessellator = Tessellator.instance;
        float middle = 0.5f;
        float full = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float bRed = middle * red;
        float tRed = full * red;
        float zRed = f5 * red;
        float xRed = f6 * red;
        float bGreen = middle * green;
        float tGreen = full * green;
        float zGreen = f5 * green;
        float xGreen = f6 * green;
        float bBlue = middle * blue;
        float tBlue = full * blue;
        float zBlue = f5 * blue;
        float xBlue = f6 * blue;
        float onePixel = 0.1875f;
        int blockBrightness = block.getMixedBrightnessForBlock(renderer.blockAccess, x, y, z);
        if (renderer.renderAllFaces || block.shouldSideBeRendered(renderer.blockAccess, x, y, z - 1, 0)) {
            tessellator.setBrightness(renderer.renderMinZ > 0.0 ? blockBrightness : block.getMixedBrightnessForBlock(renderer.blockAccess, x, y, z - 1));
            tessellator.setColorOpaque_F(bRed, bGreen, bBlue);
            renderer.renderFaceZNeg(block, (double)x, (double)y, (double)z, renderer.getBlockIcon(block, renderer.blockAccess, x, y, z, 2));
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(renderer.blockAccess, x, y, z + 1, 1)) {
            tessellator.setBrightness(renderer.renderMaxZ < 1.0 ? blockBrightness : block.getMixedBrightnessForBlock(renderer.blockAccess, x, y, z + 1));
            tessellator.setColorOpaque_F(tRed, tGreen, tBlue);
            renderer.renderFaceZPos(block, (double)x, (double)y, (double)z, renderer.getBlockIcon(block, renderer.blockAccess, x, y, z, 3));
        }
        this.drawZSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, onePixel, blockBrightness);
        this.resetUVRotation(renderer);
        if (this.canConnectTo(world, x + 1, y, z)) {
            this.setUVRotationX(renderer);
            renderer.setRenderBounds((double)(1.0f - onePixel), 0.0, 0.0, 1.0, 1.0, 1.0);
            this.drawXSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
            this.resetUVRotation(renderer);
        }
        if (this.canConnectTo(world, x - 1, y, z)) {
            this.setUVRotationX(renderer);
            renderer.setRenderBounds(0.0, 0.0, 0.0, (double)onePixel, 1.0, 1.0);
            this.drawXSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
            this.resetUVRotation(renderer);
        }
        if (this.canConnectTo(world, x, y + 1, z)) {
            this.resetUVRotation(renderer);
            renderer.setRenderBounds(0.0, (double)(1.0f - onePixel), 0.0, 1.0, 1.0, 1.0);
            this.drawYSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
        }
        if (this.canConnectTo(world, x, y - 1, z)) {
            this.resetUVRotation(renderer);
            renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, (double)onePixel, 1.0);
            this.drawYSides(block, x, y, z, renderer, metadata, zRed, xRed, zGreen, xGreen, zBlue, xBlue, 0.18900001f, blockBrightness);
        }
        return true;
    }

    private void drawXSides(Block block, int x, int y, int z, RenderBlocks renderer, int metadata, float zRed, float xRed, float zGreen, float xGreen, float zBlue, float xBlue, float onePixel, int l) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(l);
        tessellator.setColorOpaque_F(zRed, zGreen, zBlue);
        tessellator.addTranslation(0.0f, 0.0f, onePixel);
        renderer.renderFaceZNeg(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(0.0f, 0.0f, -onePixel);
        tessellator.addTranslation(0.0f, 0.0f, -onePixel);
        renderer.renderFaceZPos(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(0.0f, 0.0f, onePixel);
        tessellator.setColorOpaque_F(xRed, xGreen, xBlue);
        tessellator.addTranslation(0.0f, onePixel, 0.0f);
        renderer.renderFaceYNeg(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(0.0f, -onePixel, 0.0f);
        tessellator.addTranslation(0.0f, -onePixel, 0.0f);
        renderer.renderFaceYPos(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(0.0f, onePixel, 0.0f);
    }

    private void drawYSides(Block block, int x, int y, int z, RenderBlocks renderer, int metadata, float zRed, float xRed, float zGreen, float xGreen, float zBlue, float xBlue, float onePixel, int blockBrightness) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(blockBrightness);
        tessellator.setColorOpaque_F(zRed, zGreen, zBlue);
        tessellator.addTranslation(0.0f, 0.0f, onePixel);
        renderer.renderFaceZNeg(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(0.0f, 0.0f, -onePixel);
        tessellator.addTranslation(0.0f, 0.0f, -onePixel);
        renderer.renderFaceZPos(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(0.0f, 0.0f, onePixel);
        tessellator.setColorOpaque_F(xRed, xGreen, xBlue);
        tessellator.addTranslation(onePixel, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(-onePixel, 0.0f, 0.0f);
        tessellator.addTranslation(-onePixel, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(onePixel, 0.0f, 0.0f);
    }

    private void drawZSides(Block block, int x, int y, int z, RenderBlocks renderer, int metadata, float zRed, float xRed, float zGreen, float xGreen, float zBlue, float xBlue, float onePixel, int blockBrightness) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(blockBrightness);
        tessellator.setColorOpaque_F(xRed, xGreen, xBlue);
        tessellator.addTranslation(onePixel, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(-onePixel, 0.0f, 0.0f);
        tessellator.addTranslation(-onePixel, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(onePixel, 0.0f, 0.0f);
        tessellator.setColorOpaque_F(zRed, zGreen, zBlue);
        tessellator.addTranslation(0.0f, onePixel, 0.0f);
        renderer.renderFaceYNeg(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(0.0f, -onePixel, 0.0f);
        tessellator.addTranslation(0.0f, -onePixel, 0.0f);
        renderer.renderFaceYPos(block, (double)x, (double)y, (double)z, this.getSideIcon(block, metadata));
        tessellator.addTranslation(0.0f, onePixel, 0.0f);
    }

    private boolean canConnectTo(IBlockAccess world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        return block == TFBlocks.thorns || block == TFBlocks.burntThorns || block == TFBlocks.thornRose;
    }

    private void setUVRotationX(RenderBlocks renderer) {
        renderer.uvRotateEast = 1;
        renderer.uvRotateWest = 1;
        renderer.uvRotateTop = 1;
        renderer.uvRotateBottom = 1;
    }

    private void setUVRotationZ(RenderBlocks renderer) {
        renderer.uvRotateSouth = 1;
        renderer.uvRotateNorth = 1;
    }

    private void resetUVRotation(RenderBlocks renderer) {
        renderer.uvRotateTop = 0;
        renderer.uvRotateBottom = 0;
        renderer.uvRotateEast = 0;
        renderer.uvRotateWest = 0;
        renderer.uvRotateNorth = 0;
        renderer.uvRotateSouth = 0;
    }

    private IIcon getSideIcon(Block block, int metadata) {
        return block.getIcon(2, metadata & 3);
    }

    public static void renderInvBlock(RenderBlocks renderblocks, Block par1Block, int meta) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderBlockTFThorns.renderInvBlock(renderblocks, par1Block, meta, tessellator);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        par1Block.setBlockBoundsForItemRender();
    }

    protected static void renderInvBlock(RenderBlocks renderblocks, Block par1Block, int meta, Tessellator tessellator) {
        float onePixel = 0.1875f;
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderblocks.renderFaceYNeg(par1Block, 0.0, 0.0, 0.0, par1Block.getIcon(0, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderblocks.renderFaceYPos(par1Block, 0.0, 0.0, 0.0, par1Block.getIcon(1, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderblocks.renderFaceXPos(par1Block, (double)(-onePixel), 0.0, 0.0, par1Block.getIcon(2, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderblocks.renderFaceXNeg(par1Block, (double)onePixel, 0.0, 0.0, par1Block.getIcon(3, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderblocks.renderFaceZNeg(par1Block, 0.0, 0.0, (double)onePixel, par1Block.getIcon(4, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderblocks.renderFaceZPos(par1Block, 0.0, 0.0, (double)(-onePixel), par1Block.getIcon(5, meta));
        tessellator.draw();
    }
}

