/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.blocks;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import twilightforest.block.BlockTFPlant;

public class RenderBlockTFPlants
implements ISimpleBlockRenderingHandler {
    final int renderID;

    public RenderBlockTFPlants(int blockRenderID) {
        this.renderID = blockRenderID;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 3) {
            this.renderMossPatch(x, y, z, block, renderer);
        } else if (meta == 5) {
            this.renderCloverPatch(x, y, z, block, renderer);
        } else if (meta == 4) {
            this.renderMayapple(x, y, z, block, renderer);
        } else if (meta == 14) {
            renderer.renderBlockCrops(block, x, y, z);
        } else {
            renderer.renderCrossedSquares(block, x, y, z);
        }
        return true;
    }

    private void renderMayapple(int x, int y, int z, Block block, RenderBlocks renderer) {
        renderer.clearOverrideBlockTexture();
        renderer.setRenderBounds(0.25, 0.375, 0.25, 0.8125, 0.375, 0.8125);
        renderer.renderStandardBlock(block, x, y, z);
        renderer.overrideBlockTexture = BlockTFPlant.mayappleSide;
        renderer.setRenderBounds(0.5, 0.0, 0.5, 0.5625, (double)0.374375f, 0.5625);
        renderer.renderStandardBlock(block, x, y, z);
        renderer.clearOverrideBlockTexture();
    }

    private void renderCloverPatch(int x, int y, int z, Block block, RenderBlocks renderer) {
        renderer.renderMinY = renderer.renderMaxY;
        renderer.renderStandardBlock(block, x, y, z);
        renderer.renderMinY = 0.0;
        renderer.renderMaxY -= (double)0.01f;
        renderer.renderMinX += 0.0625;
        renderer.renderMinZ += 0.0625;
        renderer.renderMaxX -= 0.0625;
        renderer.renderMaxZ -= 0.0625;
        renderer.renderStandardBlock(block, x, y, z);
    }

    private void renderMossPatch(int x, int y, int z, Block block, RenderBlocks renderer) {
        double originalMaxX;
        int num3;
        int num2;
        int num1;
        int num0;
        long seed;
        double originalMaxZ;
        renderer.renderStandardBlock(block, x, y, z);
        if (renderer.renderMinX > 0.0) {
            originalMaxZ = renderer.renderMaxZ;
            seed = (long)(x * 3129871) ^ (long)y * 116129781L ^ (long)z;
            seed = seed * seed * 42317861L + seed * 7L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            renderer.renderMaxX = renderer.renderMinX;
            renderer.renderMinX -= 0.0625;
            renderer.renderMinZ += (double)((float)num0 / 16.0f);
            if (renderer.renderMaxZ - (double)((float)(num1 + num2 + num3) / 16.0f) > renderer.renderMinZ) {
                renderer.renderMaxZ = renderer.renderMinZ + (double)((float)num1 / 16.0f);
                renderer.renderStandardBlock(block, x, y, z);
                renderer.renderMaxZ = originalMaxZ - (double)((float)num2 / 16.0f);
                renderer.renderMinZ = renderer.renderMaxZ - (double)((float)num3 / 16.0f);
                renderer.renderStandardBlock(block, x, y, z);
            } else {
                renderer.renderMaxZ -= (double)((float)num2 / 16.0f);
                renderer.renderStandardBlock(block, x, y, z);
            }
            renderer.setRenderBoundsFromBlock(block);
        }
        if (renderer.renderMaxX < 1.0) {
            originalMaxZ = renderer.renderMaxZ;
            seed = (long)(x * 3129871) ^ (long)y * 116129781L ^ (long)z;
            seed = seed * seed * 42317861L + seed * 17L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            renderer.renderMinX = renderer.renderMaxX;
            renderer.renderMaxX += 0.0625;
            renderer.renderMinZ += (double)((float)num0 / 16.0f);
            if (renderer.renderMaxZ - (double)((float)(num1 + num2 + num3) / 16.0f) > renderer.renderMinZ) {
                renderer.renderMaxZ = renderer.renderMinZ + (double)((float)num1 / 16.0f);
                renderer.renderStandardBlock(block, x, y, z);
                renderer.renderMaxZ = originalMaxZ - (double)((float)num2 / 16.0f);
                renderer.renderMinZ = renderer.renderMaxZ - (double)((float)num3 / 16.0f);
                renderer.renderStandardBlock(block, x, y, z);
            } else {
                renderer.renderMaxZ -= (double)((float)num2 / 16.0f);
                renderer.renderStandardBlock(block, x, y, z);
            }
            renderer.setRenderBoundsFromBlock(block);
        }
        if (renderer.renderMinZ > 0.0) {
            originalMaxX = renderer.renderMaxX;
            seed = (long)(x * 3129871) ^ (long)y * 116129781L ^ (long)z;
            seed = seed * seed * 42317861L + seed * 23L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            renderer.renderMaxZ = renderer.renderMinZ;
            renderer.renderMinZ -= 0.0625;
            renderer.renderMinX += (double)((float)num0 / 16.0f);
            renderer.renderMaxX = renderer.renderMinX + (double)((float)num1 / 16.0f);
            renderer.renderStandardBlock(block, x, y, z);
            renderer.renderMaxX = originalMaxX - (double)((float)num2 / 16.0f);
            renderer.renderMinX = renderer.renderMaxX - (double)((float)num3 / 16.0f);
            renderer.renderStandardBlock(block, x, y, z);
            renderer.setRenderBoundsFromBlock(block);
        }
        if (renderer.renderMaxZ < 1.0) {
            originalMaxX = renderer.renderMaxX;
            seed = (long)(x * 3129871) ^ (long)y * 116129781L ^ (long)z;
            seed = seed * seed * 42317861L + seed * 11L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            renderer.renderMinZ = renderer.renderMaxZ;
            renderer.renderMaxZ += 0.0625;
            renderer.renderMinX += (double)((float)num0 / 16.0f);
            renderer.renderMaxX = renderer.renderMinX + (double)((float)num1 / 16.0f);
            renderer.renderStandardBlock(block, x, y, z);
            renderer.renderMaxX = originalMaxX - (double)((float)num2 / 16.0f);
            renderer.renderMinX = renderer.renderMaxX - (double)((float)num3 / 16.0f);
            renderer.renderStandardBlock(block, x, y, z);
            renderer.setRenderBoundsFromBlock(block);
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return this.renderID;
    }
}

