/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.blocks;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderBlockTFNagastone
implements ISimpleBlockRenderingHandler {
    final int renderID;

    public RenderBlockTFNagastone(int nagastoneRenderID) {
        this.renderID = nagastoneRenderID;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        this.setRenderRotate(renderer, metadata);
        RenderBlockTFNagastone.renderInvNormalBlock(renderer, block, metadata);
        this.restoreRendererRotate(renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = world.getBlockMetadata(x, y, z);
        this.setRenderRotate(renderer, meta);
        boolean didRender = renderer.renderStandardBlock(block, x, y, z);
        this.restoreRendererRotate(renderer);
        return didRender;
    }

    private void restoreRendererRotate(RenderBlocks renderer) {
        renderer.uvRotateSouth = 0;
        renderer.uvRotateEast = 0;
        renderer.uvRotateWest = 0;
        renderer.uvRotateNorth = 0;
        renderer.uvRotateTop = 0;
        renderer.uvRotateBottom = 0;
    }

    private void setRenderRotate(RenderBlocks renderer, int meta) {
        int type = meta & 0xC;
        int orient = meta & 3;
        if (type == 0) {
            switch (orient) {
                case 0: {
                    renderer.uvRotateTop = 1;
                    renderer.uvRotateBottom = 2;
                    break;
                }
                case 1: {
                    renderer.uvRotateTop = 2;
                    renderer.uvRotateBottom = 1;
                    renderer.uvRotateSouth = 0;
                    break;
                }
                case 2: {
                    renderer.uvRotateTop = 0;
                    renderer.uvRotateBottom = 3;
                    break;
                }
                case 3: {
                    renderer.uvRotateTop = 3;
                    renderer.uvRotateBottom = 0;
                }
            }
        } else if (type == 4 || type == 8) {
            switch (orient) {
                case 0: {
                    renderer.uvRotateTop = 2;
                    renderer.uvRotateBottom = 1;
                    renderer.uvRotateWest = 2;
                    break;
                }
                case 1: {
                    renderer.uvRotateTop = 1;
                    renderer.uvRotateBottom = 2;
                    renderer.uvRotateEast = 2;
                    break;
                }
                case 2: {
                    renderer.uvRotateTop = 3;
                    renderer.uvRotateBottom = 0;
                    renderer.uvRotateSouth = 2;
                    break;
                }
                case 3: {
                    renderer.uvRotateTop = 0;
                    renderer.uvRotateBottom = 3;
                    renderer.uvRotateNorth = 2;
                }
            }
        } else if (type == 12) {
            switch (orient) {
                case 0: {
                    renderer.uvRotateTop = 0;
                    renderer.uvRotateBottom = 0;
                    break;
                }
                case 1: {
                    renderer.uvRotateTop = 1;
                    renderer.uvRotateBottom = 1;
                    break;
                }
                case 2: {
                    renderer.uvRotateNorth = 2;
                    renderer.uvRotateSouth = 2;
                    renderer.uvRotateEast = 2;
                    renderer.uvRotateWest = 2;
                }
            }
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderID;
    }

    public static void renderInvNormalBlock(RenderBlocks renderblocks, Block par1Block, int meta) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderblocks.renderFaceYNeg(par1Block, 0.0, 0.0, 0.0, par1Block.getIcon(0, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderblocks.renderFaceYPos(par1Block, 0.0, 0.0, 0.0, par1Block.getIcon(1, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderblocks.renderFaceXPos(par1Block, 0.0, 0.0, 0.0, par1Block.getIcon(2, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderblocks.renderFaceXNeg(par1Block, 0.0, 0.0, 0.0, par1Block.getIcon(3, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderblocks.renderFaceZNeg(par1Block, 0.0, 0.0, 0.0, par1Block.getIcon(4, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderblocks.renderFaceZPos(par1Block, 0.0, 0.0, 0.0, par1Block.getIcon(5, meta));
        tessellator.draw();
    }
}

