/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFBiomeDarkForest;
import twilightforest.biomes.TFBiomeFinalPlateau;
import twilightforest.biomes.TFBiomeFireSwamp;
import twilightforest.biomes.TFBiomeGlacier;
import twilightforest.biomes.TFBiomeHighlands;
import twilightforest.biomes.TFBiomeSnow;
import twilightforest.biomes.TFBiomeSwamp;
import twilightforest.biomes.TFBiomeThornlands;

public class TFWeatherRenderer
extends IRenderHandler {
    private static final ResourceLocation locationRainPng = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation locationSnowPng = new ResourceLocation("textures/environment/snow.png");
    private static final ResourceLocation locationBlizzardPng = new ResourceLocation("twilightforest:textures/environment/blizzard.png");
    private static final ResourceLocation locationMosquitoPng = new ResourceLocation("twilightforest:textures/environment/mosquitoes.png");
    private static final ResourceLocation locationAshesPng = new ResourceLocation("twilightforest:textures/environment/ashes.png");
    private static final ResourceLocation locationDarkstreamPng = new ResourceLocation("twilightforest:textures/environment/darkstream.png");
    private static final ResourceLocation locationBigrainPng = new ResourceLocation("twilightforest:textures/environment/bigrain.png");
    private static final ResourceLocation locationSparklesPng = new ResourceLocation("twilightforest:textures/environment/sparkles.png");
    float[] rainXCoords;
    float[] rainYCoords;
    private int rendererUpdateCount;
    private Random random = new Random();
    private StructureBoundingBox protectedBox;

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        ++this.rendererUpdateCount;
        this.renderNormalWeather(partialTicks, mc);
        if (world.getGameRules().getGameRuleBooleanValue("tfEnforcedProgression") && !mc.thePlayer.capabilities.isCreativeMode) {
            this.renderLockedBiome(partialTicks, world, mc);
            this.renderLockedStructure(partialTicks, world, mc);
        }
    }

    private void renderNormalWeather(float partialTicks, Minecraft mc) {
        float rainStrength = mc.theWorld.getRainStrength(partialTicks);
        if (rainStrength > 0.0f) {
            mc.entityRenderer.enableLightmap((double)partialTicks);
            this.initializeRainCoords();
            EntityLivingBase entitylivingbase = mc.renderViewEntity;
            WorldClient worldclient = mc.theWorld;
            int k2 = MathHelper.floor_double((double)entitylivingbase.posX);
            int l2 = MathHelper.floor_double((double)entitylivingbase.posY);
            int i3 = MathHelper.floor_double((double)entitylivingbase.posZ);
            Tessellator tessellator = Tessellator.instance;
            GL11.glDisable((int)2884);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            double d0 = entitylivingbase.lastTickPosX + (entitylivingbase.posX - entitylivingbase.lastTickPosX) * (double)partialTicks;
            double d1 = entitylivingbase.lastTickPosY + (entitylivingbase.posY - entitylivingbase.lastTickPosY) * (double)partialTicks;
            double d2 = entitylivingbase.lastTickPosZ + (entitylivingbase.posZ - entitylivingbase.lastTickPosZ) * (double)partialTicks;
            int k = MathHelper.floor_double((double)d1);
            int range = 5;
            if (mc.gameSettings.fancyGraphics) {
                range = 10;
            }
            int b1 = -1;
            float f5 = (float)this.rendererUpdateCount + partialTicks;
            if (mc.gameSettings.fancyGraphics) {
                range = 10;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int l = i3 - range; l <= i3 + range; ++l) {
                for (int i1 = k2 - range; i1 <= k2 + range; ++i1) {
                    double xDist;
                    float downwardsMotion;
                    int j1 = (l - i3 + 16) * 32 + i1 - k2 + 16;
                    float f6 = this.rainXCoords[j1] * 0.5f;
                    float f7 = this.rainYCoords[j1] * 0.5f;
                    BiomeGenBase biomegenbase = worldclient.getBiomeGenForCoords(i1, l);
                    if (!biomegenbase.canSpawnLightningBolt() && !biomegenbase.getEnableSnow()) continue;
                    int k1 = worldclient.getPrecipitationHeight(i1, l);
                    int l1 = l2 - range;
                    int i2 = l2 + range;
                    if (l1 < k1) {
                        l1 = k1;
                    }
                    if (i2 < k1) {
                        i2 = k1;
                    }
                    float f8 = 1.0f;
                    int j2 = k1;
                    if (k1 < k) {
                        j2 = k;
                    }
                    if (l1 == i2) continue;
                    this.random.setSeed(i1 * i1 * 3121 + i1 * 45238971 ^ l * l * 418711 + l * 13761);
                    float f9 = biomegenbase.getFloatTemperature(i1, l1, l);
                    if (worldclient.getWorldChunkManager().getTemperatureAtHeight(f9, k1) >= 0.15f) {
                        if (b1 != 0) {
                            if (b1 >= 0) {
                                tessellator.draw();
                            }
                            b1 = 0;
                            mc.getTextureManager().bindTexture(locationRainPng);
                            tessellator.startDrawingQuads();
                        }
                        downwardsMotion = ((float)(this.rendererUpdateCount + i1 * i1 * 3121 + i1 * 45238971 + l * l * 418711 + l * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + this.random.nextFloat());
                        double d3 = (double)((float)i1 + 0.5f) - entitylivingbase.posX;
                        xDist = (double)((float)l + 0.5f) - entitylivingbase.posZ;
                        float f12 = MathHelper.sqrt_double((double)(d3 * d3 + xDist * xDist)) / (float)range;
                        float f13 = 1.0f;
                        tessellator.setBrightness(worldclient.getLightBrightnessForSkyBlocks(i1, j2, l, 0));
                        tessellator.setColorRGBA_F(f13, f13, f13, ((1.0f - f12 * f12) * 0.5f + 0.5f) * rainStrength);
                        tessellator.setTranslation(-d0 * 1.0, -d1 * 1.0, -d2 * 1.0);
                        tessellator.addVertexWithUV((double)((float)i1 - f6) + 0.5, (double)l1, (double)((float)l - f7) + 0.5, (double)(0.0f * f8), (double)((float)l1 * f8 / 4.0f + downwardsMotion * f8));
                        tessellator.addVertexWithUV((double)((float)i1 + f6) + 0.5, (double)l1, (double)((float)l + f7) + 0.5, (double)(1.0f * f8), (double)((float)l1 * f8 / 4.0f + downwardsMotion * f8));
                        tessellator.addVertexWithUV((double)((float)i1 + f6) + 0.5, (double)i2, (double)((float)l + f7) + 0.5, (double)(1.0f * f8), (double)((float)i2 * f8 / 4.0f + downwardsMotion * f8));
                        tessellator.addVertexWithUV((double)((float)i1 - f6) + 0.5, (double)i2, (double)((float)l - f7) + 0.5, (double)(0.0f * f8), (double)((float)i2 * f8 / 4.0f + downwardsMotion * f8));
                        tessellator.setTranslation(0.0, 0.0, 0.0);
                        continue;
                    }
                    if (b1 != 1) {
                        if (b1 >= 0) {
                            tessellator.draw();
                        }
                        b1 = 1;
                        mc.getTextureManager().bindTexture(locationSnowPng);
                        tessellator.startDrawingQuads();
                    }
                    downwardsMotion = ((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    float f16 = this.random.nextFloat() + f5 * 0.01f * (float)this.random.nextGaussian();
                    float f11 = this.random.nextFloat() + f5 * (float)this.random.nextGaussian() * 0.001f;
                    xDist = (double)((float)i1 + 0.5f) - entitylivingbase.posX;
                    double zDist = (double)((float)l + 0.5f) - entitylivingbase.posZ;
                    float f14 = MathHelper.sqrt_double((double)(xDist * xDist + zDist * zDist)) / (float)range;
                    float f15 = 1.0f;
                    tessellator.setBrightness((worldclient.getLightBrightnessForSkyBlocks(i1, j2, l, 0) * 3 + 0xF000F0) / 4);
                    tessellator.setColorRGBA_F(f15, f15, f15, ((1.0f - f14 * f14) * 0.3f + 0.5f) * rainStrength);
                    tessellator.setTranslation(-d0 * 1.0, -d1 * 1.0, -d2 * 1.0);
                    tessellator.addVertexWithUV((double)((float)i1 - f6) + 0.5, (double)l1, (double)((float)l - f7) + 0.5, (double)(0.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + downwardsMotion * f8 + f11));
                    tessellator.addVertexWithUV((double)((float)i1 + f6) + 0.5, (double)l1, (double)((float)l + f7) + 0.5, (double)(1.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + downwardsMotion * f8 + f11));
                    tessellator.addVertexWithUV((double)((float)i1 + f6) + 0.5, (double)i2, (double)((float)l + f7) + 0.5, (double)(1.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + downwardsMotion * f8 + f11));
                    tessellator.addVertexWithUV((double)((float)i1 - f6) + 0.5, (double)i2, (double)((float)l - f7) + 0.5, (double)(0.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + downwardsMotion * f8 + f11));
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                }
            }
            if (b1 >= 0) {
                tessellator.draw();
            }
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            mc.entityRenderer.disableLightmap((double)partialTicks);
        }
    }

    private void renderLockedBiome(float partialTicks, WorldClient world, Minecraft mc) {
        if (this.isNearLockedBiome((World)world, mc.renderViewEntity)) {
            this.initializeRainCoords();
            EntityLivingBase entitylivingbase = mc.renderViewEntity;
            WorldClient worldclient = mc.theWorld;
            int px = MathHelper.floor_double((double)entitylivingbase.posX);
            int py = MathHelper.floor_double((double)entitylivingbase.posY);
            int pz = MathHelper.floor_double((double)entitylivingbase.posZ);
            Tessellator tessellator = Tessellator.instance;
            GL11.glDisable((int)2884);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            double offX = entitylivingbase.lastTickPosX + (entitylivingbase.posX - entitylivingbase.lastTickPosX) * (double)partialTicks;
            double offY = entitylivingbase.lastTickPosY + (entitylivingbase.posY - entitylivingbase.lastTickPosY) * (double)partialTicks;
            double offZ = entitylivingbase.lastTickPosZ + (entitylivingbase.posZ - entitylivingbase.lastTickPosZ) * (double)partialTicks;
            int floorY = MathHelper.floor_double((double)offY);
            int range = 5;
            if (mc.gameSettings.fancyGraphics) {
                range = 10;
            }
            int drawFlag = -1;
            float preciseCount = (float)this.rendererUpdateCount + partialTicks;
            if (mc.gameSettings.fancyGraphics) {
                range = 15;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int dz = pz - range; dz <= pz + range; ++dz) {
                for (int dx = px - range; dx <= px + range; ++dx) {
                    float bright;
                    double zRange;
                    float vFactor;
                    int rainIndex = (dz - pz + 16) * 32 + dx - px + 16;
                    float rainX = this.rainXCoords[rainIndex] * 0.5f;
                    float rainZ = this.rainYCoords[rainIndex] * 0.5f;
                    BiomeGenBase biomegenbase = worldclient.getBiomeGenForCoords(dx, dz);
                    if (!(biomegenbase instanceof TFBiomeBase) || !(entitylivingbase instanceof EntityPlayer) || ((TFBiomeBase)biomegenbase).doesPlayerHaveRequiredAchievement((EntityPlayer)entitylivingbase)) continue;
                    int rainHeight = 0;
                    int rainMin = py - range;
                    int rainMax = py + range * 2;
                    if (rainMin < rainHeight) {
                        rainMin = rainHeight;
                    }
                    if (rainMax < rainHeight) {
                        rainMax = rainHeight;
                    }
                    float one = 1.0f;
                    int rainFloor = rainHeight;
                    if (rainHeight < floorY) {
                        rainFloor = floorY;
                    }
                    if (rainMin == rainMax) continue;
                    this.random.setSeed(dx * dx * 3121 + dx * 45238971 ^ dz * dz * 418711 + dz * 13761);
                    if (biomegenbase instanceof TFBiomeSnow || biomegenbase instanceof TFBiomeGlacier) {
                        if (drawFlag != 0) {
                            if (drawFlag >= 0) {
                                tessellator.draw();
                            }
                            drawFlag = 0;
                            mc.getTextureManager().bindTexture(locationBlizzardPng);
                            tessellator.startDrawingQuads();
                        }
                        float countFactor = ((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                        float uFactor = this.random.nextFloat() + preciseCount * 0.03f * (float)this.random.nextGaussian();
                        vFactor = this.random.nextFloat() + preciseCount * 0.001f * (float)this.random.nextGaussian();
                        double xRange = (double)((float)dx + 0.5f) - entitylivingbase.posX;
                        zRange = (double)((float)dz + 0.5f) - entitylivingbase.posZ;
                        float f14 = MathHelper.sqrt_double((double)(xRange * xRange + zRange * zRange)) / (float)range;
                        float onee = 1.0f;
                        tessellator.setBrightness((worldclient.getLightBrightnessForSkyBlocks(dx, rainFloor, dz, 0) * 3 + 0xF000F0) / 4);
                        tessellator.setColorRGBA_F(onee, onee, onee, ((1.0f - f14 * f14) * 0.3f + 0.5f) * 1.0f);
                        tessellator.setTranslation(-offX * 1.0, -offY * 1.0, -offZ * 1.0);
                        tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)rainMin, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)rainMin * one / 4.0f + countFactor * one + vFactor));
                        tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)rainMin, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)rainMin * one / 4.0f + countFactor * one + vFactor));
                        tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)rainMax, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)rainMax * one / 4.0f + countFactor * one + vFactor));
                        tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)rainMax, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)rainMax * one / 4.0f + countFactor * one + vFactor));
                        tessellator.setTranslation(0.0, 0.0, 0.0);
                        continue;
                    }
                    if (biomegenbase instanceof TFBiomeSwamp) {
                        if (drawFlag != 1) {
                            if (drawFlag >= 0) {
                                tessellator.draw();
                            }
                            drawFlag = 1;
                            mc.getTextureManager().bindTexture(locationMosquitoPng);
                            tessellator.startDrawingQuads();
                        }
                        float countFactor = 0.0f;
                        float uFactor = this.random.nextFloat() + preciseCount * 0.03f * (float)this.random.nextGaussian();
                        vFactor = this.random.nextFloat() + preciseCount * 0.003f * (float)this.random.nextGaussian();
                        tessellator.setBrightness(983055);
                        float r = this.random.nextFloat() * 0.3f;
                        float g = this.random.nextFloat() * 0.3f;
                        float b = this.random.nextFloat() * 0.3f;
                        tessellator.setColorRGBA_F(r, g, b, 1.0f);
                        tessellator.setTranslation(-offX * 1.0, -offY * 1.0, -offZ * 1.0);
                        tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)rainMin, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)rainMin * one / 4.0f + countFactor * one + vFactor));
                        tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)rainMin, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)rainMin * one / 4.0f + countFactor * one + vFactor));
                        tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)rainMax, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)rainMax * one / 4.0f + countFactor * one + vFactor));
                        tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)rainMax, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)rainMax * one / 4.0f + countFactor * one + vFactor));
                        tessellator.setTranslation(0.0, 0.0, 0.0);
                        continue;
                    }
                    if (biomegenbase instanceof TFBiomeFireSwamp) {
                        if (drawFlag != 2) {
                            if (drawFlag >= 0) {
                                tessellator.draw();
                            }
                            drawFlag = 2;
                            mc.getTextureManager().bindTexture(locationAshesPng);
                            tessellator.startDrawingQuads();
                        }
                        float countFactor = -((float)(this.rendererUpdateCount & 0x3FF) + partialTicks) / 1024.0f;
                        float uFactor = this.random.nextFloat() + preciseCount * 0.001f * (float)this.random.nextGaussian();
                        vFactor = this.random.nextFloat() + preciseCount * 0.001f * (float)this.random.nextGaussian();
                        double xRange = (double)((float)dx + 0.5f) - entitylivingbase.posX;
                        zRange = (double)((float)dz + 0.5f) - entitylivingbase.posZ;
                        float distanceFromPlayer = MathHelper.sqrt_double((double)(xRange * xRange + zRange * zRange)) / (float)range;
                        tessellator.setBrightness(983055);
                        bright = this.random.nextFloat() * 0.2f + 0.8f;
                        tessellator.setColorRGBA_F(bright, bright, bright, ((1.0f - distanceFromPlayer * distanceFromPlayer) * 0.3f + 0.5f) * 1.0f);
                        tessellator.setTranslation(-offX * 1.0, -offY * 1.0, -offZ * 1.0);
                        tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)rainMin, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)rainMin * one / 4.0f + countFactor * one + vFactor));
                        tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)rainMin, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)rainMin * one / 4.0f + countFactor * one + vFactor));
                        tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)rainMax, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)rainMax * one / 4.0f + countFactor * one + vFactor));
                        tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)rainMax, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)rainMax * one / 4.0f + countFactor * one + vFactor));
                        tessellator.setTranslation(0.0, 0.0, 0.0);
                        continue;
                    }
                    if (biomegenbase instanceof TFBiomeDarkForest && this.random.nextInt(2) == 0) {
                        if (drawFlag != 3) {
                            if (drawFlag >= 0) {
                                tessellator.draw();
                            }
                            drawFlag = 3;
                            mc.getTextureManager().bindTexture(locationDarkstreamPng);
                            tessellator.startDrawingQuads();
                        }
                        int darkRainMax = Math.min(rainMax, worldclient.getPrecipitationHeight(dx, dz));
                        int darkRainMin = Math.min(rainMin, darkRainMax);
                        float countFactor = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                        float uFactor = 0.0f;
                        float vFactor2 = this.random.nextFloat() + preciseCount * 0.01f * (float)this.random.nextGaussian();
                        double xRange = (double)((float)dx + 0.5f) - entitylivingbase.posX;
                        double zRange2 = (double)((float)dz + 0.5f) - entitylivingbase.posZ;
                        float distanceFromPlayer = MathHelper.sqrt_double((double)(xRange * xRange + zRange2 * zRange2)) / (float)range;
                        tessellator.setBrightness(983055);
                        float bright2 = 1.0f;
                        float alpha = this.random.nextFloat();
                        tessellator.setColorRGBA_F(bright2, bright2, bright2, ((1.0f - distanceFromPlayer * distanceFromPlayer) * 0.3f + 0.5f) * alpha);
                        tessellator.setTranslation(-offX * 1.0, -offY * 1.0, -offZ * 1.0);
                        tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)darkRainMin, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)darkRainMin * one / 4.0f + countFactor * one + vFactor2));
                        tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)darkRainMin, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)darkRainMin * one / 4.0f + countFactor * one + vFactor2));
                        tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)darkRainMax, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)darkRainMax * one / 4.0f + countFactor * one + vFactor2));
                        tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)darkRainMax, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)darkRainMax * one / 4.0f + countFactor * one + vFactor2));
                        tessellator.setTranslation(0.0, 0.0, 0.0);
                        continue;
                    }
                    if (!(biomegenbase instanceof TFBiomeHighlands) && !(biomegenbase instanceof TFBiomeThornlands) && !(biomegenbase instanceof TFBiomeFinalPlateau)) continue;
                    if (drawFlag != 4) {
                        if (drawFlag >= 0) {
                            tessellator.draw();
                        }
                        drawFlag = 4;
                        mc.getTextureManager().bindTexture(locationBigrainPng);
                        tessellator.startDrawingQuads();
                    }
                    float countFactor = ((float)(this.rendererUpdateCount + dx * dx * 3121 + dx * 45238971 + dz * dz * 418711 + dz * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + this.random.nextFloat());
                    float uFactor = this.random.nextFloat();
                    vFactor = this.random.nextFloat();
                    double xRange = (double)((float)dx + 0.5f) - entitylivingbase.posX;
                    zRange = (double)((float)dz + 0.5f) - entitylivingbase.posZ;
                    float distanceFromPlayer = MathHelper.sqrt_double((double)(xRange * xRange + zRange * zRange)) / (float)range;
                    tessellator.setBrightness(worldclient.getLightBrightnessForSkyBlocks(dx, rainFloor, dz, 0));
                    bright = 1.0f;
                    float alpha = 1.0f;
                    tessellator.setColorRGBA_F(bright, bright, bright, ((1.0f - distanceFromPlayer * distanceFromPlayer) * 0.3f + 0.5f) * alpha);
                    tessellator.setTranslation(-offX * 1.0, -offY * 1.0, -offZ * 1.0);
                    tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)rainMin, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)rainMin * one / 4.0f + countFactor * one + vFactor));
                    tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)rainMin, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)rainMin * one / 4.0f + countFactor * one + vFactor));
                    tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)rainMax, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)rainMax * one / 4.0f + countFactor * one + vFactor));
                    tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)rainMax, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)rainMax * one / 4.0f + countFactor * one + vFactor));
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                }
            }
            if (drawFlag >= 0) {
                tessellator.draw();
            }
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            mc.entityRenderer.disableLightmap((double)partialTicks);
        }
    }

    private void renderLockedStructure(float partialTicks, WorldClient world, Minecraft mc) {
        if (this.isNearLockedStructure((World)world, mc.renderViewEntity)) {
            this.initializeRainCoords();
            EntityLivingBase entitylivingbase = mc.renderViewEntity;
            int px = MathHelper.floor_double((double)entitylivingbase.posX);
            int py = MathHelper.floor_double((double)entitylivingbase.posY);
            int pz = MathHelper.floor_double((double)entitylivingbase.posZ);
            Tessellator tessellator = Tessellator.instance;
            GL11.glDisable((int)2884);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            double offX = entitylivingbase.lastTickPosX + (entitylivingbase.posX - entitylivingbase.lastTickPosX) * (double)partialTicks;
            double offY = entitylivingbase.lastTickPosY + (entitylivingbase.posY - entitylivingbase.lastTickPosY) * (double)partialTicks;
            double offZ = entitylivingbase.lastTickPosZ + (entitylivingbase.posZ - entitylivingbase.lastTickPosZ) * (double)partialTicks;
            int range = 5;
            if (mc.gameSettings.fancyGraphics) {
                range = 10;
            }
            int drawFlag = -1;
            float preciseCount = (float)this.rendererUpdateCount + partialTicks;
            if (mc.gameSettings.fancyGraphics) {
                range = 15;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int dz = pz - range; dz <= pz + range; ++dz) {
                for (int dx = px - range; dx <= px + range; ++dx) {
                    int rainIndex = (dz - pz + 16) * 32 + dx - px + 16;
                    float rainX = this.rainXCoords[rainIndex] * 0.5f;
                    float rainZ = this.rainYCoords[rainIndex] * 0.5f;
                    if (this.protectedBox == null || !this.protectedBox.intersectsWith(dx, dz, dx, dz)) continue;
                    int structureMin = this.protectedBox.minY - 4;
                    int structureMax = this.protectedBox.maxY + 4;
                    int rainMin = py - range;
                    int rainMax = py + range * 2;
                    if (rainMin < structureMin) {
                        rainMin = structureMin;
                    }
                    if (rainMax < structureMin) {
                        rainMax = structureMin;
                    }
                    if (rainMin > structureMax) {
                        rainMin = structureMax;
                    }
                    if (rainMax > structureMax) {
                        rainMax = structureMax;
                    }
                    float one = 1.0f;
                    if (rainMin == rainMax) continue;
                    this.random.setSeed(dx * dx * 3121 + dx * 45238971 ^ dz * dz * 418711 + dz * 13761);
                    if (drawFlag != 0) {
                        if (drawFlag >= 0) {
                            tessellator.draw();
                        }
                        drawFlag = 0;
                        mc.getTextureManager().bindTexture(locationSparklesPng);
                        tessellator.startDrawingQuads();
                    }
                    float countFactor = ((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    float uFactor = this.random.nextFloat() + preciseCount * 0.01f * (float)this.random.nextGaussian();
                    float vFactor = this.random.nextFloat() + preciseCount * 0.01f * (float)this.random.nextGaussian();
                    double xRange = (double)((float)dx + 0.5f) - entitylivingbase.posX;
                    double zRange = (double)((float)dz + 0.5f) - entitylivingbase.posZ;
                    float distanceFromPlayer = MathHelper.sqrt_double((double)(xRange * xRange + zRange * zRange)) / (float)range;
                    tessellator.setBrightness(983055);
                    float bright = 1.0f;
                    float alpha = this.random.nextFloat();
                    tessellator.setColorRGBA_F(bright, bright, bright, ((1.0f - distanceFromPlayer * distanceFromPlayer) * 0.3f + 0.5f) * alpha);
                    tessellator.setTranslation(-offX * 1.0, -offY * 1.0, -offZ * 1.0);
                    tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)rainMin, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)rainMin * one / 4.0f + countFactor * one + vFactor));
                    tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)rainMin, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)rainMin * one / 4.0f + countFactor * one + vFactor));
                    tessellator.addVertexWithUV((double)((float)dx + rainX) + 0.5, (double)rainMax, (double)((float)dz + rainZ) + 0.5, (double)(1.0f * one + uFactor), (double)((float)rainMax * one / 4.0f + countFactor * one + vFactor));
                    tessellator.addVertexWithUV((double)((float)dx - rainX) + 0.5, (double)rainMax, (double)((float)dz - rainZ) + 0.5, (double)(0.0f * one + uFactor), (double)((float)rainMax * one / 4.0f + countFactor * one + vFactor));
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                }
            }
            if (drawFlag >= 0) {
                tessellator.draw();
            }
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            mc.entityRenderer.disableLightmap((double)partialTicks);
        }
    }

    private void initializeRainCoords() {
        if (this.rainXCoords == null) {
            this.rainXCoords = new float[1024];
            this.rainYCoords = new float[1024];
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    float f2 = j - 16;
                    float f3 = i - 16;
                    float f4 = MathHelper.sqrt_float((float)(f2 * f2 + f3 * f3));
                    this.rainXCoords[i << 5 | j] = -f3 / f4;
                    this.rainYCoords[i << 5 | j] = f2 / f4;
                }
            }
        }
    }

    private boolean isNearLockedBiome(World world, EntityLivingBase viewEntity) {
        int range = 15;
        int px = MathHelper.floor_double((double)viewEntity.posX);
        int pz = MathHelper.floor_double((double)viewEntity.posZ);
        for (int z = pz - range; z <= pz + range; ++z) {
            for (int x = px - range; x <= px + range; ++x) {
                EntityPlayer player;
                TFBiomeBase tfBiome;
                BiomeGenBase biomegenbase = world.getBiomeGenForCoords(x, z);
                if (!(biomegenbase instanceof TFBiomeBase) || !(viewEntity instanceof EntityPlayer) || (tfBiome = (TFBiomeBase)biomegenbase).doesPlayerHaveRequiredAchievement(player = (EntityPlayer)viewEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNearLockedStructure(World world, EntityLivingBase viewEntity) {
        int range = 15;
        int px = MathHelper.floor_double((double)viewEntity.posX);
        int pz = MathHelper.floor_double((double)viewEntity.posZ);
        return this.protectedBox != null && this.protectedBox.intersectsWith(px - range, pz - range, px + range, pz + range);
    }

    public StructureBoundingBox getProtectedBox() {
        return this.protectedBox;
    }

    public void setProtectedBox(StructureBoundingBox protectedBox) {
        this.protectedBox = protectedBox;
    }
}

