/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model;

import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import twilightforest.client.model.ModelTFGhast;

public class ModelTFTowerBoss
extends ModelTFGhast {
    protected ModelRenderer[][] subTentacles;
    protected ModelRenderer[][] smallTentacles = new ModelRenderer[2][3];

    public ModelTFTowerBoss() {
        for (int i = 0; i < this.smallTentacles.length; ++i) {
            this.makeSmallTentacle(i);
        }
    }

    @Override
    protected void makeTentacle(byte yOffset, Random random, int num) {
        this.tentacles[num] = new ModelRenderer((ModelBase)this, num % 3, 0);
        int length = 5;
        this.tentacles[num].addBox(-1.5f, 0.0f, -1.5f, 3, length, 3);
        switch (num) {
            case 0: {
                this.tentacles[0].rotationPointX = 4.5f;
                this.tentacles[0].rotationPointZ = 4.5f;
                this.tentacles[0].rotationPointY = 23 + yOffset;
                break;
            }
            case 1: {
                this.tentacles[1].rotationPointX = -4.5f;
                this.tentacles[1].rotationPointZ = 4.5f;
                this.tentacles[1].rotationPointY = 23 + yOffset;
                break;
            }
            case 2: {
                this.tentacles[2].rotationPointX = 0.0f;
                this.tentacles[2].rotationPointZ = 0.0f;
                this.tentacles[2].rotationPointY = 23 + yOffset;
                break;
            }
            case 3: {
                this.tentacles[3].rotationPointX = 5.5f;
                this.tentacles[3].rotationPointZ = -4.5f;
                this.tentacles[3].rotationPointY = 23 + yOffset;
                break;
            }
            case 4: {
                this.tentacles[4].rotationPointX = -5.5f;
                this.tentacles[4].rotationPointZ = -4.5f;
                this.tentacles[4].rotationPointY = 23 + yOffset;
                break;
            }
            case 5: {
                this.tentacles[5].rotationPointX = -7.5f;
                this.tentacles[5].rotationPointY = 3.5f;
                this.tentacles[5].rotationPointZ = -1.0f;
                this.tentacles[5].rotateAngleZ = 0.7853982f;
                break;
            }
            case 6: {
                this.tentacles[6].rotationPointX = -7.5f;
                this.tentacles[6].rotationPointY = -1.5f;
                this.tentacles[6].rotationPointZ = 3.5f;
                this.tentacles[6].rotateAngleZ = 1.0471976f;
                break;
            }
            case 7: {
                this.tentacles[7].rotationPointX = 7.5f;
                this.tentacles[7].rotationPointY = 3.5f;
                this.tentacles[7].rotationPointZ = -1.0f;
                this.tentacles[7].rotateAngleZ = -0.7853982f;
                break;
            }
            case 8: {
                this.tentacles[8].rotationPointX = 7.5f;
                this.tentacles[8].rotationPointY = -1.5f;
                this.tentacles[8].rotationPointZ = 3.5f;
                this.tentacles[8].rotateAngleZ = -1.0471976f;
            }
        }
        if (this.subTentacles == null) {
            this.subTentacles = new ModelRenderer[this.tentacles.length][3];
        }
        for (int i = 0; i < 3; ++i) {
            length = 4;
            this.subTentacles[num][i] = new ModelRenderer((ModelBase)this, num % 4, i * 5 - 1);
            this.subTentacles[num][i].addBox(-1.5f, -0.5f, -1.5f, 3, length, 3);
            this.subTentacles[num][i].rotationPointX = 0.0f;
            this.subTentacles[num][i].rotationPointZ = 0.0f;
            this.subTentacles[num][i].rotationPointY = length;
            if (i == 0) {
                this.tentacles[num].addChild(this.subTentacles[num][i]);
                continue;
            }
            this.subTentacles[num][i - 1].addChild(this.subTentacles[num][i]);
        }
        this.body.addChild(this.tentacles[num]);
    }

    protected void makeSmallTentacle(int num) {
    }

    @Override
    public void setRotationAngles(float par1, float par2, float timeAlive, float yaw, float pitch, float par6, Entity entity) {
        super.setRotationAngles(par1, par2, timeAlive, yaw, pitch, par6, entity);
        for (int i = 0; i < this.subTentacles.length; ++i) {
            float wiggle = Math.min(par2, 0.6f);
            float time = (timeAlive + (float)(i * 9)) / 2.0f;
            this.subTentacles[i][0].rotateAngleX = (MathHelper.cos((float)(time * 0.6662f)) * 1.0f - 1.0471976f) * wiggle;
            this.subTentacles[i][1].rotateAngleX = MathHelper.cos((float)(time * 0.7774f)) * 1.2f * wiggle;
            this.subTentacles[i][2].rotateAngleX = MathHelper.cos((float)(time * 0.8886f + 1.5707964f)) * 1.4f * wiggle;
            this.subTentacles[i][0].rotateAngleX = 0.2f + MathHelper.cos((float)(time * 0.3335f)) * 0.15f;
            this.subTentacles[i][1].rotateAngleX = 0.1f + MathHelper.cos((float)(time * 0.4445f)) * 0.2f;
            this.subTentacles[i][2].rotateAngleX = 0.1f + MathHelper.cos((float)(time * 0.5555f)) * 0.25f;
            float yTwist = 0.4f;
            this.tentacles[i].rotateAngleY = yTwist * MathHelper.sin((float)(time * 0.3f));
        }
    }
}

