/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.item.TFItems;

public class BlockTFUberousSoil
extends Block
implements IGrowable {
    protected BlockTFUberousSoil() {
        super(Material.ground);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.setLightOpacity(255);
        this.setHardness(0.6f);
        this.setStepSound(soundTypeGravel);
        this.setTickRandomly(true);
        this.setBlockTextureName("TwilightForest:uberous_soil");
        this.setCreativeTab(TFItems.creativeTab);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public Item getItemDropped(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Blocks.dirt.getItemDropped(0, p_149650_2_, p_149650_3_);
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        Material aboveMaterial = world.getBlock(x, y + 1, z).getMaterial();
        if (aboveMaterial.isSolid()) {
            world.setBlock(x, y, z, Blocks.dirt);
        }
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, x, y + 1, z);
        return plantType == EnumPlantType.Crop || plantType == EnumPlantType.Plains || plantType == EnumPlantType.Cave;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighbor) {
        Block above = world.getBlock(x, y + 1, z);
        Material aboveMaterial = above.getMaterial();
        if (aboveMaterial.isSolid()) {
            world.setBlock(x, y, z, Blocks.dirt);
        }
        if (above instanceof IPlantable) {
            IPlantable plant = (IPlantable)above;
            if (plant.getPlantType((IBlockAccess)world, x, y + 1, z) == EnumPlantType.Crop) {
                world.setBlock(x, y, z, Blocks.farmland, 2, 2);
            } else if (plant.getPlantType((IBlockAccess)world, x, y + 1, z) == EnumPlantType.Plains) {
                world.setBlock(x, y, z, (Block)Blocks.grass);
            } else {
                world.setBlock(x, y, z, Blocks.dirt);
            }
            ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.dye), (World)world, (int)x, (int)(y + 1), (int)z, null);
            ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.dye), (World)world, (int)x, (int)(y + 1), (int)z, null);
            ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.dye), (World)world, (int)x, (int)(y + 1), (int)z, null);
            ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.dye), (World)world, (int)x, (int)(y + 1), (int)z, null);
            if (!world.isRemote) {
                world.playAuxSFX(2005, x, y + 1, z, 0);
            }
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean var5) {
        return true;
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        int gx = x;
        int gy = y;
        int gz = z;
        if (rand.nextBoolean()) {
            gx += rand.nextBoolean() ? 1 : -1;
        } else {
            gz += rand.nextBoolean() ? 1 : -1;
        }
        Block blockAt = world.getBlock(gx, gy, gz);
        if (world.isAirBlock(gx, gy + 1, gz) && (blockAt == Blocks.dirt || blockAt == Blocks.grass || blockAt == Blocks.farmland)) {
            world.setBlock(gx, gy, gz, (Block)this);
        }
    }
}

